/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.model.BindingGraph;
import dagger.model.BindingKind;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

final class MapMultibindingValidation
implements BindingGraphPlugin {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    MapMultibindingValidation(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    public String pluginName() {
        return "Dagger/MapKeys";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        for (BindingGraph.BindingNode node : bindingGraph.bindingNodes()) {
            if (!node.binding().kind().equals((Object)BindingKind.MULTIBOUND_MAP)) continue;
            ImmutableSet<ContributionBinding> contributions = this.mapBindingContributions(node, bindingGraph);
            this.checkForDuplicateMapKeys(node, contributions, diagnosticReporter);
            this.checkForInconsistentMapKeyAnnotationTypes(node, contributions, diagnosticReporter);
        }
    }

    private ImmutableSet<ContributionBinding> mapBindingContributions(BindingGraph.BindingNode bindingNode, BindingGraph bindingGraph) {
        Preconditions.checkArgument((boolean)bindingNode.binding().kind().equals((Object)BindingKind.MULTIBOUND_MAP));
        return bindingGraph.successors((Object)bindingNode).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.BindingNode.class)).map(node -> (ContributionBinding)node.binding()).collect(DaggerStreams.toImmutableSet());
    }

    private void checkForDuplicateMapKeys(BindingGraph.BindingNode multiboundMapBindingNode, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap contributionsByMapKey = ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, ContributionBinding::mapKey));
        for (Set contributionsForOneMapKey : Multimaps.asMap((SetMultimap)contributionsByMapKey).values()) {
            if (contributionsForOneMapKey.size() <= 1) continue;
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, multiboundMapBindingNode, this.duplicateMapKeyErrorMessage(contributionsForOneMapKey, multiboundMapBindingNode.binding().key()));
        }
    }

    private void checkForInconsistentMapKeyAnnotationTypes(BindingGraph.BindingNode multiboundMapBindingNode, ImmutableSet<ContributionBinding> contributions, DiagnosticReporter diagnosticReporter) {
        ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> contributionsByMapKeyAnnotationType = MapMultibindingValidation.indexByMapKeyAnnotationType(contributions);
        if (contributionsByMapKeyAnnotationType.keySet().size() > 1) {
            diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, multiboundMapBindingNode, this.inconsistentMapKeyAnnotationTypesErrorMessage(contributionsByMapKeyAnnotationType, multiboundMapBindingNode.binding().key()));
        }
    }

    private static ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> indexByMapKeyAnnotationType(ImmutableSet<ContributionBinding> contributions) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(contributions, mapBinding -> MoreTypes.equivalence().wrap((Object)mapBinding.mapKeyAnnotation().get().getAnnotationType())));
    }

    private String inconsistentMapKeyAnnotationTypesErrorMessage(ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> contributionsByMapKeyAnnotationType, Key mapBindingKey) {
        StringBuilder message = new StringBuilder(mapBindingKey.toString()).append(" uses more than one @MapKey annotation type");
        Multimaps.asMap(contributionsByMapKeyAnnotationType).forEach((annotationType, contributions) -> {
            message.append('\n').append("    ").append(annotationType.get()).append(':');
            this.bindingDeclarationFormatter.formatIndentedList(message, contributions, 2, 10);
        });
        return message.toString();
    }

    private String duplicateMapKeyErrorMessage(Set<ContributionBinding> contributionsForOneMapKey, Key mapBindingKey) {
        StringBuilder message = new StringBuilder("The same map key is bound more than once for ").append(mapBindingKey);
        this.bindingDeclarationFormatter.formatIndentedList(message, contributionsForOneMapKey, 1, 10);
        return message.toString();
    }
}

