/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SourceFiles;
import dagger.producers.Produced;
import dagger.producers.Producer;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;

final class MapFactoryCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    MapFactoryCreationExpression(ContributionBinding binding, GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        boolean useRawType;
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.", new Object[]{SourceFiles.mapFactoryClassName(this.binding)});
        boolean bl = useRawType = !this.generatedComponentModel.isTypeAccessible(this.binding.key().type());
        if (!useRawType) {
            MapType mapType = MapType.from(this.binding.key().type());
            TypeMirror valueType = mapType.valueType();
            for (Class frameworkClass : ImmutableSet.of(Provider.class, Producer.class, Produced.class)) {
                if (!mapType.valuesAreTypeOf(frameworkClass)) continue;
                valueType = mapType.unwrappedValueType(frameworkClass);
                break;
            }
            builder.add("<$T, $T>", new Object[]{mapType.keyType(), valueType});
        }
        ImmutableList<FrameworkDependency> frameworkDependencies = this.binding.frameworkDependencies();
        if (this.binding.bindingType().equals((Object)BindingType.PROVISION)) {
            builder.add("builder($L)", new Object[]{frameworkDependencies.size()});
        } else {
            builder.add("builder()", new Object[0]);
        }
        for (FrameworkDependency frameworkDependency : frameworkDependencies) {
            ContributionBinding contributionBinding = ((ResolvedBindings)this.graph.contributionBindings().get((Object)frameworkDependency.key())).contributionBinding();
            CodeBlock value = this.componentBindingExpressions.getDependencyExpression(frameworkDependency, this.generatedComponentModel.name()).codeBlock();
            builder.add(".put($L, $L)", new Object[]{MapKeys.getMapKeyExpression(contributionBinding, this.generatedComponentModel.name()), useRawType ? CodeBlocks.cast(value, frameworkDependency.frameworkClass()) : value});
        }
        builder.add(".build()", new Object[0]);
        return builder.build();
    }

    @Override
    public boolean useInnerSwitchingProvider() {
        return !this.binding.dependencies().isEmpty();
    }
}

