/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.model.BindingKind;
import dagger.model.Key;
import dagger.multibindings.Multibinds;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentRequirement {
    ComponentRequirement() {
    }

    abstract Kind kind();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    TypeElement typeElement() {
        return MoreTypes.asTypeElement(this.type());
    }

    abstract Optional<NullPolicy> overrideNullPolicy();

    NullPolicy nullPolicy(Elements elements, Types types) {
        if (this.overrideNullPolicy().isPresent()) {
            return this.overrideNullPolicy().get();
        }
        switch (this.kind()) {
            case MODULE: {
                return Util.componentCanMakeNewInstances(this.typeElement()) ? NullPolicy.NEW : (this.requiresAPassedInstance(elements, types) ? NullPolicy.THROW : NullPolicy.ALLOW);
            }
            case DEPENDENCY: 
            case BOUND_INSTANCE: {
                return NullPolicy.THROW;
            }
        }
        throw new AssertionError();
    }

    boolean requiresAPassedInstance(Elements elements, Types types) {
        if (this.kind().equals((Object)Kind.BOUND_INSTANCE)) {
            return true;
        }
        ImmutableSet<ExecutableElement> methods = MoreElements.getLocalAndInheritedMethods(this.typeElement(), types, elements);
        boolean foundInstanceMethod = false;
        for (ExecutableElement method : methods) {
            if (method.getModifiers().contains((Object)Modifier.ABSTRACT) && !DaggerElements.isAnyAnnotationPresent(method, Binds.class, Multibinds.class, BindsOptionalOf.class)) {
                return true;
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC) || !DaggerElements.isAnyAnnotationPresent(method, Provides.class, Produces.class)) continue;
            foundInstanceMethod = true;
        }
        if (foundInstanceMethod) {
            return !Util.componentCanMakeNewInstances(this.typeElement());
        }
        return false;
    }

    abstract Optional<Key> key();

    abstract String variableName();

    static ComponentRequirement forDependency(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.DEPENDENCY, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)((TypeMirror)Preconditions.checkNotNull((Object)type))), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    static ComponentRequirement forModule(TypeMirror type) {
        return new AutoValue_ComponentRequirement(Kind.MODULE, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)((TypeMirror)Preconditions.checkNotNull((Object)type))), Optional.empty(), Optional.empty(), SourceFiles.simpleVariableName(MoreTypes.asTypeElement(type)));
    }

    static ComponentRequirement forBoundInstance(Key key, boolean nullable, String variableName) {
        return new AutoValue_ComponentRequirement(Kind.BOUND_INSTANCE, (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)key.type()), nullable ? Optional.of(NullPolicy.ALLOW) : Optional.empty(), Optional.of(key), variableName);
    }

    static ComponentRequirement forBoundInstance(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.kind().equals((Object)BindingKind.BOUND_INSTANCE));
        return ComponentRequirement.forBoundInstance(binding.key(), binding.nullableType().isPresent(), binding.bindingElement().get().getSimpleName().toString());
    }

    static enum NullPolicy {
        NEW,
        THROW,
        ALLOW;

    }

    static enum Kind {
        DEPENDENCY,
        MODULE,
        BOUND_INSTANCE;

    }
}

