/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Traverser;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.model.Scope;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

abstract class BindingGraph {
    private static final Traverser<BindingGraph> SUBGRAPH_TRAVERSER = Traverser.forTree(BindingGraph::subgraphs);

    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<Key, ResolvedBindings> contributionBindings();

    abstract ImmutableMap<Key, ResolvedBindings> membersInjectionBindings();

    final ResolvedBindings resolvedBindings(RequestKind requestKind, Key key) {
        return requestKind.equals((Object)RequestKind.MEMBERS_INJECTION) ? (ResolvedBindings)this.membersInjectionBindings().get((Object)key) : (ResolvedBindings)this.contributionBindings().get((Object)key);
    }

    ImmutableSet<ResolvedBindings> resolvedBindings() {
        return ImmutableSet.builder().addAll((Iterable)this.membersInjectionBindings().values()).addAll((Iterable)this.contributionBindings().values()).build();
    }

    abstract ImmutableSet<BindingGraph> subgraphs();

    abstract ImmutableSet<Scope> scopesRequiringReleasableReferenceManagers();

    ImmutableSet<ResolvedBindings> resolvedDependencies(ContributionBinding binding) {
        return binding.dependencies().stream().map(DependencyRequest::key).map(key -> (ResolvedBindings)this.contributionBindings().getOrDefault(key, (Object)ResolvedBindings.noBindings(key, this.componentDescriptor()))).collect(DaggerStreams.toImmutableSet());
    }

    TypeElement componentType() {
        return this.componentDescriptor().componentDefinitionType();
    }

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    abstract Optional<ExecutableElement> factoryMethod();

    ImmutableMap<ComponentRequirement, VariableElement> factoryMethodParameters() {
        Preconditions.checkState((boolean)this.factoryMethod().isPresent());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (VariableElement variableElement : this.factoryMethod().get().getParameters()) {
            builder.put((Object)ComponentRequirement.forModule(variableElement.asType()), (Object)variableElement);
        }
        return builder.build();
    }

    ImmutableSet<ComponentRequirement> componentRequirements() {
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        StreamSupport.stream(SUBGRAPH_TRAVERSER.depthFirstPreOrder((Object)this).spliterator(), false).flatMap(graph -> graph.contributionBindings().values().stream()).flatMap(bindings -> bindings.contributionBindings().stream()).filter(ContributionBinding::requiresModuleInstance).map(bindingDeclaration -> bindingDeclaration.contributingModule()).filter(Optional::isPresent).map(Optional::get).filter(module -> this.ownedModuleTypes().contains(module)).map(module -> ComponentRequirement.forModule(module.asType())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.factoryMethod().isPresent()) {
            this.factoryMethodParameters().keySet().forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        }
        this.componentDescriptor().dependencies().stream().forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.componentDescriptor().builderSpec().isPresent()) {
            this.componentDescriptor().builderSpec().get().requirementMethods().stream().map(ComponentDescriptor.BuilderRequirementMethod::requirement).filter(req -> req.kind().equals((Object)ComponentRequirement.Kind.BOUND_INSTANCE)).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        }
        return requirements.build();
    }

    ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return FluentIterable.from((Iterable)SUBGRAPH_TRAVERSER.depthFirstPreOrder((Object)this)).transform(BindingGraph::componentDescriptor).toSet();
    }

    ImmutableSet<ComponentRequirement> availableDependencies() {
        return Stream.concat(this.componentDescriptor().transitiveModuleTypes().stream().filter(dep -> !dep.getModifiers().contains((Object)Modifier.ABSTRACT)).map(module -> ComponentRequirement.forModule(module.asType())), this.componentDescriptor().dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    static BindingGraph create(ComponentDescriptor componentDescriptor, ImmutableMap<Key, ResolvedBindings> resolvedContributionBindingsMap, ImmutableMap<Key, ResolvedBindings> resolvedMembersInjectionBindings, ImmutableSet<BindingGraph> subgraphs, ImmutableSet<Scope> scopesRequiringReleasableReferenceManagers, ImmutableSet<ModuleDescriptor> ownedModules, Optional<ExecutableElement> factoryMethod) {
        return new AutoValue_BindingGraph(componentDescriptor, resolvedContributionBindingsMap, resolvedMembersInjectionBindings, subgraphs, scopesRequiringReleasableReferenceManagers, ownedModules, factoryMethod);
    }
}

