/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3.AdaptiveMtDataset;
import com.google.cloud.translate.v3.AdaptiveMtFile;
import com.google.cloud.translate.v3.AdaptiveMtTranslateRequest;
import com.google.cloud.translate.v3.AdaptiveMtTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateMetadata;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.CreateGlossaryMetadata;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.DeleteAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.DeleteAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.GetAdaptiveMtDatasetRequest;
import com.google.cloud.translate.v3.GetAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest;
import com.google.cloud.translate.v3.ImportAdaptiveMtFileResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtDatasetsResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesRequest;
import com.google.cloud.translate.v3.ListAdaptiveMtSentencesResponse;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceClient;
import com.google.cloud.translate.v3.stub.GrpcTranslationServiceCallableFactory;
import com.google.cloud.translate.v3.stub.TranslationServiceStub;
import com.google.cloud.translate.v3.stub.TranslationServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTranslationServiceStub
extends TranslationServiceStub {
    private static final MethodDescriptor<TranslateTextRequest, TranslateTextResponse> translateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/TranslateText").setRequestMarshaller(ProtoUtils.marshaller((Message)TranslateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TranslateTextResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DetectLanguageRequest, DetectLanguageResponse> detectLanguageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/DetectLanguage").setRequestMarshaller(ProtoUtils.marshaller((Message)DetectLanguageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DetectLanguageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/GetSupportedLanguages").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSupportedLanguagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SupportedLanguages.getDefaultInstance())).build();
    private static final MethodDescriptor<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/TranslateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)TranslateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TranslateDocumentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchTranslateTextRequest, Operation> batchTranslateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/BatchTranslateText").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchTranslateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/BatchTranslateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchTranslateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateGlossaryRequest, Operation> createGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/CreateGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListGlossariesRequest, ListGlossariesResponse> listGlossariesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/ListGlossaries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGlossariesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGlossariesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGlossaryRequest, Glossary> getGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/GetGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Glossary.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteGlossaryRequest, Operation> deleteGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/DeleteGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/CreateAdaptiveMtDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAdaptiveMtDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdaptiveMtDataset.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAdaptiveMtDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/GetAdaptiveMtDataset").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdaptiveMtDatasetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdaptiveMtDataset.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse> listAdaptiveMtDatasetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/ListAdaptiveMtDatasets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtDatasetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtDatasetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/AdaptiveMtTranslate").setRequestMarshaller(ProtoUtils.marshaller((Message)AdaptiveMtTranslateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdaptiveMtTranslateResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/GetAdaptiveMtFile").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdaptiveMtFileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdaptiveMtFile.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/DeleteAdaptiveMtFile").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAdaptiveMtFileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/ImportAdaptiveMtFile").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportAdaptiveMtFileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ImportAdaptiveMtFileResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse> listAdaptiveMtFilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/ListAdaptiveMtFiles").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtFilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtFilesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse> listAdaptiveMtSentencesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3.TranslationService/ListAdaptiveMtSentences").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtSentencesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAdaptiveMtSentencesResponse.getDefaultInstance())).build();
    private final UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable;
    private final UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable;
    private final UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable;
    private final UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable;
    private final UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable;
    private final OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable;
    private final UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable;
    private final OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable;
    private final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable;
    private final OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable;
    private final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable;
    private final UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable;
    private final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable;
    private final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable;
    private final OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable;
    private final UnaryCallable<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetCallable;
    private final UnaryCallable<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetCallable;
    private final UnaryCallable<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetCallable;
    private final UnaryCallable<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse> listAdaptiveMtDatasetsCallable;
    private final UnaryCallable<ListAdaptiveMtDatasetsRequest, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsPagedCallable;
    private final UnaryCallable<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateCallable;
    private final UnaryCallable<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileCallable;
    private final UnaryCallable<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileCallable;
    private final UnaryCallable<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileCallable;
    private final UnaryCallable<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse> listAdaptiveMtFilesCallable;
    private final UnaryCallable<ListAdaptiveMtFilesRequest, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesPagedCallable;
    private final UnaryCallable<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse> listAdaptiveMtSentencesCallable;
    private final UnaryCallable<ListAdaptiveMtSentencesRequest, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTranslationServiceStub create(TranslationServiceStubSettings settings) throws IOException {
        return new GrpcTranslationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTranslationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTranslationServiceStub(TranslationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTranslationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTranslationServiceStub(TranslationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTranslationServiceCallableFactory());
    }

    protected GrpcTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings translateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(translateTextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings detectLanguageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detectLanguageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSupportedLanguagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSupportedLanguagesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings translateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(translateDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchTranslateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchTranslateTextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchTranslateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchTranslateDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listGlossariesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGlossariesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createAdaptiveMtDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAdaptiveMtDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAdaptiveMtDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAdaptiveMtDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAdaptiveMtDatasetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdaptiveMtDatasetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listAdaptiveMtDatasetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAdaptiveMtDatasetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings adaptiveMtTranslateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(adaptiveMtTranslateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getAdaptiveMtFileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdaptiveMtFileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAdaptiveMtFileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAdaptiveMtFileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importAdaptiveMtFileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importAdaptiveMtFileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listAdaptiveMtFilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAdaptiveMtFilesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listAdaptiveMtSentencesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAdaptiveMtSentencesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.translateTextCallable = callableFactory.createUnaryCallable(translateTextTransportSettings, settings.translateTextSettings(), clientContext);
        this.detectLanguageCallable = callableFactory.createUnaryCallable(detectLanguageTransportSettings, settings.detectLanguageSettings(), clientContext);
        this.getSupportedLanguagesCallable = callableFactory.createUnaryCallable(getSupportedLanguagesTransportSettings, settings.getSupportedLanguagesSettings(), clientContext);
        this.translateDocumentCallable = callableFactory.createUnaryCallable(translateDocumentTransportSettings, settings.translateDocumentSettings(), clientContext);
        this.batchTranslateTextCallable = callableFactory.createUnaryCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextSettings(), clientContext);
        this.batchTranslateTextOperationCallable = callableFactory.createOperationCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.batchTranslateDocumentCallable = callableFactory.createUnaryCallable(batchTranslateDocumentTransportSettings, settings.batchTranslateDocumentSettings(), clientContext);
        this.batchTranslateDocumentOperationCallable = callableFactory.createOperationCallable(batchTranslateDocumentTransportSettings, settings.batchTranslateDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createGlossaryCallable = callableFactory.createUnaryCallable(createGlossaryTransportSettings, settings.createGlossarySettings(), clientContext);
        this.createGlossaryOperationCallable = callableFactory.createOperationCallable(createGlossaryTransportSettings, settings.createGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listGlossariesCallable = callableFactory.createUnaryCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.listGlossariesPagedCallable = callableFactory.createPagedCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.getGlossaryCallable = callableFactory.createUnaryCallable(getGlossaryTransportSettings, settings.getGlossarySettings(), clientContext);
        this.deleteGlossaryCallable = callableFactory.createUnaryCallable(deleteGlossaryTransportSettings, settings.deleteGlossarySettings(), clientContext);
        this.deleteGlossaryOperationCallable = callableFactory.createOperationCallable(deleteGlossaryTransportSettings, settings.deleteGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createAdaptiveMtDatasetCallable = callableFactory.createUnaryCallable(createAdaptiveMtDatasetTransportSettings, settings.createAdaptiveMtDatasetSettings(), clientContext);
        this.deleteAdaptiveMtDatasetCallable = callableFactory.createUnaryCallable(deleteAdaptiveMtDatasetTransportSettings, settings.deleteAdaptiveMtDatasetSettings(), clientContext);
        this.getAdaptiveMtDatasetCallable = callableFactory.createUnaryCallable(getAdaptiveMtDatasetTransportSettings, settings.getAdaptiveMtDatasetSettings(), clientContext);
        this.listAdaptiveMtDatasetsCallable = callableFactory.createUnaryCallable(listAdaptiveMtDatasetsTransportSettings, settings.listAdaptiveMtDatasetsSettings(), clientContext);
        this.listAdaptiveMtDatasetsPagedCallable = callableFactory.createPagedCallable(listAdaptiveMtDatasetsTransportSettings, settings.listAdaptiveMtDatasetsSettings(), clientContext);
        this.adaptiveMtTranslateCallable = callableFactory.createUnaryCallable(adaptiveMtTranslateTransportSettings, settings.adaptiveMtTranslateSettings(), clientContext);
        this.getAdaptiveMtFileCallable = callableFactory.createUnaryCallable(getAdaptiveMtFileTransportSettings, settings.getAdaptiveMtFileSettings(), clientContext);
        this.deleteAdaptiveMtFileCallable = callableFactory.createUnaryCallable(deleteAdaptiveMtFileTransportSettings, settings.deleteAdaptiveMtFileSettings(), clientContext);
        this.importAdaptiveMtFileCallable = callableFactory.createUnaryCallable(importAdaptiveMtFileTransportSettings, settings.importAdaptiveMtFileSettings(), clientContext);
        this.listAdaptiveMtFilesCallable = callableFactory.createUnaryCallable(listAdaptiveMtFilesTransportSettings, settings.listAdaptiveMtFilesSettings(), clientContext);
        this.listAdaptiveMtFilesPagedCallable = callableFactory.createPagedCallable(listAdaptiveMtFilesTransportSettings, settings.listAdaptiveMtFilesSettings(), clientContext);
        this.listAdaptiveMtSentencesCallable = callableFactory.createUnaryCallable(listAdaptiveMtSentencesTransportSettings, settings.listAdaptiveMtSentencesSettings(), clientContext);
        this.listAdaptiveMtSentencesPagedCallable = callableFactory.createPagedCallable(listAdaptiveMtSentencesTransportSettings, settings.listAdaptiveMtSentencesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable() {
        return this.translateTextCallable;
    }

    @Override
    public UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable() {
        return this.detectLanguageCallable;
    }

    @Override
    public UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable() {
        return this.getSupportedLanguagesCallable;
    }

    @Override
    public UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable() {
        return this.translateDocumentCallable;
    }

    @Override
    public UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable() {
        return this.batchTranslateTextCallable;
    }

    @Override
    public OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable() {
        return this.batchTranslateTextOperationCallable;
    }

    @Override
    public UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable() {
        return this.batchTranslateDocumentCallable;
    }

    @Override
    public OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable() {
        return this.batchTranslateDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.createGlossaryCallable;
    }

    @Override
    public OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable() {
        return this.createGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.listGlossariesCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.listGlossariesPagedCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.getGlossaryCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.deleteGlossaryCallable;
    }

    @Override
    public OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable() {
        return this.deleteGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<CreateAdaptiveMtDatasetRequest, AdaptiveMtDataset> createAdaptiveMtDatasetCallable() {
        return this.createAdaptiveMtDatasetCallable;
    }

    @Override
    public UnaryCallable<DeleteAdaptiveMtDatasetRequest, Empty> deleteAdaptiveMtDatasetCallable() {
        return this.deleteAdaptiveMtDatasetCallable;
    }

    @Override
    public UnaryCallable<GetAdaptiveMtDatasetRequest, AdaptiveMtDataset> getAdaptiveMtDatasetCallable() {
        return this.getAdaptiveMtDatasetCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtDatasetsRequest, ListAdaptiveMtDatasetsResponse> listAdaptiveMtDatasetsCallable() {
        return this.listAdaptiveMtDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtDatasetsRequest, TranslationServiceClient.ListAdaptiveMtDatasetsPagedResponse> listAdaptiveMtDatasetsPagedCallable() {
        return this.listAdaptiveMtDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<AdaptiveMtTranslateRequest, AdaptiveMtTranslateResponse> adaptiveMtTranslateCallable() {
        return this.adaptiveMtTranslateCallable;
    }

    @Override
    public UnaryCallable<GetAdaptiveMtFileRequest, AdaptiveMtFile> getAdaptiveMtFileCallable() {
        return this.getAdaptiveMtFileCallable;
    }

    @Override
    public UnaryCallable<DeleteAdaptiveMtFileRequest, Empty> deleteAdaptiveMtFileCallable() {
        return this.deleteAdaptiveMtFileCallable;
    }

    @Override
    public UnaryCallable<ImportAdaptiveMtFileRequest, ImportAdaptiveMtFileResponse> importAdaptiveMtFileCallable() {
        return this.importAdaptiveMtFileCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtFilesRequest, ListAdaptiveMtFilesResponse> listAdaptiveMtFilesCallable() {
        return this.listAdaptiveMtFilesCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtFilesRequest, TranslationServiceClient.ListAdaptiveMtFilesPagedResponse> listAdaptiveMtFilesPagedCallable() {
        return this.listAdaptiveMtFilesPagedCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtSentencesRequest, ListAdaptiveMtSentencesResponse> listAdaptiveMtSentencesCallable() {
        return this.listAdaptiveMtSentencesCallable;
    }

    @Override
    public UnaryCallable<ListAdaptiveMtSentencesRequest, TranslationServiceClient.ListAdaptiveMtSentencesPagedResponse> listAdaptiveMtSentencesPagedCallable() {
        return this.listAdaptiveMtSentencesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

