/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.TransactionOptions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.opencensus.trace.Tracing;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Transaction
extends UpdateBuilder<Transaction> {
    private static final String READ_BEFORE_WRITE_ERROR_MSG = "Firestore transactions require all reads to be executed before all writes";
    private final TransactionOptions transactionOptions;
    @Nullable
    private final ByteString previousTransactionId;
    private ByteString transactionId;

    Transaction(FirestoreImpl firestore, TransactionOptions transactionOptions, @Nullable Transaction previousTransaction) {
        super(firestore);
        this.transactionOptions = transactionOptions;
        this.previousTransactionId = previousTransaction != null ? previousTransaction.transactionId : null;
    }

    @Override
    Transaction wrapResult(ApiFuture<WriteResult> result) {
        return this;
    }

    ApiFuture<Void> begin() {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.BeginTransaction");
        BeginTransactionRequest.Builder beginTransaction = BeginTransactionRequest.newBuilder();
        beginTransaction.setDatabase(this.firestore.getDatabaseName());
        if (TransactionOptions.TransactionOptionsType.READ_WRITE.equals((Object)this.transactionOptions.getType()) && this.previousTransactionId != null) {
            beginTransaction.getOptionsBuilder().getReadWriteBuilder().setRetryTransaction(this.previousTransactionId);
        } else if (TransactionOptions.TransactionOptionsType.READ_ONLY.equals((Object)this.transactionOptions.getType())) {
            TransactionOptions.ReadOnly.Builder readOnlyBuilder = TransactionOptions.ReadOnly.newBuilder();
            if (this.transactionOptions.getReadTime() != null) {
                readOnlyBuilder.setReadTime(this.transactionOptions.getReadTime());
            }
            beginTransaction.getOptionsBuilder().setReadOnly(readOnlyBuilder);
        }
        ApiFuture<BeginTransactionResponse> transactionBeginFuture = this.firestore.sendRequest(beginTransaction.build(), this.firestore.getClient().beginTransactionCallable());
        return ApiFutures.transform(transactionBeginFuture, (ApiFunction)new ApiFunction<BeginTransactionResponse, Void>(){

            public Void apply(BeginTransactionResponse beginTransactionResponse) {
                Transaction.this.transactionId = beginTransactionResponse.getTransaction();
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    ApiFuture<List<WriteResult>> commit() {
        return super.commit(this.transactionId);
    }

    ApiFuture<Void> rollback() {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.Rollback");
        RollbackRequest.Builder reqBuilder = RollbackRequest.newBuilder();
        reqBuilder.setTransaction(this.transactionId);
        reqBuilder.setDatabase(this.firestore.getDatabaseName());
        ApiFuture<Empty> rollbackFuture = this.firestore.sendRequest(reqBuilder.build(), this.firestore.getClient().rollbackCallable());
        return ApiFutures.transform(rollbackFuture, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty beginTransactionResponse) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Nonnull
    public ApiFuture<DocumentSnapshot> get(@Nonnull DocumentReference documentRef) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.GetDocument");
        return ApiFutures.transform(this.firestore.getAll(new DocumentReference[]{documentRef}, null, this.transactionId), (ApiFunction)new ApiFunction<List<DocumentSnapshot>, DocumentSnapshot>(){

            public DocumentSnapshot apply(List<DocumentSnapshot> snapshots) {
                return snapshots.isEmpty() ? null : snapshots.get(0);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(DocumentReference ... documentReferences) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, null, this.transactionId);
    }

    @Nonnull
    public ApiFuture<List<DocumentSnapshot>> getAll(@Nonnull DocumentReference[] documentReferences, @Nullable FieldMask fieldMask) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return this.firestore.getAll(documentReferences, fieldMask, this.transactionId);
    }

    @Nonnull
    public ApiFuture<QuerySnapshot> get(@Nonnull Query query) {
        Preconditions.checkState((boolean)this.isEmpty(), (Object)READ_BEFORE_WRITE_ERROR_MSG);
        return query.get(this.transactionId);
    }

    public static interface AsyncFunction<T> {
        public ApiFuture<T> updateCallback(Transaction var1);
    }

    public static interface Function<T> {
        public T updateCallback(Transaction var1) throws Exception;
    }
}

