/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

final class TypeVariables {
    private TypeVariables() {
    }

    static ImmutableSet<TypeVariable> getReferencedTypeVariables(TypeMirror type) {
        Preconditions.checkNotNull((Object)type);
        return type.accept(ReferencedTypeVariables.INSTANCE, new HashSet());
    }

    private static final class ReferencedTypeVariables
    extends SimpleTypeVisitor8<ImmutableSet<TypeVariable>, Set<Element>> {
        private static final ReferencedTypeVariables INSTANCE = new ReferencedTypeVariables();

        ReferencedTypeVariables() {
            super(ImmutableSet.of());
        }

        @Override
        public ImmutableSet<TypeVariable> visitArray(ArrayType t, Set<Element> visited) {
            return t.getComponentType().accept(this, visited);
        }

        @Override
        public ImmutableSet<TypeVariable> visitDeclared(DeclaredType t, Set<Element> visited) {
            if (!visited.add(t.asElement())) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder typeVariables = ImmutableSet.builder();
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                typeVariables.addAll((Iterable)typeMirror.accept(this, visited));
            }
            return typeVariables.build();
        }

        @Override
        public ImmutableSet<TypeVariable> visitTypeVariable(TypeVariable t, Set<Element> visited) {
            if (!visited.add(t.asElement())) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder typeVariables = ImmutableSet.builder();
            typeVariables.add((Object)t);
            typeVariables.addAll((Iterable)t.getLowerBound().accept(this, visited));
            typeVariables.addAll((Iterable)t.getUpperBound().accept(this, visited));
            return typeVariables.build();
        }

        @Override
        public ImmutableSet<TypeVariable> visitUnion(UnionType t, Set<Element> visited) {
            ImmutableSet.Builder typeVariables = ImmutableSet.builder();
            for (TypeMirror typeMirror : t.getAlternatives()) {
                typeVariables.addAll((Iterable)typeMirror.accept(this, visited));
            }
            return typeVariables.build();
        }

        @Override
        public ImmutableSet<TypeVariable> visitIntersection(IntersectionType t, Set<Element> visited) {
            ImmutableSet.Builder typeVariables = ImmutableSet.builder();
            for (TypeMirror typeMirror : t.getBounds()) {
                typeVariables.addAll((Iterable)typeMirror.accept(this, visited));
            }
            return typeVariables.build();
        }

        @Override
        public ImmutableSet<TypeVariable> visitWildcard(WildcardType t, Set<Element> visited) {
            TypeMirror superBound;
            ImmutableSet.Builder typeVariables = ImmutableSet.builder();
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                typeVariables.addAll((Iterable)extendsBound.accept(this, visited));
            }
            if ((superBound = t.getSuperBound()) != null) {
                typeVariables.addAll((Iterable)superBound.accept(this, visited));
            }
            return typeVariables.build();
        }
    }
}

