/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.GeneratedAnnotationSpecs;
import com.google.auto.factory.processor.AutoFactoryProcessor;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.PackageAndClass;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProviderField;
import com.google.auto.factory.processor.TypeVariables;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;

final class FactoryWriter {
    private final Filer filer;
    private final Elements elements;
    private final SourceVersion sourceVersion;
    private final ImmutableSetMultimap<String, PackageAndClass> factoriesBeingCreated;
    private static final Joiner ARGUMENT_JOINER = Joiner.on((String)", ");

    FactoryWriter(ProcessingEnvironment processingEnv, ImmutableSetMultimap<String, PackageAndClass> factoriesBeingCreated) {
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.factoriesBeingCreated = factoriesBeingCreated;
    }

    void writeFactory(FactoryDescriptor descriptor) throws IOException {
        String factoryName = descriptor.name().className();
        TypeSpec.Builder factory = TypeSpec.classBuilder((String)factoryName).addOriginatingElement((Element)descriptor.declaration().targetType());
        GeneratedAnnotationSpecs.generatedAnnotationSpec((Elements)this.elements, (SourceVersion)this.sourceVersion, AutoFactoryProcessor.class, (String)"https://github.com/google/auto/tree/master/factory").ifPresent(arg_0 -> ((TypeSpec.Builder)factory).addAnnotation(arg_0));
        if (!descriptor.allowSubclasses()) {
            factory.addModifiers(new Modifier[]{Modifier.FINAL});
        }
        if (descriptor.publicType()) {
            factory.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        factory.superclass(TypeName.get((TypeMirror)descriptor.extendingType()));
        for (TypeMirror implementingType : descriptor.implementingTypes()) {
            factory.addSuperinterface(TypeName.get((TypeMirror)implementingType));
        }
        ImmutableSet<TypeVariableName> factoryTypeVariables = FactoryWriter.getFactoryTypeVariables(descriptor);
        FactoryWriter.addFactoryTypeParameters(factory, factoryTypeVariables);
        this.addConstructorAndProviderFields(factory, descriptor);
        this.addFactoryMethods(factory, descriptor, factoryTypeVariables);
        this.addImplementationMethods(factory, descriptor);
        FactoryWriter.addCheckNotNullMethod(factory, descriptor);
        JavaFile.builder((String)descriptor.name().packageName(), (TypeSpec)factory.build()).skipJavaLangImports(true).build().writeTo(this.filer);
    }

    private static void addFactoryTypeParameters(TypeSpec.Builder factory, ImmutableSet<TypeVariableName> typeVariableNames) {
        factory.addTypeVariables(typeVariableNames);
    }

    private void addConstructorAndProviderFields(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addAnnotation(Inject.class);
        if (descriptor.publicType()) {
            constructor.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        UnmodifiableIterator providerFields = descriptor.providers().values().iterator();
        int argumentIndex = 1;
        while (providerFields.hasNext()) {
            ProviderField provider = (ProviderField)providerFields.next();
            TypeName typeName = this.resolveTypeName((TypeMirror)provider.key().type().get()).box();
            ParameterizedTypeName providerType = ParameterizedTypeName.get((ClassName)ClassName.get(Provider.class), (TypeName[])new TypeName[]{typeName});
            factory.addField((TypeName)providerType, provider.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            if (provider.key().qualifier().isPresent()) {
                providerType = providerType.annotated(new AnnotationSpec[]{AnnotationSpec.get((AnnotationMirror)((AnnotationMirror)provider.key().qualifier().get()))});
            }
            constructor.addParameter((TypeName)providerType, provider.name(), new Modifier[0]);
            constructor.addStatement("this.$1L = checkNotNull($1L, $2L)", new Object[]{provider.name(), argumentIndex});
            ++argumentIndex;
        }
        factory.addMethod(constructor.build());
    }

    private void addFactoryMethods(TypeSpec.Builder factory, FactoryDescriptor descriptor, ImmutableSet<TypeVariableName> factoryTypeVariables) {
        for (FactoryMethodDescriptor methodDescriptor : descriptor.methodDescriptors()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodDescriptor.name()).addTypeVariables(FactoryWriter.getMethodTypeVariables(methodDescriptor, factoryTypeVariables)).returns(TypeName.get((TypeMirror)methodDescriptor.returnType())).varargs(methodDescriptor.isVarArgs());
            if (methodDescriptor.overridingMethod()) {
                method.addAnnotation(Override.class);
            }
            if (methodDescriptor.publicMethod()) {
                method.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            CodeBlock.Builder args = CodeBlock.builder();
            method.addParameters(this.parameters((Iterable<Parameter>)methodDescriptor.passedParameters()));
            UnmodifiableIterator parameters = methodDescriptor.creationParameters().iterator();
            int argumentIndex = 1;
            while (parameters.hasNext()) {
                CodeBlock argument;
                boolean checkNotNull;
                Parameter parameter = (Parameter)parameters.next();
                boolean bl = checkNotNull = !parameter.nullable().isPresent();
                if (methodDescriptor.passedParameters().contains((Object)parameter)) {
                    argument = CodeBlock.of((String)parameter.name(), (Object[])new Object[0]);
                    if (parameter.isPrimitive()) {
                        checkNotNull = false;
                    }
                } else {
                    ProviderField provider = (ProviderField)descriptor.providers().get((Object)parameter.key());
                    argument = CodeBlock.of((String)provider.name(), (Object[])new Object[0]);
                    if (parameter.isProvider()) {
                        checkNotNull = false;
                    } else {
                        argument = CodeBlock.of((String)"$L.get()", (Object[])new Object[]{argument});
                    }
                }
                if (checkNotNull) {
                    argument = CodeBlock.of((String)"checkNotNull($L, $L)", (Object[])new Object[]{argument, argumentIndex});
                }
                args.add(argument);
                if (parameters.hasNext()) {
                    args.add(", ", new Object[0]);
                }
                ++argumentIndex;
            }
            method.addStatement("return new $T($L)", new Object[]{methodDescriptor.returnType(), args.build()});
            factory.addMethod(method.build());
        }
    }

    private void addImplementationMethods(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        for (ImplementationMethodDescriptor methodDescriptor : descriptor.implementationMethodDescriptors()) {
            MethodSpec.Builder implementationMethod = MethodSpec.methodBuilder((String)methodDescriptor.name()).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)methodDescriptor.returnType())).varargs(methodDescriptor.isVarArgs());
            if (methodDescriptor.publicMethod()) {
                implementationMethod.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            implementationMethod.addParameters(this.parameters((Iterable<Parameter>)methodDescriptor.passedParameters()));
            implementationMethod.addStatement("return create($L)", new Object[]{FluentIterable.from(methodDescriptor.passedParameters()).transform((Function)new Function<Parameter, String>(){

                public String apply(Parameter parameter) {
                    return parameter.name();
                }
            }).join(ARGUMENT_JOINER)});
            factory.addMethod(implementationMethod.build());
        }
    }

    private ImmutableList<ParameterSpec> parameters(Iterable<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)this.resolveTypeName((TypeMirror)parameter.type().get()), (String)parameter.name(), (Modifier[])new Modifier[0]);
            for (AnnotationMirror annotation : Iterables.concat((Iterable)parameter.nullable().asSet(), (Iterable)parameter.key().qualifier().asSet())) {
                parameterBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotation));
            }
            builder.add((Object)parameterBuilder.build());
        }
        return builder.build();
    }

    private static void addCheckNotNullMethod(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        if (FactoryWriter.shouldGenerateCheckNotNull(descriptor)) {
            TypeVariableName typeVariable = TypeVariableName.get((String)"T");
            factory.addMethod(MethodSpec.methodBuilder((String)"checkNotNull").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addTypeVariable(typeVariable).returns((TypeName)typeVariable).addParameter((TypeName)typeVariable, "reference", new Modifier[0]).addParameter(TypeName.INT, "argumentIndex", new Modifier[0]).beginControlFlow("if (reference == null)", new Object[0]).addStatement("throw new $T($S + argumentIndex)", new Object[]{NullPointerException.class, "@AutoFactory method argument is null but is not marked @Nullable. Argument index: "}).endControlFlow().addStatement("return reference", new Object[0]).build());
        }
    }

    private static boolean shouldGenerateCheckNotNull(FactoryDescriptor descriptor) {
        if (!descriptor.providers().isEmpty()) {
            return true;
        }
        for (FactoryMethodDescriptor method : descriptor.methodDescriptors()) {
            for (Parameter parameter : method.creationParameters()) {
                if (parameter.nullable().isPresent() || ((TypeMirror)parameter.type().get()).getKind().isPrimitive()) continue;
                return true;
            }
        }
        return false;
    }

    private TypeName resolveTypeName(TypeMirror type) {
        if (type.getKind() != TypeKind.ERROR) {
            return TypeName.get((TypeMirror)type);
        }
        ImmutableSet factoryNames = this.factoriesBeingCreated.get((Object)type.toString());
        if (factoryNames.size() == 1) {
            PackageAndClass packageAndClass = (PackageAndClass)Iterables.getOnlyElement((Iterable)factoryNames);
            return ClassName.get((String)packageAndClass.packageName(), (String)packageAndClass.className(), (String[])new String[0]);
        }
        return TypeName.get((TypeMirror)type);
    }

    private static ImmutableSet<TypeVariableName> getFactoryTypeVariables(FactoryDescriptor descriptor) {
        ImmutableSet.Builder typeVariables = ImmutableSet.builder();
        for (ProviderField provider : descriptor.providers().values()) {
            typeVariables.addAll(FactoryWriter.getReferencedTypeParameterNames((TypeMirror)provider.key().type().get()));
        }
        return typeVariables.build();
    }

    private static ImmutableSet<TypeVariableName> getMethodTypeVariables(FactoryMethodDescriptor methodDescriptor, ImmutableSet<TypeVariableName> factoryTypeVariables) {
        ImmutableSet.Builder typeVariables = ImmutableSet.builder();
        typeVariables.addAll(FactoryWriter.getReferencedTypeParameterNames(methodDescriptor.returnType()));
        for (Parameter parameter : methodDescriptor.passedParameters()) {
            typeVariables.addAll(FactoryWriter.getReferencedTypeParameterNames((TypeMirror)parameter.type().get()));
        }
        return Sets.difference((Set)typeVariables.build(), factoryTypeVariables).immutableCopy();
    }

    private static ImmutableSet<TypeVariableName> getReferencedTypeParameterNames(TypeMirror type) {
        ImmutableSet.Builder typeVariableNames = ImmutableSet.builder();
        for (TypeVariable typeVariable : TypeVariables.getReferencedTypeVariables(type)) {
            typeVariableNames.add((Object)TypeVariableName.get((TypeVariable)typeVariable));
        }
        return typeVariableNames.build();
    }
}

