/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.AutoValue_FactoryMethodDescriptor;
import com.google.auto.factory.processor.PackageAndClass;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class FactoryMethodDescriptor {
    FactoryMethodDescriptor() {
    }

    abstract AutoFactoryDeclaration declaration();

    abstract String name();

    abstract TypeMirror returnType();

    abstract boolean publicMethod();

    abstract boolean overridingMethod();

    abstract ImmutableSet<Parameter> passedParameters();

    abstract ImmutableSet<Parameter> providedParameters();

    abstract ImmutableSet<Parameter> creationParameters();

    abstract Builder toBuilder();

    abstract boolean isVarArgs();

    final PackageAndClass factoryName() {
        return this.declaration().getFactoryName();
    }

    static Builder builder(AutoFactoryDeclaration declaration) {
        return new AutoValue_FactoryMethodDescriptor.Builder().declaration((AutoFactoryDeclaration)Preconditions.checkNotNull((Object)declaration)).publicMethod(false).overridingMethod(false).isVarArgs(false);
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder declaration(AutoFactoryDeclaration var1);

        abstract Builder name(String var1);

        abstract Builder returnType(TypeMirror var1);

        abstract Builder publicMethod(boolean var1);

        abstract Builder overridingMethod(boolean var1);

        abstract Builder passedParameters(Iterable<Parameter> var1);

        abstract Builder providedParameters(Iterable<Parameter> var1);

        abstract Builder creationParameters(Iterable<Parameter> var1);

        abstract Builder isVarArgs(boolean var1);

        abstract FactoryMethodDescriptor buildImpl();

        FactoryMethodDescriptor build() {
            FactoryMethodDescriptor descriptor = this.buildImpl();
            Preconditions.checkState((boolean)descriptor.creationParameters().equals((Object)Sets.union(descriptor.passedParameters(), descriptor.providedParameters())));
            return descriptor;
        }
    }
}

