/*
 * Copyright (C) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.util.regex;

/**
 * Non-working emulation of {@code Matcher}, allowing other classes to
 * compile under GWT even if they import this class, so long as
 * none of the methods called from GWT code try to use its methods.
 *
 * @author cberry@google.com (Craig Berry)
 */
public final class Matcher {
  
  public Pattern pattern() {
    throw unsupported();
  }

// Not supported:
//   public MatchResult toMatchResult()
// TODO(cberry): Emulate MatchResult and support this.

  public Matcher usePattern(Pattern newPattern) {
    throw unsupported();
  }

  public Matcher reset() {
    throw unsupported();
  }

  public Matcher reset(CharSequence input) {
    throw unsupported();
  }

  public int start() {
    throw unsupported();
  }

  public int start(int group) {
    throw unsupported();
  }

  public int end() {
    throw unsupported();
  }

  public int end(int group) {
    throw unsupported();
  }

  public String group() {
    throw unsupported();
  }

  public String group(int group) {
    throw unsupported();
  }

  public int groupCount() {
    throw unsupported();
  }

  public boolean matches() {
    throw unsupported();
  }

  public boolean find() {
    throw unsupported();
  }

  public boolean find(int start) {
    throw unsupported();
  }

  public boolean lookingAt() {
    throw unsupported();
  }

  public static String quoteReplacement(String s) {
    throw unsupported();
  }

  public Matcher appendReplacement(StringBuffer sb, String replacement) {
    throw unsupported();
  }

  public StringBuffer appendTail(StringBuffer sb) {
    throw unsupported();
  }

  public String replaceAll(String replacement) {
    throw unsupported();
  }

  public String replaceFirst(String replacement) {
    throw unsupported();
  }

  public Matcher region(int start, int end) {
    throw unsupported();
  }

  public int regionStart() {
    throw unsupported();
  }

  public int regionEnd() {
    throw unsupported();
  }

  public boolean hasTransparentBounds() {
    throw unsupported();
  }

  public Matcher useTransparentBounds(boolean b) {
    throw unsupported();
  }

  public boolean hasAnchoringBounds() {
    throw unsupported();
  }

  public Matcher useAnchoringBounds(boolean b) {
    throw unsupported();
  }

  public String toString() {
    throw unsupported();
  }

  public boolean hitEnd() {
    throw unsupported();
  }

  public boolean requireEnd() {
    throw unsupported();
  }

  private static UnsupportedOperationException unsupported() {
    return new UnsupportedOperationException("Not supported in GWT");
  }
}
