/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ApiAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerImpl.class.getClassLoader());
    Map<String, ApiAdapter> adapters = new HashMap<String, ApiAdapter>();
    static ApiAdapterFactory adapterFactory = new ApiAdapterFactory();

    public static ApiAdapterFactory getInstance() {
        return adapterFactory;
    }

    protected ApiAdapterFactory() {
    }

    private void addAdapter(String name, ApiAdapter apiAdapter) {
        if (name == null || apiAdapter == null) {
            return;
        }
        this.adapters.put(name, apiAdapter);
    }

    public ApiAdapter getApiAdapter(String name, PluginManager pluginMgr) {
        ApiAdapter api = this.adapters.get(name);
        if (api == null) {
            try {
                api = (ApiAdapter)pluginMgr.createExecutableExtension("org.datanucleus.api_adapter", "name", name, "class-name", null, null);
                if (api == null) {
                    String msg = LOCALISER.msg("022001", (Object)name);
                    NucleusLogger.PERSISTENCE.error(msg);
                    throw new NucleusUserException(msg);
                }
                adapterFactory.addAdapter(name, api);
            }
            catch (Error err) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                String msg = LOCALISER.msg("022000", (Object)className, (Object)err.getMessage());
                NucleusLogger.PERSISTENCE.error(msg, err);
                throw new NucleusUserException(msg);
            }
            catch (InvocationTargetException e) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                String msg = LOCALISER.msg("022000", (Object)className, (Object)e.getTargetException());
                NucleusLogger.PERSISTENCE.error(msg, e);
                throw new NucleusUserException(msg);
            }
            catch (NucleusUserException nue) {
                throw nue;
            }
            catch (Exception e) {
                String className = pluginMgr.getAttributeValueForExtension("org.datanucleus.api_adapter", "name", name, "class-name");
                String msg = LOCALISER.msg("022000", (Object)className, (Object)e.getMessage());
                NucleusLogger.PERSISTENCE.error(msg, e);
                throw new NucleusUserException(msg);
            }
        }
        return api;
    }
}

