/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.DevApiUtil;
import com.google.api.server.spi.tools.devserver.DiscoveryService;
import com.google.api.server.spi.tools.devserver.ErrorMap;
import com.google.api.server.spi.tools.devserver.Headers;
import com.google.api.server.spi.tools.devserver.LilyClient;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ApiServlet
extends HttpServlet {
    private static final int OK_RESPONSE = 200;
    private static final int NO_CONTENT = 204;
    public static final String RESPONSE_CONTENT_TYPE = "application/json; charset=UTF-8";
    protected static final ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper();
    private static final ErrorMap errorMap = new ErrorMap();
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String GZIP_ENCODING = "gzip";
    private static final String GET_API_CONFIGS_PATH = String.valueOf(DevApiUtil.getConfigEndpoint()).concat("BackendService.getApiConfigs");
    private static final String GET_API_CONFIGS_BODY = "{ \"appRevision\" : null }";
    protected final LilyClient lilyClient = this.createLilyClient();
    private boolean configsLoaded = false;
    protected DiscoveryService discoveryService = null;

    protected LilyClient createLilyClient() {
        return new LilyClient();
    }

    protected synchronized void initConfigsIfNecessary(HttpServletRequest request) throws IOException {
        if (!this.configsLoaded) {
            List<String> apiConfigSources = this.getApiConfigSources(request);
            this.discoveryService = new DiscoveryService(apiConfigSources);
            this.loadApiConfigs(this.getApiConfigs(apiConfigSources));
            this.configsLoaded = true;
        }
    }

    protected abstract void loadApiConfigs(List<ApiConfig> var1) throws FileNotFoundException, IOException;

    protected abstract LilyClient.Request marshallRequest(HttpServletRequest var1, ApiConfig.Method var2, ObjectNode var3) throws IOException;

    private List<ApiConfig> getApiConfigs(List<String> apiConfigSources) throws FileNotFoundException, IOException {
        ArrayList<ApiConfig> apiConfigs = new ArrayList<ApiConfig>();
        apiConfigs.add(DiscoveryService.getApiConfig());
        for (String apiConfigSource : apiConfigSources) {
            ApiConfig apiConfig = (ApiConfig)mapper.readValue(apiConfigSource, ApiConfig.class);
            apiConfigs.add(apiConfig);
        }
        return apiConfigs;
    }

    protected List<String> getApiConfigSources(HttpServletRequest request) throws IOException {
        Headers headers = new Headers();
        headers.setContentType("application/json");
        String string = String.valueOf(ApiServlet.getHostPort(request));
        String string2 = String.valueOf(GET_API_CONFIGS_PATH);
        LilyClient.Response response = this.lilyClient.send(new LilyClient.Request(string2.length() != 0 ? string.concat(string2) : new String(string), headers, GET_API_CONFIGS_BODY));
        if (!ApiServlet.isStatusOk(response.status)) {
            int n = response.status;
            throw new IOException(new StringBuilder(55).append("Failed to retrieve API configs with status: ").append(n).toString());
        }
        ObjectNode node = (ObjectNode)mapper.readValue(response.body, ObjectNode.class);
        JsonNode items = node.get("items");
        if (!items.isArray()) {
            throw new IOException("Unexpected format for API configs.");
        }
        ArrayList<String> jsonConfigs = new ArrayList<String>();
        for (JsonNode item : items) {
            if (!item.isTextual()) {
                throw new IOException("Unexpected format for API configs.");
            }
            jsonConfigs.add(item.getTextValue());
        }
        return jsonConfigs;
    }

    protected static String getHostPort(HttpServletRequest request) throws MalformedURLException {
        if (EnvUtil.isRunningOnAppEngine()) {
            URL requestUrl = new URL(request.getRequestURL().toString());
            int n = requestUrl.getPort();
            return new StringBuilder(28).append("http://127.0.0.1:").append(n).toString();
        }
        int n = DevApiUtil.getBackendPort();
        return new StringBuilder(28).append("http://127.0.0.1:").append(n).toString();
    }

    protected static Headers convertHeaders(HttpServletRequest request) {
        Headers headers = new Headers();
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        headers.setContentType("application/json");
        return headers;
    }

    protected static String getSpiEndpoint(String hostPort, ApiConfig.Method method) {
        String string = String.valueOf(DevApiUtil.getConfigEndpoint());
        String string2 = method.rosyMethod;
        return new StringBuilder(0 + String.valueOf(hostPort).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(hostPort).append(string).append(string2).toString();
    }

    protected static InputStream getBodyInputStream(HttpServletRequest request) throws IOException {
        Object bodyStream = request.getInputStream();
        if (GZIP_ENCODING.equals(request.getHeader(HEADER_CONTENT_ENCODING))) {
            bodyStream = new GZIPInputStream((InputStream)bodyStream);
        }
        return bodyStream;
    }

    protected static void convertFromLilyResponse(LilyClient.Response lilyResponse, HttpServletResponse response, boolean isRpc, String requestId) throws JsonParseException, JsonMappingException, IOException {
        response.setStatus(isRpc ? 200 : (ApiServlet.isStatusOk(lilyResponse.status) ? lilyResponse.status : errorMap.getHttpStatus(lilyResponse.status)));
        response.setContentType(RESPONSE_CONTENT_TYPE);
        ApiServlet.copyHeadersToResponse(response, lilyResponse);
        ObjectNode responseJson = ApiServlet.createResponseNode(lilyResponse, isRpc, requestId);
        if (responseJson != null) {
            response.getWriter().write(ApiServlet.prettyPrint((JsonNode)responseJson));
        }
    }

    protected static void convertFromLilyResponses(List<LilyClient.Response> lilyResponses, HttpServletResponse response, boolean isRpc, List<String> requestIds) throws JsonParseException, JsonMappingException, IOException {
        response.setContentType(RESPONSE_CONTENT_TYPE);
        ArrayNode batchResponse = mapper.createArrayNode();
        for (int i = 0; i < lilyResponses.size(); ++i) {
            LilyClient.Response lilyResponse = lilyResponses.get(i);
            String requestId = requestIds.get(i);
            batchResponse.add((JsonNode)ApiServlet.createResponseNode(lilyResponse, isRpc, requestId));
            ApiServlet.copyHeadersToResponse(response, lilyResponse);
        }
        response.getWriter().write(ApiServlet.prettyPrint((JsonNode)batchResponse));
    }

    private static void copyHeadersToResponse(HttpServletResponse response, LilyClient.Response lilyResponse) {
        for (Map.Entry header : lilyResponse.headers.entrySet()) {
            String name = (String)header.getKey();
            if ("content-length".equalsIgnoreCase(name) || "content-type".equalsIgnoreCase(name)) continue;
            response.setHeader(name, ((String)header.getValue()).toString());
        }
    }

    protected static ObjectNode createResponseNode(LilyClient.Response lilyResponse, boolean isRpc, String requestId) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode root;
        if (ApiServlet.isStatusOk(lilyResponse.status)) {
            ObjectNode result = ApiServlet.readJsonIfNotNullOrEmpty(lilyResponse.body);
            if (isRpc) {
                ObjectNode wrapperNode = mapper.createObjectNode();
                wrapperNode.put("result", (JsonNode)(lilyResponse.status != 204 ? result : mapper.createObjectNode()));
                if (requestId != null) {
                    wrapperNode.put("id", requestId);
                }
                result = wrapperNode;
            }
            return result;
        }
        String contentType = lilyResponse.headers.getContentType();
        String errorMessage = contentType != null && contentType.startsWith("application/json") ? ((root = ApiServlet.readJsonIfNotNullOrEmpty(lilyResponse.body)) != null ? root.path("error_message").asText() : null) : lilyResponse.body;
        return ApiServlet.createErrorNode(requestId, errorMessage, lilyResponse.status, isRpc);
    }

    public static ObjectNode readJsonIfNotNullOrEmpty(String json) throws IOException, JsonParseException, JsonMappingException {
        if (json != null && !json.isEmpty()) {
            return (ObjectNode)mapper.readValue(json, ObjectNode.class);
        }
        return null;
    }

    private static boolean isStatusOk(int status) {
        return status >= 200 && status < 300;
    }

    private static ObjectNode createErrorNode(String requestId, String errorMessage, int lilyStatus, boolean isRpc) {
        ObjectNode errorNode = mapper.createObjectNode();
        errorNode.put("message", errorMessage);
        ObjectNode root = mapper.createObjectNode();
        root.put("error", (JsonNode)errorNode);
        ArrayNode errorData = mapper.createArrayNode();
        ObjectNode errorDataItem = mapper.createObjectNode();
        errorDataItem.put("domain", errorMap.getDomain(lilyStatus));
        errorDataItem.put("reason", errorMap.getReason(lilyStatus));
        errorDataItem.put("message", errorMessage);
        errorData.add((JsonNode)errorDataItem);
        if (isRpc) {
            if (requestId != null) {
                root.put("id", requestId);
            }
            errorNode.put("code", errorMap.getRpcStatus(lilyStatus));
            errorNode.put("data", (JsonNode)errorData);
        } else {
            errorNode.put("code", errorMap.getHttpStatus(lilyStatus));
            errorNode.put("errors", (JsonNode)errorData);
        }
        return root;
    }

    private static String prettyPrint(JsonNode node) throws JsonGenerationException, JsonMappingException, IOException {
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }

    protected LilyClient.Response doSingleBackendCall(HttpServletRequest request, ApiConfig.Method method, ObjectNode parameterMap) throws IOException {
        this.addParametersToMap(request, method, parameterMap);
        LilyClient.Response lilyResponse = this.discoveryService.handle(method, parameterMap);
        if (lilyResponse == null) {
            return this.lilyClient.send(this.marshallRequest(request, method, parameterMap));
        }
        return lilyResponse;
    }

    protected void addParametersToMap(HttpServletRequest request, ApiConfig.Method method, ObjectNode parameterMap) {
        this.addDefaultParams(request, method.request.parameters, parameterMap);
    }

    private void addDefaultParams(HttpServletRequest request, Map<String, ApiConfig.Method.Request.Parameter> parameters, ObjectNode params) {
        for (Map.Entry<String, ApiConfig.Method.Request.Parameter> parameter : parameters.entrySet()) {
            String defaultValue;
            String parameterName = parameter.getKey();
            if (request.getParameter(parameter.getKey()) != null || params.has(parameterName) || (defaultValue = parameter.getValue().defaultValue) == null) continue;
            params.put(parameter.getKey(), defaultValue);
        }
    }
}

