/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.ClientLibGenerator;
import com.google.api.server.spi.tools.CloudClientLibGenerator;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonParseException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import com.google.appengine.tools.util.Option;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

public class GenClientLibAction
extends EndpointsToolAction {
    public static final String NAME = "gen-client-lib";
    private static final ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper();
    private Option languageOption = this.makeLanguageOption();
    private Option outputOption = this.makeOutputOption();
    private Option buildSystemOption = this.makeBuildSystemOption();

    public GenClientLibAction() {
        super(NAME);
        this.setOptions(Arrays.asList(this.languageOption, this.outputOption, this.buildSystemOption));
        this.setShortDescription("Generates a client library");
        this.setHelpDisplayNeeded(false);
    }

    @Override
    public boolean execute() throws FileNotFoundException, IOException {
        if (this.getArgs().size() != 1) {
            return false;
        }
        this.genClientLibFromFile(this.getLanguage(this.languageOption), this.getOutputPath(this.outputOption), (String)this.getArgs().get(0), this.getBuildSystem(this.buildSystemOption));
        return true;
    }

    public Object genClientLibFromFile(String language, String outputDirPath, String discoveryDocPath, String buildSystem) throws FileNotFoundException, IOException {
        String discoveryDoc = IoUtil.readFile((File)new File(discoveryDocPath));
        return this.genClientLib(language, outputDirPath, discoveryDoc, buildSystem);
    }

    public Object genClientLib(String language, String outputDirPath, String discoveryDoc, String buildSystem) throws FileNotFoundException, IOException {
        if (!GenClientLibAction.isRestDiscoveryDoc(discoveryDoc)) {
            throw new IllegalArgumentException("discovery doc must be in rest format");
        }
        String string = String.valueOf(GenClientLibAction.getApiNameVersion(discoveryDoc));
        String string2 = String.valueOf(language.toLowerCase());
        File outputFile = new File(new StringBuilder(6 + String.valueOf(outputDirPath).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(outputDirPath).append("/").append(string).append("-").append(string2).append(".zip").toString());
        ClientLibGenerator generator = CloudClientLibGenerator.using("https://google-api-client-libraries.appspot.com/generate");
        generator.generateClientLib(discoveryDoc, language, null, buildSystem, outputFile);
        String string3 = String.valueOf(outputFile.getPath());
        System.out.println(string3.length() != 0 ? "API client library written to ".concat(string3) : new String("API client library written to "));
        return null;
    }

    private static boolean isRestDiscoveryDoc(String discoveryDoc) throws IOException {
        ObjectNode discoveryJson = (ObjectNode)ObjectMapperUtil.createStandardObjectMapper().readValue(discoveryDoc, ObjectNode.class);
        return "rest".equals(discoveryJson.get("protocol").asText());
    }

    private static String getApiNameVersion(String discoveryDoc) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode root = (ObjectNode)mapper.readValue(discoveryDoc, ObjectNode.class);
        String string = String.valueOf(root.path("name").getTextValue());
        String string2 = String.valueOf(root.path("version").getTextValue());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
    }

    @Override
    public String getUsageString() {
        return "gen-client-lib <options> <discovery doc file>";
    }
}

