/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.DiscoveryDocGenerator;
import com.google.appengine.repackaged.com.google.api.client.http.ByteArrayContent;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpContent;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudDiscoveryDocGenerator
implements DiscoveryDocGenerator {
    private static final Logger logger = Logger.getLogger(CloudDiscoveryDocGenerator.class.getName());
    private final String discoveryApiRoot;

    public static DiscoveryDocGenerator using(String discoveryApiRoot) {
        return new CloudDiscoveryDocGenerator(discoveryApiRoot);
    }

    @VisibleForTesting
    CloudDiscoveryDocGenerator(String discoveryApiRoot) {
        this.discoveryApiRoot = discoveryApiRoot;
    }

    @Override
    public String generateDiscoveryDoc(String apiConfigJson, DiscoveryDocGenerator.Format format) throws IOException {
        String string = this.discoveryApiRoot;
        String string2 = String.valueOf(format.toString().toLowerCase());
        String url = new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/discovery/v1/apis/generate/").append(string2).toString();
        logger.log(Level.FINE, "url={0}", url);
        ObjectNode body = ObjectMapperUtil.createStandardObjectMapper().createObjectNode();
        body.put("config", apiConfigJson);
        logger.log(Level.FINE, "config={0}", apiConfigJson);
        return this.postRequest(url, body.toString());
    }

    @Override
    public String generateApiDirectory(List<String> apiConfigsJson) throws IOException {
        String url = String.valueOf(this.discoveryApiRoot).concat("/discovery/v1/apis/generate/directory");
        ObjectNode requestJson = ObjectMapperUtil.createStandardObjectMapper().createObjectNode();
        ArrayNode configsArray = requestJson.putArray("configs");
        for (String apiConfigJson : apiConfigsJson) {
            configsArray.add(apiConfigJson);
        }
        String requestBody = requestJson.toString();
        return this.postRequest(url, requestBody);
    }

    @VisibleForTesting
    String postRequest(String url, String content) throws IOException {
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)content));
        request.setReadTimeout(60000);
        HttpResponse response = request.execute();
        if (response.getStatusCode() >= 300) {
            String string = String.valueOf(url);
            throw new IOException(string.length() != 0 ? "Failed to post API configuration to ".concat(string) : new String("Failed to post API configuration to "));
        }
        return IoUtil.readStream((InputStream)response.getContent());
    }
}

