/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.CloudTraceContext;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class CloudTrace {
    private static final String KEY = "com.google.apphosting.api.cloudTrace";
    private static final ThreadLocal<CloudTraceContext> perThreadContext = new ThreadLocal();

    @Nullable
    private static CloudTrace get(ApiProxy.Environment env) {
        return (CloudTrace)env.getAttributes().get(KEY);
    }

    @Nullable
    public static CloudTraceContext getCurrentContext(ApiProxy.Environment env) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        return cloudTrace == null ? null : cloudTrace.getCurrentContext();
    }

    @Nullable
    private CloudTraceContext getCurrentContext() {
        CloudTraceContext context = perThreadContext.get();
        return context == null ? this.getDefaultContext() : context;
    }

    public static void setCurrentContext(ApiProxy.Environment env, @Nullable CloudTraceContext context) {
        CloudTrace cloudTrace = CloudTrace.get(env);
        if (cloudTrace != null) {
            perThreadContext.set(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bind(ApiProxy.Environment env) {
        CloudTrace original;
        Map<String, Object> attrs;
        Map<String, Object> map = attrs = env.getAttributes();
        synchronized (map) {
            original = (CloudTrace)attrs.get(KEY);
            if (original == null) {
                attrs.put(KEY, this);
                return;
            }
        }
        if (original != this) {
            throw new IllegalStateException("Cannot replace existing CloudTrace object");
        }
    }

    protected abstract CloudTraceContext getDefaultContext();
}

