/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import java.io.File;
import org.eclipse.jetty.quickstart.QuickStartWebApp;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;

public class QuickStartGenerator {
    public static void main(String[] args) {
        String string;
        String path;
        File fpath;
        if (args.length != 1) {
            System.out.println("Usage: pass one argument containing the path to a web application");
            System.exit(1);
        }
        if (!(fpath = new File(path = args[0])).exists()) {
            string = String.valueOf(fpath);
            System.out.println(new StringBuilder(21 + String.valueOf(string).length()).append("Path does not exist: ").append(string).toString());
            System.exit(1);
        }
        if (!(fpath = new File(fpath, "WEB-INF")).exists()) {
            string = String.valueOf(fpath);
            System.out.println(new StringBuilder(21 + String.valueOf(string).length()).append("Path does not exist: ").append(string).toString());
            System.exit(1);
        }
        System.setProperty("org.eclipse.jetty.server.LEVEL", "WARN");
        System.setProperty("org.eclipse.jetty.quickstart.LEVEL", "WARN");
        boolean success = QuickStartGenerator.generate(path);
        System.exit(success ? 0 : 1);
    }

    public static boolean generate(String appDir) {
        boolean deleted;
        File qs = new File(appDir, "WEB-INF/quickstart-web.xml");
        if (qs.exists() && !(deleted = IO.delete((File)qs))) {
            String string = String.valueOf(qs);
            System.err.println(new StringBuilder(35 + String.valueOf(string).length()).append("File exists and cannot be deleted: ").append(string).toString());
            return false;
        }
        try {
            Server server = new Server();
            QuickStartWebApp webapp = new QuickStartWebApp();
            webapp.setResourceBase(appDir);
            webapp.setPreconfigure(true);
            webapp.setDefaultsDescriptor("com/google/apphosting/vmruntime/jetty9/webdefault.xml");
            server.setHandler((Handler)webapp);
            server.start();
            server.stop();
            if (qs.exists()) {
                return true;
            }
            String string = String.valueOf(qs);
            System.out.println(new StringBuilder(19 + String.valueOf(string).length()).append("Failed to generate ").append(string).toString());
            return false;
        }
        catch (Exception e) {
            String string = String.valueOf(e);
            System.out.println(new StringBuilder(37 + String.valueOf(string).length()).append("Error during quick start generation: ").append(string).toString());
            return false;
        }
    }
}

