/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.repackaged.org.objectweb.asm.ClassReader;
import com.google.appengine.repackaged.org.objectweb.asm.ClassVisitor;
import com.google.appengine.repackaged.org.objectweb.asm.ClassWriter;
import com.google.appengine.tools.development.agent.impl.AgentImpl;
import com.google.appengine.tools.development.agent.impl.ClassLoaderVisitor;
import com.google.appengine.tools.development.agent.impl.ObjectAccessVisitor;
import com.google.appengine.tools.development.agent.impl.ReflectionVisitor;
import com.google.appengine.tools.development.agent.impl.StripLocalVariablesVisitor;
import com.google.appengine.tools.info.SdkImplInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class Transformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(Transformer.class.getName());
    private static final String APP_CLASS_LOADER = "com.google.appengine.tools.development.IsolatedAppClassLoader";
    private static final String APP_ENGINE_PACKAGE_PREFIX = "com/google/appengine/";
    private static final String IMPLEMENTATION_VENDOR_ID_ATTR = "Implementation-Vendor-Id";
    private static final String API_JAR_IMPLEMENTATION_VENDOR_ID = "com.google";
    private final boolean treatRestrictedClassListViolationsAsErrors;
    private AgentImpl agent = AgentImpl.getInstance();
    private Set<URL> agentRuntimeLibs;
    private final Map<URL, Boolean> userCodeSources = new HashMap<URL, Boolean>();
    private static final String DUMP_CLASSES_PROPERTY = "com.google.appengine.dumpclasses";
    private static final boolean dumpClasses = Boolean.getBoolean("com.google.appengine.dumpclasses");
    private static File dumpDir;

    public Transformer(boolean treatRestrictedClassListViolationsAsErrors) {
        this.treatRestrictedClassListViolationsAsErrors = treatRestrictedClassListViolationsAsErrors;
    }

    private static String getClassPackage(String className) {
        int lastPackageIndex = className.lastIndexOf(46);
        if (lastPackageIndex == -1) {
            return "";
        }
        return className.substring(0, lastPackageIndex).replace('.', '/');
    }

    private static String getSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] classBuffer) {
        className = className.replace('/', '.');
        if (!this.isAppLoader(loader) || this.isRuntimeCode(domain)) {
            return null;
        }
        boolean isUserCode = !this.isAppEngineCode(domain) && !className.startsWith("java.") && !className.startsWith("javax.");
        try {
            return this.rewrite(className, classBuffer, false, isUserCode, domain);
        }
        catch (Throwable t) {
            try {
                return this.rewrite(className, classBuffer, true, isUserCode, domain);
            }
            catch (Throwable t2) {
                String string = className;
                logger.log(Level.SEVERE, new StringBuilder(74 + String.valueOf(string).length()).append("Unable to instrument ").append(string).append(". Security restrictions ").append("may not be entirely emulated.").toString(), t);
                return null;
            }
        }
    }

    private byte[] rewrite(String className, byte[] classBuffer, boolean stripLocalVars, boolean isUserCode, ProtectionDomain domain) throws IOException {
        ClassWriter cw;
        ClassReader cr = new ClassReader(new ByteArrayInputStream(classBuffer));
        ClassVisitor visitor = cw = new ClassWriter(1);
        visitor = new ObjectAccessVisitor(visitor, isUserCode, this.treatRestrictedClassListViolationsAsErrors, className, domain.getCodeSource().getLocation());
        visitor = new ReflectionVisitor(visitor);
        visitor = new ClassLoaderVisitor(visitor);
        if (stripLocalVars) {
            visitor = new StripLocalVariablesVisitor(visitor);
        }
        cr.accept(visitor, 8);
        byte[] bytes = cw.toByteArray();
        if (dumpClasses) {
            this.dumpClass(className, bytes);
        }
        return bytes;
    }

    private void dumpClass(final String className, final byte[] bytes) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string = String.valueOf(dumpDir);
                String string2 = String.valueOf(File.separator);
                String string3 = String.valueOf(Transformer.getClassPackage(className));
                String dir = new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString();
                new File(dir).mkdirs();
                try {
                    string2 = String.valueOf(File.separator);
                    string3 = String.valueOf(Transformer.getSimpleName(className));
                    FileOutputStream fileOutput = new FileOutputStream(new StringBuilder(6 + String.valueOf(dir).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(dir).append(string2).append(string3).append(".class").toString());
                    fileOutput.write(bytes);
                    fileOutput.close();
                }
                catch (IOException e) {
                    String string4 = String.valueOf(className);
                    logger.log(Level.WARNING, string4.length() != 0 ? "Unable to dump class bytes for ".concat(string4) : new String("Unable to dump class bytes for "), e);
                }
                return null;
            }
        });
    }

    private boolean isRuntimeCode(ProtectionDomain domain) {
        return this.getAgentRuntimeLibs().contains(domain.getCodeSource().getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URL> getAgentRuntimeLibs() {
        Transformer transformer = this;
        synchronized (transformer) {
            if (this.agentRuntimeLibs == null) {
                this.agentRuntimeLibs = new HashSet<URL>(SdkImplInfo.getAgentRuntimeLibs());
            }
        }
        return this.agentRuntimeLibs;
    }

    private boolean isAppLoader(ClassLoader loader) {
        if (loader == null) {
            return false;
        }
        if (loader.getClass().getName().equals(APP_CLASS_LOADER)) {
            return true;
        }
        if (this.agent.isAppConstructedURLClassLoader(loader)) {
            return true;
        }
        return this.isAppLoader(loader.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppEngineCode(ProtectionDomain domain) {
        URL url = domain.getCodeSource().getLocation();
        if (url == null) {
            return false;
        }
        Transformer transformer = this;
        synchronized (transformer) {
            if (!this.userCodeSources.containsKey(url)) {
                boolean isAppEngineLib;
                block19: {
                    isAppEngineLib = false;
                    if (url.getProtocol().equals("file") && url.getPath().endsWith(".jar")) {
                        ZipInputStream jis = null;
                        try {
                            InputStream is = url.openStream();
                            jis = new JarInputStream(is);
                            Manifest manifest = ((JarInputStream)jis).getManifest();
                            if (manifest == null) break block19;
                            for (String attrName : manifest.getEntries().keySet()) {
                                Attributes attrs;
                                if (!attrName.startsWith(APP_ENGINE_PACKAGE_PREFIX) || (attrs = manifest.getAttributes(attrName)) == null || !API_JAR_IMPLEMENTATION_VENDOR_ID.equals(attrs.getValue(IMPLEMENTATION_VENDOR_ID_ATTR))) continue;
                                isAppEngineLib = true;
                                break;
                            }
                        }
                        catch (IOException e) {
                            String string = String.valueOf(url);
                            logger.log(Level.SEVERE, new StringBuilder(18 + String.valueOf(string).length()).append("Unable to process ").append(string).toString(), e);
                        }
                        finally {
                            try {
                                if (jis != null) {
                                    jis.close();
                                }
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, "Unable to close JarInputStream", e);
                            }
                        }
                    }
                }
                this.userCodeSources.put(url, isAppEngineLib);
            }
        }
        return this.userCodeSources.get(url);
    }

    static {
        if (dumpClasses) {
            try {
                dumpDir = File.createTempFile("transformed-classes", "");
                dumpDir.delete();
                String string = String.valueOf(dumpDir);
                logger.log(Level.INFO, new StringBuilder(32 + String.valueOf(string).length()).append("Dumping transformed classes to, ").append(string).toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

