/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.appengine.tools.development.agent.impl.Agent;
import com.google.appengine.tools.development.agent.impl.BlackList;
import com.google.appengine.tools.development.agent.impl.Transformer;
import java.lang.instrument.Instrumentation;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AgentImpl
implements Agent {
    static final String AGENT_RUNTIME = "com/google/appengine/tools/development/agent/runtime/Runtime";
    private static final AgentImpl instance = new AgentImpl();
    private final Set<ClassLoaderReference> appUrlClassLoaders = new HashSet<ClassLoaderReference>();
    private final ReferenceQueue<ClassLoader> classLoaderReferenceQueue = new ReferenceQueue();

    public void run(Instrumentation instrumentation, boolean treatRestrictedClassListViolationsAsErrors) {
        instrumentation.addTransformer(new Transformer(treatRestrictedClassListViolationsAsErrors));
    }

    @Override
    public Set<String> getBlackList() {
        return BlackList.getBlackList();
    }

    @Override
    public synchronized void recordAppClassLoader(ClassLoader loader) {
        this.prune();
        this.appUrlClassLoaders.add(new ClassLoaderReference(loader));
    }

    public static AgentImpl getInstance() {
        return instance;
    }

    private AgentImpl() {
        if (instance != null) {
            throw new IllegalStateException("There can only be one AgentImpl");
        }
    }

    public synchronized boolean isAppConstructedURLClassLoader(ClassLoader loader) {
        this.prune();
        return this.appUrlClassLoaders.contains(new ClassLoaderReference(loader));
    }

    private void prune() {
        boolean any = false;
        while (this.classLoaderReferenceQueue.poll() != null) {
            any = true;
        }
        if (any) {
            Iterator<ClassLoaderReference> it = this.appUrlClassLoaders.iterator();
            while (it.hasNext()) {
                ClassLoaderReference classLoaderReference = it.next();
                if (classLoaderReference.get() != null) continue;
                it.remove();
            }
        }
    }

    private class ClassLoaderReference {
        private final WeakReference<ClassLoader> classLoaderReference;
        private final int hashCode;

        ClassLoaderReference(ClassLoader classLoader) {
            this.classLoaderReference = new WeakReference<ClassLoader>(classLoader, AgentImpl.this.classLoaderReferenceQueue);
            this.hashCode = System.identityHashCode(classLoader);
        }

        ClassLoader get() {
            return (ClassLoader)this.classLoaderReference.get();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassLoaderReference) {
                ClassLoaderReference that = (ClassLoaderReference)obj;
                return this.get() == that.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

