/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.scostore;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.types.sco.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractFKStore {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected DatastoreManager storeMgr;
    protected AbstractMemberMetaData ownerMemberMetaData;
    protected String elementType;
    protected AbstractClassMetaData elementCmd;
    protected AbstractMemberMetaData elementMemberMetaData;
    protected ClassLoaderResolver clr;
    protected int relationType;
    protected DatastoreClass elementTable;
    protected JavaTypeMapping ownerMapping;

    public AbstractFKStore(AbstractMemberMetaData ownerMmd, DatastoreManager storeMgr, ClassLoaderResolver clr) {
        String mappedByFieldName;
        this.storeMgr = storeMgr;
        this.ownerMemberMetaData = ownerMmd;
        this.clr = clr;
        this.relationType = this.ownerMemberMetaData.getRelationType(clr);
        CollectionMetaData colmd = this.ownerMemberMetaData.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            if (storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(this.elementType)) {
                this.elementCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(element_class, clr);
            } else {
                this.elementCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
                if (this.elementCmd != null) {
                    this.elementType = this.elementCmd.getFullClassName();
                }
            }
        } else {
            this.elementCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.elementCmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementTable = this.storeMgr.getDatastoreClass(this.elementCmd.getFullClassName(), clr);
        if (this.elementTable == null) {
            String[] subclassNames = storeMgr.getNucleusContext().getMetaDataManager().getSubclassesForClass(element_class.getName(), true);
            if (subclassNames.length == 1) {
                this.elementTable = this.storeMgr.getDatastoreClass(subclassNames[0], clr);
            }
            if (this.elementTable == null) {
                throw new UnsupportedOperationException("Field " + this.ownerMemberMetaData.getFullFieldName() + " is collection of elements of type " + this.elementCmd.getFullClassName() + " but this has no table of its own!");
            }
        }
        if ((mappedByFieldName = this.ownerMemberMetaData.getMappedBy()) != null) {
            this.elementMemberMetaData = this.elementCmd.getMetaDataForMember(mappedByFieldName);
            if (this.elementMemberMetaData == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!(this.relationType != 4 && this.relationType != 3 || clr.isAssignableFrom(this.elementMemberMetaData.getType(), ownerMmd.getAbstractClassMetaData().getFullClassName()))) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)ownerMmd.getFullFieldName(), (Object)this.elementMemberMetaData.getFullFieldName(), (Object)this.elementMemberMetaData.getTypeName(), (Object)ownerMmd.getAbstractClassMetaData().getFullClassName()));
            }
            this.ownerMapping = this.elementTable.getMemberMapping(this.elementMemberMetaData);
        } else {
            this.ownerMapping = this.elementTable.getExternalMapping(this.ownerMemberMetaData, 5);
        }
    }

    public DatastoreManager getStoreManager() {
        return this.storeMgr;
    }

    protected Entity getOwnerEntity(ObjectProvider op) {
        Entity entity = (Entity)op.getAssociatedValue((Object)this.storeMgr.getDatastoreTransaction(op.getExecutionContext()));
        if (entity == null) {
            this.storeMgr.validateMetaDataForClass(op.getClassMetaData());
            EntityUtils.getEntityFromDatastore(this.storeMgr.getDatastoreServiceForReads(op.getExecutionContext()), op, EntityUtils.getPkAsKey(op));
            return (Entity)op.getAssociatedValue((Object)this.storeMgr.getDatastoreTransaction(op.getExecutionContext()));
        }
        return entity;
    }

    public boolean updateEmbeddedElement(ObjectProvider ownerOP, Object elem, int fieldNum, Object value) {
        return false;
    }

    public int size(ObjectProvider op) {
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            return this.getSizeUsingChildKeysInParent(op);
        }
        return this.getSizeUsingParentKeyInChildren(op);
    }

    protected int getSizeUsingChildKeysInParent(ObjectProvider op) {
        String propName;
        Entity ownerEntity = this.getOwnerEntity(op);
        if (ownerEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
            Object value = ownerEntity.getProperty(propName);
            if (value == null) {
                return 0;
            }
            List keys = (List)value;
            return keys.size();
        }
        return 0;
    }

    protected int getSizeUsingParentKeyInChildren(ObjectProvider op) {
        Entity ownerEntity = this.getOwnerEntity(op);
        String kindName = this.elementTable.getIdentifier().getIdentifierName();
        Iterable children = this.prepareChildrenQuery(ownerEntity.getKey(), Collections.<Query.FilterPredicate>emptyList(), Collections.<Query.SortPredicate>emptyList(), true, kindName).asIterable();
        int count = 0;
        for (Entity e : children) {
            if (!ownerEntity.getKey().equals((Object)e.getKey().getParent())) continue;
            ++count;
        }
        return count;
    }

    public boolean contains(ObjectProvider op, Object element) {
        ExecutionContext ec = op.getExecutionContext();
        if (!this.validateElementForReading(ec, element)) {
            return false;
        }
        Key childKey = EntityUtils.getKeyForObject(element, ec);
        if (childKey == null) {
            return false;
        }
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName;
            Entity datastoreEntity = this.getOwnerEntity(op);
            if (datastoreEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
                Object value = datastoreEntity.getProperty(propName);
                if (value == null) {
                    return false;
                }
                List keys = (List)value;
                return keys.contains(childKey);
            }
            return false;
        }
        if (childKey.getParent() == null) {
            return false;
        }
        Key parentKey = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), op);
        return childKey.getParent().equals((Object)parentKey);
    }

    List<?> getChildrenUsingParentQuery(Key parentKey, Iterable<Query.FilterPredicate> filterPredicates, Iterable<Query.SortPredicate> sortPredicates, ExecutionContext ec) {
        ArrayList<Object> result = new ArrayList<Object>();
        int numChildren = 0;
        String kindName = this.elementTable.getIdentifier().getIdentifierName();
        for (Entity e : this.prepareChildrenQuery(parentKey, filterPredicates, sortPredicates, false, kindName).asIterable()) {
            if (!parentKey.equals((Object)e.getKey().getParent())) continue;
            ++numChildren;
            result.add(EntityUtils.entityToPojo(e, this.elementCmd, this.clr, ec, false, ec.getFetchPlan()));
            if (!NucleusLogger.PERSISTENCE.isDebugEnabled()) continue;
            NucleusLogger.PERSISTENCE.debug((Object)("Retrieved entity with key " + e.getKey()));
        }
        NucleusLogger.PERSISTENCE.debug((Object)String.format("Query had %d result%s.", numChildren, numChildren == 1 ? "" : "s"));
        return result;
    }

    List<?> getChildrenFromParentField(ObjectProvider op, ExecutionContext ec, int startIdx, int endIdx) {
        String propName;
        Entity datastoreEntity = this.getOwnerEntity(op);
        if (datastoreEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
            Object value = datastoreEntity.getProperty(propName);
            if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
                return Utils.newArrayList(new Object[0]);
            }
            ArrayList<Object> children = new ArrayList<Object>();
            List keys = (List)value;
            DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
            DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
            Map entitiesByKey = ds.get((Iterable)keys);
            int i = 0;
            for (Key key : keys) {
                if (i < startIdx || endIdx > 0 && i >= endIdx) continue;
                Entity entity = (Entity)entitiesByKey.get(key);
                if (entity == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Field " + this.ownerMemberMetaData.getFullFieldName() + " of " + datastoreEntity.getKey() + " was marked as having child " + key + " but doesn't exist, so must have been deleted. Ignoring"));
                    continue;
                }
                Object pojo = EntityUtils.entityToPojo(entity, this.elementCmd, this.clr, ec, false, ec.getFetchPlan());
                children.add(pojo);
                ++i;
            }
            return children;
        }
        return Utils.newArrayList(new Object[0]);
    }

    PreparedQuery prepareChildrenQuery(Key parentKey, Iterable<Query.FilterPredicate> filterPredicates, Iterable<Query.SortPredicate> sortPredicates, boolean keysOnly, String kindName) {
        Query q = new Query(kindName, parentKey);
        if (keysOnly) {
            q.setKeysOnly();
        }
        NucleusLogger.PERSISTENCE.debug((Object)("Preparing to query for all children of " + parentKey + " of kind " + kindName));
        for (Query.FilterPredicate fp : filterPredicates) {
            q.addFilter(fp.getPropertyName(), fp.getOperator(), fp.getValue());
            NucleusLogger.PERSISTENCE.debug((Object)("  Added filter: " + fp.getPropertyName() + " " + fp.getOperator() + " " + fp.getValue()));
        }
        for (Query.SortPredicate sp : sortPredicates) {
            q.addSort(sp.getPropertyName(), sp.getDirection());
            NucleusLogger.PERSISTENCE.debug((Object)("  Added sort: " + sp.getPropertyName() + " " + sp.getDirection()));
        }
        DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        return ds.prepare(q);
    }

    protected boolean validateElementForWriting(ExecutionContext ec, Object element, FieldValues fieldValues) {
        if (!this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(this.elementType) && !this.validateElementType(ec.getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("056033", (Object)element.getClass().getName(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        return SCOUtils.validateObjectForWriting((ExecutionContext)ec, (Object)element, (FieldValues)fieldValues);
    }

    protected boolean validateElementForReading(ExecutionContext ec, Object element) {
        if (!this.validateElementType(this.clr, element)) {
            return false;
        }
        return element == null || ec.getApiAdapter().isPersistent(element) && ec == ec.getApiAdapter().getExecutionContext(element) || ec.getApiAdapter().isDetached(element);
    }

    protected boolean validateElementType(ClassLoaderResolver clr, Object element) {
        if (element == null) {
            return true;
        }
        Class primitiveElementClass = ClassUtils.getPrimitiveTypeForType(element.getClass());
        if (primitiveElementClass != null) {
            String elementTypeWrapper = this.elementType;
            Class elementTypeClass = clr.classForName(this.elementType);
            if (elementTypeClass.isPrimitive()) {
                elementTypeWrapper = ClassUtils.getWrapperTypeForPrimitiveType((Class)elementTypeClass).getName();
            }
            return clr.isAssignableFrom(elementTypeWrapper, element.getClass());
        }
        return clr.isAssignableFrom(this.elementType, element.getClass());
    }
}

