/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.mapping;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.ArrayMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

public class DependentDeleteRequest {
    private final List<MappingCallbacks> callbacks;
    private final AbstractMemberMetaData[] oneToOneNonOwnerFields;

    public DependentDeleteRequest(DatastoreClass dc, AbstractClassMetaData acmd, ClassLoaderResolver clr) {
        DependentDeleteMappingConsumer consumer = new DependentDeleteMappingConsumer(acmd, clr);
        dc.provideNonPrimaryKeyMappings((MappingConsumer)consumer);
        dc.providePrimaryKeyMappings((MappingConsumer)consumer);
        dc.provideDatastoreIdMappings((MappingConsumer)consumer);
        this.callbacks = consumer.getMappingCallBacks();
        this.oneToOneNonOwnerFields = consumer.getOneToOneNonOwnerFields();
    }

    public Set execute(ObjectProvider op, Entity owningEntity) {
        HashSet<Object> relatedObjectsToDelete = null;
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        DatastoreManager storeMgr = (DatastoreManager)op.getExecutionContext().getStoreManager();
        for (MappingCallbacks callback : this.callbacks) {
            boolean relatedObjectDeleted;
            ExecutionContext ec;
            JavaTypeMapping mapping = (JavaTypeMapping)callback;
            AbstractMemberMetaData mmd = mapping.getMemberMetaData();
            int relationType = mmd.getRelationType(clr);
            if (callback instanceof ArrayMapping) {
                if (Relation.isRelationMultiValued((int)relationType)) {
                    ec = op.getExecutionContext();
                    op.loadField(mmd.getAbsoluteFieldNumber());
                    Object arr = op.provideField(mmd.getAbsoluteFieldNumber());
                    if ((mmd.getArray().isDependentElement() || MetaDataUtils.isOwnedRelation(mmd, storeMgr)) && arr != null) {
                        for (int i = 0; i < Array.getLength(arr); ++i) {
                            Object elem = Array.get(arr, i);
                            if (!ec.getApiAdapter().isPersistent(elem)) continue;
                            ec.deleteObjectInternal(elem);
                        }
                    }
                }
            } else if (callback instanceof MapMapping) {
                if (Relation.isRelationMultiValued((int)relationType)) {
                    ec = op.getExecutionContext();
                    op.loadField(mmd.getAbsoluteFieldNumber());
                    Map map = (Map)op.provideField(mmd.getAbsoluteFieldNumber());
                    if (map != null) {
                        if (mmd.getMap().isDependentKey() || MetaDataUtils.isOwnedRelation(mmd, storeMgr)) {
                            for (Object key : map.keySet()) {
                                if (!ec.getApiAdapter().isPersistent(key)) continue;
                                ec.deleteObjectInternal(key);
                            }
                        }
                        if (mmd.getMap().isDependentValue() || MetaDataUtils.isOwnedRelation(mmd, storeMgr)) {
                            for (Object val : map.values()) {
                                if (!ec.getApiAdapter().isPersistent(val)) continue;
                                ec.deleteObjectInternal(val);
                            }
                        }
                    }
                }
            } else {
                callback.preDelete(op);
            }
            if (!mmd.isDependent() || relationType != 1 && (relationType != 2 || mmd.getMappedBy() != null)) continue;
            op.loadField(mmd.getAbsoluteFieldNumber());
            Object relatedPc = op.provideField(mmd.getAbsoluteFieldNumber());
            if (relatedPc == null || (relatedObjectDeleted = op.getExecutionContext().getApiAdapter().isDeleted(relatedPc))) continue;
            if (relatedObjectsToDelete == null) {
                relatedObjectsToDelete = new HashSet<Object>();
            }
            relatedObjectsToDelete.add(relatedPc);
        }
        if (this.oneToOneNonOwnerFields != null && this.oneToOneNonOwnerFields.length > 0) {
            for (AbstractMemberMetaData relatedFmd : this.oneToOneNonOwnerFields) {
                this.updateOneToOneBidirectionalOwnerObjectForField(op, relatedFmd, owningEntity);
            }
        }
        return relatedObjectsToDelete;
    }

    private void updateOneToOneBidirectionalOwnerObjectForField(ObjectProvider op, AbstractMemberMetaData fmd, Entity owningEntity) {
        ExecutionContext ec;
        ClassLoaderResolver clr;
        AbstractMemberMetaData[] relatedMmds;
        String fullClassName;
        MappedStoreManager storeMgr = (MappedStoreManager)op.getExecutionContext().getStoreManager();
        DatastoreClass refTable = storeMgr.getDatastoreClass(fullClassName = ((AbstractClassMetaData)(relatedMmds = fmd.getRelatedMemberMetaData(clr = (ec = op.getExecutionContext()).getClassLoaderResolver()))[0].getParent()).getFullClassName(), clr);
        JavaTypeMapping refMapping = refTable.getMemberMapping(fmd.getMappedBy());
        if (refMapping.isNullable()) {
            refMapping.setObject(ec, (Object)owningEntity, new int[1], op.getObject());
        }
    }

    private static class DependentDeleteMappingConsumer
    implements MappingConsumer {
        private final List<AbstractMemberMetaData> oneToOneNonOwnerFields = Utils.newArrayList(new Object[0]);
        private final List<MappingCallbacks> callbacks = Utils.newArrayList(new Object[0]);
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public DependentDeleteMappingConsumer(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
            this.clr = clr;
            this.cmd = cmd;
        }

        public void preConsumeMapping(int highest) {
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement() && !fmd.isPrimaryKey() && (m instanceof PersistableMapping || m instanceof ReferenceMapping) && m.getNumberOfDatastoreMappings() == 0) {
                int relationType = fmd.getRelationType(this.clr);
                if (relationType == 2) {
                    if (fmd.getMappedBy() != null) {
                        this.oneToOneNonOwnerFields.add(fmd);
                    }
                } else if (relationType == 6) {
                    AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                    if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                        // empty if block
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.callbacks.add((MappingCallbacks)m);
            }
        }

        public AbstractMemberMetaData[] getOneToOneNonOwnerFields() {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[this.oneToOneNonOwnerFields.size()];
            for (int i = 0; i < this.oneToOneNonOwnerFields.size(); ++i) {
                fmds[i] = this.oneToOneNonOwnerFields.get(i);
            }
            return fmds;
        }

        public List<MappingCallbacks> getMappingCallBacks() {
            return this.callbacks;
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
        }
    }
}

