/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.util.NucleusLogger;

public class Migrator {
    NucleusContext nucCtx;

    public Migrator(NucleusContext nucCtx) {
        this.nucCtx = nucCtx;
    }

    public boolean migrate(Entity entity, Class cls) {
        String disProp;
        DatastoreManager storeMgr = (DatastoreManager)this.nucCtx.getStoreManager();
        ClassLoaderResolver clr = this.nucCtx.getClassLoaderResolver(null);
        AbstractClassMetaData cmd = this.nucCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        Collection mdClasses = this.nucCtx.getMetaDataManager().getClassesWithMetaData();
        storeMgr.addClasses(mdClasses.toArray(new String[mdClasses.size()]), clr);
        if (cmd.hasDiscriminatorStrategy() && (disProp = EntityUtils.getDiscriminatorPropertyName(storeMgr.getIdentifierFactory(), cmd.getDiscriminatorMetaDataForTable())) != null && entity.hasProperty(disProp)) {
            String discValActual;
            DiscriminatorStrategy discStr = cmd.getDiscriminatorStrategyForTable();
            String discValExpected = cls.getName();
            if (discStr == DiscriminatorStrategy.VALUE_MAP) {
                discValExpected = (String)cmd.getDiscriminatorValue();
            }
            if ((discValActual = (String)entity.getProperty(disProp)) != null && discValExpected != null && !discValActual.equals(discValExpected)) {
                NucleusLogger.DATASTORE.info((Object)("Attempt to migrate " + entity + " as being of type " + cls.getName() + " but discriminator implies of different type"));
                return false;
            }
        }
        return Migrator.migrateEntity(this.nucCtx, cls, entity, cmd, clr, storeMgr);
    }

    public static void migrate(NucleusContext nucCtx, Class cls, Iterable<Entity> iter) {
        DatastoreManager storeMgr = (DatastoreManager)nucCtx.getStoreManager();
        ClassLoaderResolver clr = nucCtx.getClassLoaderResolver(null);
        AbstractClassMetaData cmd = nucCtx.getMetaDataManager().getMetaDataForClass(cls, clr);
        Collection mdClasses = nucCtx.getMetaDataManager().getClassesWithMetaData();
        storeMgr.addClasses(mdClasses.toArray(new String[mdClasses.size()]), clr);
        HashSet<Entity> changedEntities = new HashSet<Entity>();
        int[] relationFieldNumbers = cmd.getRelationMemberPositions(clr, nucCtx.getMetaDataManager());
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        if (relationFieldNumbers != null && relationFieldNumbers.length > 0) {
            for (Entity entity : iter) {
                boolean changed = Migrator.migrateEntity(nucCtx, cls, entity, cmd, clr, storeMgr);
                if (!changed) continue;
                changedEntities.add(entity);
            }
        }
        if (!changedEntities.isEmpty()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Putting " + changedEntities.size() + " entities of class " + cls.getName()));
            datastore.put(changedEntities);
        }
    }

    protected static boolean migrateEntity(NucleusContext nucCtx, Class cls, Entity entity, AbstractClassMetaData cmd, ClassLoaderResolver clr, DatastoreManager storeMgr) {
        DatastoreService datastore = DatastoreServiceFactory.getDatastoreService();
        boolean changed = false;
        int[] relationFieldNumbers = cmd.getRelationMemberPositions(clr, nucCtx.getMetaDataManager());
        if (relationFieldNumbers == null || relationFieldNumbers.length == 0) {
            return false;
        }
        NucleusLogger.DATASTORE.info((Object)("Migrating Entity with key=" + entity.getKey() + " for class=" + cls.getName()));
        for (int i = 0; i < relationFieldNumbers.length; ++i) {
            String propName;
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(relationFieldNumbers[i]);
            if (!MetaDataUtils.isOwnedRelation(mmd, storeMgr)) continue;
            int relationType = mmd.getRelationType(clr);
            if (relationType == 1 || relationType == 2 && mmd.getMappedBy() == null) {
                propName = EntityUtils.getPropertyName(storeMgr.getIdentifierFactory(), mmd);
                if (entity.hasProperty(propName)) continue;
                AbstractClassMetaData relCmd = nucCtx.getMetaDataManager().getMetaDataForClass(mmd.getTypeName(), clr);
                String relKindName = EntityUtils.getKindName(storeMgr.getIdentifierFactory(), relCmd);
                Query q2 = new Query(relKindName, entity.getKey());
                PreparedQuery pq2 = datastore.prepare(q2);
                Key value = null;
                for (Entity entity2 : pq2.asIterable()) {
                    if (!entity.getKey().equals((Object)entity2.getKey().getParent())) continue;
                    value = entity2.getKey();
                    break;
                }
                changed = true;
                entity.setProperty(propName, value);
                continue;
            }
            if (relationType != 3 && relationType != 4 || entity.hasProperty(propName = EntityUtils.getPropertyName(storeMgr.getIdentifierFactory(), mmd))) continue;
            AbstractClassMetaData childCmd = mmd.getCollection().getElementClassMetaData(clr, nucCtx.getMetaDataManager());
            String childKindName = EntityUtils.getKindName(storeMgr.getIdentifierFactory(), childCmd);
            Query q = new Query(childKindName, entity.getKey());
            if (List.class.isAssignableFrom(mmd.getType())) {
                ArrayList<Object> sortPredicates = Utils.newArrayList(new Object[0]);
                boolean indexedList = true;
                if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
                    indexedList = false;
                }
                if (indexedList) {
                    String indexPropName = null;
                    OrderMetaData orderMetaData = mmd.getOrderMetaData();
                    if (orderMetaData != null && orderMetaData.getColumnMetaData() != null && orderMetaData.getColumnMetaData().length > 0 && orderMetaData.getColumnMetaData()[0].getName() != null) {
                        String colName = orderMetaData.getColumnMetaData()[0].getName();
                        indexPropName = storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(colName).getIdentifierName();
                    }
                    if (indexPropName == null) {
                        indexPropName = storeMgr.getIdentifierFactory().newForeignKeyFieldIdentifier(mmd, null, null, true, 7).getIdentifierName();
                    }
                    Query.SortPredicate sortPredicate = new Query.SortPredicate(indexPropName, Query.SortDirection.ASCENDING);
                    sortPredicates.add(sortPredicate);
                } else {
                    for (OrderMetaData.FieldOrder fieldOrder : mmd.getOrderMetaData().getFieldOrders()) {
                        String orderMemberName = fieldOrder.getFieldName();
                        AbstractMemberMetaData orderMemberMmd = childCmd.getMetaDataForMember(orderMemberName);
                        String orderPropName = EntityUtils.getPropertyName(storeMgr.getIdentifierFactory(), orderMemberMmd);
                        boolean isPrimaryKey = orderMemberMmd.isPrimaryKey();
                        if (isPrimaryKey) {
                            if (fieldOrder.isForward() && sortPredicates.isEmpty()) break;
                            orderPropName = "__key__";
                        }
                        Query.SortPredicate sortPredicate = new Query.SortPredicate(orderPropName, fieldOrder.isForward() ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING);
                        sortPredicates.add(sortPredicate);
                        if (isPrimaryKey) break;
                    }
                }
                for (Query.SortPredicate sortPredicate : sortPredicates) {
                    q.addSort(sortPredicate.getPropertyName(), sortPredicate.getDirection());
                }
            }
            PreparedQuery pq = datastore.prepare(q);
            ArrayList<Key> values = new ArrayList<Key>();
            for (Entity entity3 : pq.asIterable()) {
                if (!entity.getKey().equals((Object)entity3.getKey().getParent())) continue;
                values.add(entity3.getKey());
            }
            changed = true;
            entity.setProperty(propName, values);
        }
        NucleusLogger.DATASTORE.info((Object)("Migration of Entity with key=" + entity.getKey() + (changed ? " has been performed" : " didn't need any changes to the Entity")));
        return changed;
    }
}

