/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreTransaction;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.PojoDatastoreBridge;
import java.util.List;
import javax.jdo.PersistenceManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;

public final class JDODatastoreBridge
extends PojoDatastoreBridge {
    public <T> List<T> toJDOResult(PersistenceManager pm, Class<T> cls, QueryResultList<Entity> queryResultList) {
        return this.toJDOResult(pm, cls, (Iterable<Entity>)queryResultList, queryResultList.getCursor());
    }

    public <T> List<T> toJDOResult(PersistenceManager pm, Class<T> cls, QueryResultIterable<Entity> queryResultIterable) {
        return this.toJDOResult(pm, cls, (Iterable<Entity>)queryResultIterable, null);
    }

    private <T> List<T> toJDOResult(PersistenceManager pm, Class<T> cls, Iterable<Entity> queryResultIterable, Cursor endCursor) {
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        return this.toPojoResult(ec, cls, queryResultIterable, endCursor);
    }

    public Entity getEntityFromJDO(Object pc, PersistenceManager pm) {
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        ObjectProvider op = ec.findObjectProvider(pc);
        if (op != null) {
            DatastoreManager storeMgr = (DatastoreManager)ec.getStoreManager();
            DatastoreTransaction txn = storeMgr.getDatastoreTransaction(ec);
            if (txn != null) {
                Entity entity = (Entity)op.getAssociatedValue((Object)txn);
                if (entity != null) {
                    return entity;
                }
                Key key = EntityUtils.getPkAsKey(op);
                return EntityUtils.getEntityFromDatastore(storeMgr.getDatastoreServiceForReads(ec), op, key);
            }
            Key key = EntityUtils.getPkAsKey(op);
            return EntityUtils.getEntityFromDatastore(storeMgr.getDatastoreServiceForReads(ec), op, key);
        }
        throw new UnsupportedOperationException("Not yet supported getting Entity for detached/unmanaged object");
    }

    public Object getJDOFromEntity(Entity entity, PersistenceManager pm, Class cls) {
        ExecutionContext ec = ((JDOPersistenceManager)pm).getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
        return EntityUtils.entityToPojo(entity, cmd, clr, ec, false, ec.getFetchPlan());
    }
}

