/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.extra.commons.collections.map.LRUMap;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.ExpressionString;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;
import org.apache.taglibs.standard.lang.jstl.parser.ELParser;
import org.apache.taglibs.standard.lang.jstl.parser.ParseException;
import org.apache.taglibs.standard.lang.jstl.parser.Token;
import org.apache.taglibs.standard.lang.jstl.parser.TokenMgrError;

public class ELEvaluator {
    private static final String EXPR_CACHE_PARAM = "org.apache.taglibs.standard.lang.jstl.exprCacheSize";
    private static final int MAX_SIZE = 100;
    static Map sCachedExpressionStrings = null;
    static Map sCachedExpectedTypes = new HashMap();
    static Logger sLogger = new Logger(System.out);
    VariableResolver mResolver;
    boolean mBypassCache;
    PageContext pageContext;

    public ELEvaluator(VariableResolver variableResolver) {
        this.mResolver = variableResolver;
    }

    public void setBypassCache(boolean bl) {
        this.mBypassCache = bl;
    }

    public Object evaluate(String string, Object object, Class clazz, Map map, String string2) throws ELException {
        return this.evaluate(string, object, clazz, map, string2, sLogger);
    }

    Object evaluate(String string, Object object, Class clazz, Map map, String string2, Logger logger) throws ELException {
        if (string == null) {
            throw new ELException(Constants.NULL_EXPRESSION_STRING);
        }
        this.pageContext = (PageContext)object;
        Object object2 = this.parseExpressionString(string);
        if (object2 instanceof String) {
            String string3 = (String)object2;
            return this.convertStaticValueToExpectedType(string3, clazz, logger);
        }
        if (object2 instanceof Expression) {
            Object object3 = ((Expression)object2).evaluate(object, this.mResolver, map, string2, logger);
            return this.convertToExpectedType(object3, clazz, logger);
        }
        if (object2 instanceof ExpressionString) {
            String string4 = ((ExpressionString)object2).evaluate(object, this.mResolver, map, string2, logger);
            return this.convertToExpectedType(string4, clazz, logger);
        }
        return null;
    }

    public Object parseExpressionString(String string) throws ELException {
        Object object;
        if (string.length() == 0) {
            return "";
        }
        if (!this.mBypassCache && sCachedExpressionStrings == null) {
            this.createExpressionStringMap();
        }
        Object object2 = object = this.mBypassCache ? null : (Object)sCachedExpressionStrings.get(string);
        if (object == null) {
            StringReader stringReader = new StringReader(string);
            ELParser eLParser = new ELParser(stringReader);
            try {
                object = eLParser.ExpressionString();
                if (!this.mBypassCache) {
                    sCachedExpressionStrings.put(string, object);
                }
            }
            catch (ParseException parseException) {
                throw new ELException(ELEvaluator.formatParseException(string, parseException));
            }
            catch (TokenMgrError tokenMgrError) {
                throw new ELException(tokenMgrError.getMessage());
            }
        }
        return object;
    }

    Object convertToExpectedType(Object object, Class clazz, Logger logger) throws ELException {
        return Coercions.coerce(object, clazz, logger);
    }

    Object convertStaticValueToExpectedType(String string, Class clazz, Logger logger) throws ELException {
        if (clazz == String.class || clazz == Object.class) {
            return string;
        }
        Map map = ELEvaluator.getOrCreateExpectedTypeMap(clazz);
        if (!this.mBypassCache && map.containsKey(string)) {
            return map.get(string);
        }
        Object object = Coercions.coerce(string, clazz, logger);
        map.put(string, object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class clazz) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map map2 = (Map)sCachedExpectedTypes.get(clazz);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(clazz, map2);
            }
            return map2;
        }
    }

    private synchronized void createExpressionStringMap() {
        if (sCachedExpressionStrings != null) {
            return;
        }
        String string = this.pageContext.getServletContext().getInitParameter(EXPR_CACHE_PARAM);
        sCachedExpressionStrings = string != null ? Collections.synchronizedMap(new LRUMap(Integer.parseInt(string))) : Collections.synchronizedMap(new LRUMap(100));
    }

    static String formatParseException(String string, ParseException parseException) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        if (parseException.expectedTokenSequences == null) {
            return parseException.toString();
        }
        for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
            if (n < parseException.expectedTokenSequences[i].length) {
                n = parseException.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < parseException.expectedTokenSequences[i].length; ++j) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(parseException.tokenImage[parseException.expectedTokenSequences[i][j]]);
                bl = true;
            }
        }
        String string2 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        Token token = parseException.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer2.append(" ");
            }
            if (token.kind == 0) {
                stringBuffer2.append(parseException.tokenImage[0]);
                break;
            }
            stringBuffer2.append(ELEvaluator.addEscapes(token.image));
            token = token.next;
        }
        String string3 = stringBuffer2.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, string2, string3);
    }

    static String addEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String parseAndRender(String string) throws ELException {
        Object object = this.parseExpressionString(string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Expression) {
            return "${" + ((Expression)object).getExpressionString() + "}";
        }
        if (object instanceof ExpressionString) {
            return ((ExpressionString)object).getExpressionString();
        }
        return "";
    }
}

