/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Arrays;

public final class UrlFetchTransport
extends HttpTransport {
    private static final String[] SUPPORTED_METHODS = new String[]{"DELETE", "GET", "HEAD", "POST", "PUT"};
    private final CertificateValidationBehavior certificateValidationBehavior;

    public UrlFetchTransport() {
        this(new Builder());
    }

    UrlFetchTransport(Builder builder) {
        this.certificateValidationBehavior = builder.certificateValidationBehavior;
    }

    public static UrlFetchTransport getDefaultInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public boolean supportsMethod(String method) {
        return Arrays.binarySearch(SUPPORTED_METHODS, method) >= 0;
    }

    @Override
    protected UrlFetchRequest buildRequest(String method, String url) throws IOException {
        Preconditions.checkArgument(this.supportsMethod(method), "HTTP method %s not supported", method);
        HTTPMethod httpMethod = method.equals("DELETE") ? HTTPMethod.DELETE : (method.equals("GET") ? HTTPMethod.GET : (method.equals("HEAD") ? HTTPMethod.HEAD : (method.equals("POST") ? HTTPMethod.POST : HTTPMethod.PUT)));
        FetchOptions fetchOptions = FetchOptions.Builder.doNotFollowRedirects().disallowTruncate().validateCertificate();
        switch (this.certificateValidationBehavior) {
            case VALIDATE: {
                fetchOptions.validateCertificate();
                break;
            }
            case DO_NOT_VALIDATE: {
                fetchOptions.doNotValidateCertificate();
                break;
            }
        }
        return new UrlFetchRequest(fetchOptions, httpMethod, url);
    }

    static {
        Arrays.sort(SUPPORTED_METHODS);
    }

    public static final class Builder {
        CertificateValidationBehavior certificateValidationBehavior = CertificateValidationBehavior.DEFAULT;

        public Builder doNotValidateCertificate() {
            this.certificateValidationBehavior = CertificateValidationBehavior.DO_NOT_VALIDATE;
            return this;
        }

        public Builder validateCertificate() {
            this.certificateValidationBehavior = CertificateValidationBehavior.VALIDATE;
            return this;
        }

        public boolean getValidateCertificate() {
            return this.certificateValidationBehavior == CertificateValidationBehavior.VALIDATE;
        }

        public boolean getDoNotValidateCertificate() {
            return this.certificateValidationBehavior == CertificateValidationBehavior.DO_NOT_VALIDATE;
        }

        public UrlFetchTransport build() {
            return new UrlFetchTransport(this);
        }
    }

    static class InstanceHolder {
        static final UrlFetchTransport INSTANCE = new UrlFetchTransport();

        InstanceHolder() {
        }
    }

    static enum CertificateValidationBehavior {
        DEFAULT,
        VALIDATE,
        DO_NOT_VALIDATE;

    }
}

