/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.auth.GoogleAuth;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.request.Attribute;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@Singleton
class GoogleAppEngineAuthenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(GoogleAppEngineAuthenticator.class.getName());
    private final OAuthService oauthService;
    private final UserService userService;

    public GoogleAppEngineAuthenticator() {
        this(OAuthServiceFactory.getOAuthService(), UserServiceFactory.getUserService());
    }

    public GoogleAppEngineAuthenticator(OAuthService oauthService, UserService userService) {
        this.oauthService = oauthService;
        this.userService = userService;
    }

    @VisibleForTesting
    String getOAuth2ClientIdDev(String token) {
        GoogleAuth.TokenInfo tokenInfo = GoogleAuth.getTokenInfoRemote(token);
        return tokenInfo != null ? tokenInfo.clientId : null;
    }

    @VisibleForTesting
    boolean shouldTryCookieAuth(ApiMethodConfig config) {
        return config.getApiClassConfig().getApiConfig().getAuthConfig().getAllowCookieAuth();
    }

    @VisibleForTesting
    com.google.appengine.api.users.User getOAuth2User(HttpServletRequest request, ApiMethodConfig config) {
        String token = GoogleAuth.getAuthToken(request);
        if (!GoogleAuth.isOAuth2Token(token)) {
            return null;
        }
        AuthScopeExpression scopeExpression = config.getScopeExpression();
        String[] allScopes = scopeExpression.getAllScopes();
        String clientId = null;
        if (EnvUtil.isRunningOnAppEngineProd()) {
            try {
                Object[] authorizedScopes = this.oauthService.getAuthorizedScopes(allScopes);
                boolean authorized = false;
                if (authorizedScopes != null) {
                    authorized = scopeExpression.isAuthorized((Set<String>)ImmutableSet.copyOf((Object[])authorizedScopes));
                }
                if (!authorized) {
                    String string = String.valueOf(scopeExpression);
                    logger.warning(new StringBuilder(54 + String.valueOf(string).length()).append("Access token does not contain sufficient scopes from: ").append(string).toString());
                    return null;
                }
                clientId = this.oauthService.getClientId(allScopes);
            }
            catch (OAuthRequestException e) {
                String string = String.valueOf(scopeExpression);
                logger.log(Level.WARNING, new StringBuilder(30 + String.valueOf(string).length()).append("Failed to get client id for '").append(string).append("'").toString(), e);
                return null;
            }
        } else {
            clientId = this.getOAuth2ClientIdDev(token);
        }
        if (Attribute.from(request).isEnabled("endpoints:Enable-Client-Id-Whitelist") && !GoogleAuth.checkClientId(clientId, config.getClientIds(), true)) {
            String string = String.valueOf(clientId);
            logger.warning(string.length() != 0 ? "ClientId is not allowed: ".concat(string) : new String("ClientId is not allowed: "));
            return null;
        }
        try {
            com.google.appengine.api.users.User appEngineUser = this.oauthService.getCurrentUser(allScopes);
            return appEngineUser;
        }
        catch (OAuthRequestException e) {
            String string = String.valueOf(scopeExpression);
            logger.log(Level.WARNING, new StringBuilder(25 + String.valueOf(string).length()).append("Failed to get user for '").append(string).append("'").toString(), e);
            return null;
        }
    }

    @Override
    public User authenticate(HttpServletRequest request) {
        Attribute attr = Attribute.from(request);
        if (!EnvUtil.isRunningOnAppEngine()) {
            return null;
        }
        com.google.appengine.api.users.User appEngineUser = null;
        ApiMethodConfig config = (ApiMethodConfig)attr.get("endpoints:Api-Method-Config");
        if (!attr.isEnabled("endpoints:Skip-Token-Auth")) {
            appEngineUser = this.getOAuth2User(request, config);
        }
        if (appEngineUser == null && this.shouldTryCookieAuth(config)) {
            appEngineUser = this.userService.getCurrentUser();
        }
        if (appEngineUser == null) {
            return null;
        }
        User user = new User(appEngineUser.getEmail());
        if (attr.isEnabled("endpoints:Require-AppEngine-User")) {
            logger.log(Level.INFO, "appEngineUser = {0}", appEngineUser);
            attr.set("endpoints:Authenticated-AppEngine-User", appEngineUser);
        } else {
            logger.log(Level.INFO, "User = {0}", user);
        }
        return user;
    }
}

