/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackendProperties {
    private static final Logger logger = Logger.getLogger(BackendProperties.class.getName());
    public static final String PROJECT_NUMBER_PROPERTY = "GOOGLE_PROJECT_NUMBER";
    public static final long PROJECT_NUMBER_UNKNOWN = 0L;
    public static final String PROJECT_ID_PROPERTY = "GOOGLE_PROJECT_ID";
    private boolean isOnAppEngine;
    private EnvReader envReader;

    public BackendProperties() {
        this(EnvUtil.isRunningOnAppEngine(), new EnvReader());
    }

    @VisibleForTesting
    BackendProperties(boolean isAppEngine, EnvReader envReader) {
        this.isOnAppEngine = isAppEngine;
        this.envReader = envReader;
    }

    public boolean isOnAppEngine() {
        return this.isOnAppEngine;
    }

    public long getProjectNumber() {
        if (this.isOnAppEngine()) {
            return 0L;
        }
        if (this.envReader.getenv(PROJECT_NUMBER_PROPERTY) != null) {
            String property = this.envReader.getenv(PROJECT_NUMBER_PROPERTY);
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Project number (%s) is not an int64.", property);
                return 0L;
            }
        }
        return 0L;
    }

    public String getProjectId() {
        if (this.isOnAppEngine()) {
            return null;
        }
        return this.envReader.getenv(PROJECT_ID_PROPERTY);
    }

    public String getApplicationId() {
        if (this.isOnAppEngine()) {
            return SystemProperty.applicationId.get();
        }
        return null;
    }

    @VisibleForTesting
    static class EnvReader {
        EnvReader() {
        }

        public String getenv(String name) {
            return System.getenv(name);
        }
    }
}

