/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlParser {
    private Map _redirectMap = new HashMap();
    private SAXParser _parser;
    private Map _observerMap;
    private Stack _observers = new Stack();
    private String _xpath;
    private Object _xpaths;
    private String _dtd;

    public XmlParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        boolean bl = sAXParserFactory.getClass().toString().startsWith("org.apache.xerces.");
        String string = System.getProperty("org.mortbay.xml.XmlParser.Validating", bl ? "true" : "false");
        boolean bl2 = Boolean.getBoolean("org.mortbay.xml.XmlParser.NotValidating");
        boolean bl3 = !bl2 && Boolean.valueOf(string) != false;
        this.setValidating(bl3);
    }

    public XmlParser(boolean bl) {
        this.setValidating(bl);
    }

    public void setValidating(boolean bl) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(bl);
            this._parser = sAXParserFactory.newSAXParser();
            try {
                if (bl) {
                    this._parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/schema", bl);
                }
            }
            catch (Exception exception) {
                if (bl) {
                    Log.warn("Schema validation may not be supported: ", exception);
                }
                Log.ignore(exception);
            }
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/validation", bl);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", true);
            this._parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception exception) {
            Log.warn("EXCEPTION ", exception);
            throw new Error(exception.toString());
        }
    }

    public synchronized void redirectEntity(String string, URL uRL) {
        if (uRL != null) {
            this._redirectMap.put(string, uRL);
        }
    }

    public String getXpath() {
        return this._xpath;
    }

    public void setXpath(String string) {
        this._xpath = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "| ");
        while (stringTokenizer.hasMoreTokens()) {
            this._xpaths = LazyList.add(this._xpaths, stringTokenizer.nextToken());
        }
    }

    public String getDTD() {
        return this._dtd;
    }

    public synchronized void addContentHandler(String string, ContentHandler contentHandler) {
        if (this._observerMap == null) {
            this._observerMap = new HashMap();
        }
        this._observerMap.put(string, contentHandler);
    }

    public synchronized Node parse(InputSource inputSource) throws IOException, SAXException {
        this._dtd = null;
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        if (Log.isDebugEnabled()) {
            Log.debug("parsing: sid=" + inputSource.getSystemId() + ",pid=" + inputSource.getPublicId());
        }
        this._parser.parse(inputSource, (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public synchronized Node parse(String string) throws IOException, SAXException {
        if (Log.isDebugEnabled()) {
            Log.debug("parse: " + string);
        }
        return this.parse(new InputSource(string));
    }

    public synchronized Node parse(File file) throws IOException, SAXException {
        if (Log.isDebugEnabled()) {
            Log.debug("parse: " + file);
        }
        return this.parse(new InputSource(file.toURL().toString()));
    }

    public synchronized Node parse(InputStream inputStream) throws IOException, SAXException {
        this._dtd = null;
        Handler handler = new Handler();
        XMLReader xMLReader = this._parser.getXMLReader();
        xMLReader.setContentHandler(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.setEntityResolver(handler);
        this._parser.parse(new InputSource(inputStream), (DefaultHandler)handler);
        if (handler._error != null) {
            throw handler._error;
        }
        Node node = (Node)handler._top.get(0);
        handler.clear();
        return node;
    }

    public static class Node
    extends AbstractList {
        Node _parent;
        private ArrayList _list;
        private String _tag;
        private Attribute[] _attrs;
        private boolean _lastString = false;
        private String _path;

        Node(Node node, String string, Attributes attributes) {
            this._parent = node;
            this._tag = string;
            if (attributes != null) {
                this._attrs = new Attribute[attributes.getLength()];
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getLocalName(i);
                    if (string2 == null || string2.equals("")) {
                        string2 = attributes.getQName(i);
                    }
                    this._attrs[i] = new Attribute(string2, attributes.getValue(i));
                }
            }
        }

        public Node getParent() {
            return this._parent;
        }

        public String getTag() {
            return this._tag;
        }

        public String getPath() {
            if (this._path == null) {
                this._path = this.getParent() != null && this.getParent().getTag() != null ? this.getParent().getPath() + "/" + this._tag : "/" + this._tag;
            }
            return this._path;
        }

        public Attribute[] getAttributes() {
            return this._attrs;
        }

        public String getAttribute(String string) {
            return this.getAttribute(string, null);
        }

        public String getAttribute(String string, String string2) {
            if (this._attrs == null || string == null) {
                return string2;
            }
            for (int i = 0; i < this._attrs.length; ++i) {
                if (!string.equals(this._attrs[i].getName())) continue;
                return this._attrs[i].getValue();
            }
            return string2;
        }

        @Override
        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            return 0;
        }

        @Override
        public Object get(int n) {
            if (this._list != null) {
                return this._list.get(n);
            }
            return null;
        }

        public Node get(String string) {
            if (this._list != null) {
                for (int i = 0; i < this._list.size(); ++i) {
                    Object e = this._list.get(i);
                    if (!(e instanceof Node)) continue;
                    Node node = (Node)e;
                    if (!string.equals(node._tag)) continue;
                    return node;
                }
            }
            return null;
        }

        @Override
        public void add(int n, Object object) {
            if (this._list == null) {
                this._list = new ArrayList();
            }
            if (object instanceof String) {
                if (this._lastString) {
                    int n2 = this._list.size() - 1;
                    this._list.set(n2, (String)this._list.get(n2) + object);
                } else {
                    this._list.add(n, object);
                }
                this._lastString = true;
            } else {
                this._lastString = false;
                this._list.add(n, object);
            }
        }

        @Override
        public void clear() {
            if (this._list != null) {
                this._list.clear();
            }
            this._list = null;
        }

        public String getString(String string, boolean bl, boolean bl2) {
            Node node = this.get(string);
            if (node == null) {
                return null;
            }
            String string2 = node.toString(bl);
            if (string2 != null && bl2) {
                string2 = string2.trim();
            }
            return string2;
        }

        @Override
        public synchronized String toString() {
            return this.toString(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String toString(boolean bl) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer = new StringBuffer();
            synchronized (stringBuffer2) {
                this.toString(stringBuffer, bl);
                return stringBuffer.toString();
            }
        }

        public synchronized String toString(boolean bl, boolean bl2) {
            String string = this.toString(bl);
            if (string != null && bl2) {
                string = string.trim();
            }
            return string;
        }

        private synchronized void toString(StringBuffer stringBuffer, boolean bl) {
            int n;
            if (bl) {
                stringBuffer.append("<");
                stringBuffer.append(this._tag);
                if (this._attrs != null) {
                    for (n = 0; n < this._attrs.length; ++n) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this._attrs[n].getName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(this._attrs[n].getValue());
                        stringBuffer.append("\"");
                    }
                }
            }
            if (this._list != null) {
                if (bl) {
                    stringBuffer.append(">");
                }
                for (n = 0; n < this._list.size(); ++n) {
                    Object e = this._list.get(n);
                    if (e == null) continue;
                    if (e instanceof Node) {
                        ((Node)e).toString(stringBuffer, bl);
                        continue;
                    }
                    stringBuffer.append(e.toString());
                }
                if (bl) {
                    stringBuffer.append("</");
                    stringBuffer.append(this._tag);
                    stringBuffer.append(">");
                }
            } else if (bl) {
                stringBuffer.append("/>");
            }
        }

        public Iterator iterator(final String string) {
            return new Iterator(){
                int c = 0;
                Node _node;

                @Override
                public boolean hasNext() {
                    if (this._node != null) {
                        return true;
                    }
                    while (Node.this._list != null && this.c < Node.this._list.size()) {
                        Node node;
                        Object e = Node.this._list.get(this.c);
                        if (e instanceof Node && string.equals((node = (Node)e)._tag)) {
                            this._node = node;
                            return true;
                        }
                        ++this.c;
                    }
                    return false;
                }

                public Object next() {
                    try {
                        if (this.hasNext()) {
                            Node node = this._node;
                            return node;
                        }
                        throw new NoSuchElementException();
                    }
                    finally {
                        this._node = null;
                        ++this.c;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }

    public static class Attribute {
        private String _name;
        private String _value;

        Attribute(String string, String string2) {
            this._name = string;
            this._value = string2;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }

    private class Handler
    extends DefaultHandler {
        Node _top;
        SAXParseException _error;
        private Node _context;
        private NoopHandler _noop;

        Handler() {
            this._context = this._top = new Node(null, null, null);
            this._noop = new NoopHandler(this);
        }

        void clear() {
            this._top = null;
            this._error = null;
            this._context = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n;
            Object object;
            String string4 = string == null || string.equals("") ? string3 : string2;
            Node node = new Node(this._context, string4, attributes);
            if (XmlParser.this._xpaths != null) {
                object = node.getPath();
                n = 0;
                int n2 = LazyList.size(XmlParser.this._xpaths);
                while (n == 0 && n2-- > 0) {
                    String string5 = (String)LazyList.get(XmlParser.this._xpaths, n2);
                    n = ((String)object).equals(string5) || string5.startsWith((String)object) && string5.length() > ((String)object).length() && string5.charAt(((String)object).length()) == '/' ? 1 : 0;
                }
                if (n != 0) {
                    this._context.add(node);
                    this._context = node;
                } else {
                    XmlParser.this._parser.getXMLReader().setContentHandler(this._noop);
                }
            } else {
                this._context.add(node);
                this._context = node;
            }
            object = null;
            if (XmlParser.this._observerMap != null) {
                object = (ContentHandler)XmlParser.this._observerMap.get(string4);
            }
            XmlParser.this._observers.push(object);
            for (n = 0; n < XmlParser.this._observers.size(); ++n) {
                if (XmlParser.this._observers.get(n) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(n)).startElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this._context = this._context._parent;
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).endElement(string, string2, string3);
            }
            XmlParser.this._observers.pop();
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).ignorableWhitespace(cArray, n, n2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this._context.add(new String(cArray, n, n2));
            for (int i = 0; i < XmlParser.this._observers.size(); ++i) {
                if (XmlParser.this._observers.get(i) == null) continue;
                ((ContentHandler)XmlParser.this._observers.get(i)).characters(cArray, n, n2);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            Log.debug("EXCEPTION ", sAXParseException);
            Log.warn("WARNING@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString());
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this._error == null) {
                this._error = sAXParseException;
            }
            Log.debug("EXCEPTION ", sAXParseException);
            Log.warn("ERROR@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this._error = sAXParseException;
            Log.debug("EXCEPTION ", sAXParseException);
            Log.warn("FATAL@" + this.getLocationString(sAXParseException) + " : " + sAXParseException.toString());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            return sAXParseException.getSystemId() + " line:" + sAXParseException.getLineNumber() + " col:" + sAXParseException.getColumnNumber();
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            Object object;
            if (Log.isDebugEnabled()) {
                Log.debug("resolveEntity(" + string + ", " + string2 + ")");
            }
            if (string2 != null && string2.endsWith(".dtd")) {
                XmlParser.this._dtd = string2;
            }
            URL uRL = null;
            if (string != null) {
                uRL = (URL)XmlParser.this._redirectMap.get(string);
            }
            if (uRL == null) {
                uRL = (URL)XmlParser.this._redirectMap.get(string2);
            }
            if (uRL == null) {
                object = string2;
                if (((String)object).lastIndexOf(47) >= 0) {
                    object = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug("Can't exact match entity in redirect map, trying " + (String)object);
                }
                uRL = (URL)XmlParser.this._redirectMap.get(object);
            }
            if (uRL != null) {
                try {
                    object = uRL.openStream();
                    if (Log.isDebugEnabled()) {
                        Log.debug("Redirected entity " + string2 + " --> " + uRL);
                    }
                    InputSource inputSource = new InputSource((InputStream)object);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
            }
            return null;
        }
    }

    private class NoopHandler
    extends DefaultHandler {
        Handler _next;
        int _depth;

        NoopHandler(Handler handler) {
            this._next = handler;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this._depth;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this._depth == 0) {
                XmlParser.this._parser.getXMLReader().setContentHandler(this._next);
            } else {
                --this._depth;
            }
        }
    }
}

