/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mortbay.log.Frame;
import org.mortbay.log.LogSink;
import org.mortbay.util.Loader;

public class LogImpl
implements Log {
    public static final String DEBUG = "DEBUG  ";
    public static final String INFO = "INFO   ";
    public static final String TRACE = "TRACE  ";
    public static final String FAIL = "FAIL!! ";
    public static final String WARN = "WARN!! ";
    public static final String ERROR = "ERROR! ";
    boolean _debugOn = false;
    private ArrayList _debugPatterns = null;
    private boolean _initialized = false;
    private String _patterns = null;
    public LogSink[] _sinks = null;
    private boolean _suppressWarnings = false;
    private int _verbose = 0;

    public LogImpl() {
        try {
            this._debugOn = System.getProperty("DEBUG") != null;
            this.setDebugPatterns(System.getProperty("DEBUG_PATTERNS"));
            this.setVerbose(Integer.getInteger("DEBUG_VERBOSE", 0));
        }
        catch (Exception e) {
            System.err.println("Exception from getProperty!\nProbably running in applet\nUse Code.initParamsFromApplet or Code.setOption to control debug output.");
        }
    }

    public synchronized void add(LogSink logSink) throws Exception {
        logSink.setLogImpl(this);
        if (!logSink.isStarted()) {
            logSink.start();
        }
        if (this._sinks == null) {
            this._sinks = new LogSink[1];
            this._sinks[0] = logSink;
        } else {
            boolean slotFree = false;
            int i = this._sinks.length;
            while (i-- > 0) {
                if (this._sinks[i] != null) continue;
                slotFree = true;
                this._sinks[i] = logSink;
                break;
            }
            if (!slotFree) {
                LogSink[] ns = new LogSink[this._sinks.length + 1];
                int i2 = this._sinks.length;
                while (i2-- > 0) {
                    ns[i2] = this._sinks[i2];
                }
                ns[this._sinks.length] = logSink;
                this._sinks = ns;
            }
        }
        this._initialized = true;
        this.info("added " + logSink);
    }

    public synchronized void add(String logSinkClass) {
        try {
            if (logSinkClass == null || logSinkClass.length() == 0) {
                logSinkClass = "org.mortbay.log.OutputStreamLogSink";
            }
            Class sinkClass = Loader.loadClass(this.getClass(), logSinkClass);
            LogSink sink = (LogSink)sinkClass.newInstance();
            this.add(sink);
        }
        catch (Exception e) {
            this.message(WARN, (Object)e, 2);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public void debug(Object m) {
        Frame frame;
        if (this._debugOn && this.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            this.message(DEBUG, m, frame);
        }
    }

    public void debug(Object m, Throwable ex) {
        Frame frame;
        if (this._debugOn && this.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            this.message(DEBUG, (Object)new Object[]{m, ex}, frame);
        }
    }

    private synchronized void defaultInit() {
        if (!this._initialized) {
            this._initialized = true;
            String sinkClasses = System.getProperty("LOG_SINKS", "org.mortbay.log.OutputStreamLogSink");
            StringTokenizer sinkTokens = new StringTokenizer(sinkClasses, ";, ");
            LogSink sink = null;
            while (sinkTokens.hasMoreTokens()) {
                String sinkClassName = sinkTokens.nextToken();
                try {
                    Class sinkClass = Loader.loadClass(this.getClass(), sinkClassName);
                    if (LogSink.class.isAssignableFrom(sinkClass)) {
                        sink = (LogSink)sinkClass.newInstance();
                        sink.start();
                        this.add(sink);
                        continue;
                    }
                    System.err.println(sinkClass + " is not a org.mortbay.log.LogSink");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void deleteStoppedLogSinks() {
        if (this._sinks != null) {
            int s = this._sinks.length;
            while (s-- > 0) {
                if (this._sinks[s] == null || this._sinks[s].isStarted()) continue;
                this._sinks[s] = null;
            }
        }
    }

    public synchronized void reset() {
        this.info("reset");
        if (this._sinks != null) {
            int s = this._sinks.length;
            while (s-- > 0) {
                try {
                    if (this._sinks[s] != null) {
                        this._sinks[s].stop();
                    }
                    this._sinks[s] = null;
                }
                catch (InterruptedException e) {
                    if (!this.getDebug() || this.getVerbose() <= 0) continue;
                    this.message("WARN", e);
                }
            }
            this._sinks = null;
        }
        this._initialized = true;
    }

    public void error(Object arg0) {
        this.message(ERROR, arg0, new Frame(1));
    }

    public void error(Object arg0, Throwable arg1) {
        this.message(ERROR, (Object)new Object[]{arg0, arg1}, new Frame(1));
    }

    public void fatal(Object arg0) {
        this.message(FAIL, arg0, new Frame(1));
    }

    public void fatal(Object arg0, Throwable arg1) {
        this.message(FAIL, (Object)new Object[]{arg0, arg1}, new Frame(1));
    }

    public boolean getDebug() {
        return this._debugOn;
    }

    public String getDebugPatterns() {
        return this._patterns;
    }

    public LogSink[] getLogSinks() {
        return this._sinks;
    }

    public boolean getSuppressWarnings() {
        return this._suppressWarnings;
    }

    public int getVerbose() {
        return this._verbose;
    }

    public void info(Object arg0) {
        if (this.isInfoEnabled()) {
            this.message(INFO, arg0, new Frame(1));
        }
    }

    public void info(Object arg0, Throwable arg1) {
        if (this.isInfoEnabled()) {
            this.message(INFO, (Object)new Object[]{arg0, arg1}, new Frame(1));
        }
    }

    public boolean isDebugEnabled() {
        return this._debugOn;
    }

    public boolean isErrorEnabled() {
        return !this._suppressWarnings;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return this._verbose >= 0;
    }

    public boolean isTraceEnabled() {
        return this._verbose > 0;
    }

    public boolean isWarnEnabled() {
        return !this._suppressWarnings;
    }

    public void message(String tag, Object msg, Frame frame) {
        long time = System.currentTimeMillis();
        this.message(tag, msg, frame, time);
    }

    public synchronized void message(String tag, Object msg, Frame frame, long time) {
        if (!this._initialized) {
            this.defaultInit();
        }
        boolean logged = false;
        if (this._sinks != null) {
            int s = this._sinks.length;
            while (s-- > 0) {
                if (this._sinks[s] == null || !this._sinks[s].isStarted()) continue;
                logged = true;
                this._sinks[s].log(tag, msg, frame, time);
            }
        }
        if (!logged) {
            System.err.println(time + ": " + tag + ":" + msg + " @ " + frame);
        }
    }

    public synchronized void message(String tag, Object msg) {
        this.message(tag, msg, new Frame(1), System.currentTimeMillis());
    }

    public synchronized void message(String tag, Object msg, int depth) {
        this.message(tag, msg, new Frame(depth), System.currentTimeMillis());
    }

    public synchronized void setDebug(boolean debug) {
        boolean oldDebug = this._debugOn;
        if (this._debugOn && !debug) {
            this.message(DEBUG, "DEBUG OFF");
        }
        this._debugOn = debug;
        if (!oldDebug && debug) {
            this.message(DEBUG, "DEBUG ON");
        }
    }

    public void setDebugPatterns(String patterns) {
        this._patterns = patterns;
        if (patterns != null && patterns.length() > 0) {
            this._debugPatterns = new ArrayList();
            StringTokenizer tok = new StringTokenizer(patterns, ", \t");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                this._debugPatterns.add(pattern);
            }
        } else {
            this._debugPatterns = null;
        }
    }

    public void setSuppressWarnings(boolean warnings) {
        this._suppressWarnings = warnings;
    }

    public void setVerbose(int verbose) {
        this._verbose = verbose;
    }

    public void trace(Object arg0) {
        if (this.isTraceEnabled()) {
            this.message(TRACE, arg0, new Frame(1));
        }
    }

    public void trace(Object arg0, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.message(TRACE, (Object)new Object[]{arg0, arg1}, new Frame(1));
        }
    }

    public void warn(Object arg0) {
        if (!this._suppressWarnings) {
            this.message(WARN, arg0, new Frame(1));
        }
    }

    public void warn(Object arg0, Throwable arg1) {
        if (!this._suppressWarnings) {
            this.message(WARN, (Object)new Object[]{arg0, arg1}, new Frame(1));
        }
    }

    private boolean isDebugOnFor(Frame frame) {
        if (this._debugOn) {
            if (this._debugPatterns == null) {
                return true;
            }
            int i = this._debugPatterns.size();
            while (--i >= 0) {
                if (frame.getWhere().indexOf((String)this._debugPatterns.get(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

