/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.vmruntime.VmApiProxyDelegate;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.apphosting.vmruntime.VmAppLogsWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class VmRuntimeLogHandler
extends Handler {
    @VisibleForTesting
    static final String JAVA_UTIL_LOGGING_CONFIG_PROPERTY = "java.util.logging.config.file";
    private static final Logger ROOT_LOGGER = Logger.getLogger("");

    private VmRuntimeLogHandler() {
        this.setLevel(Level.FINEST);
        this.setFilter(new ApiProxyLogFilter());
        this.setFormatter(new CustomFormatter());
    }

    private static void reloadLoggingProperties(LogManager logManager) {
        if (System.getProperty(JAVA_UTIL_LOGGING_CONFIG_PROPERTY) == null) {
            return;
        }
        try {
            logManager.readConfiguration();
        }
        catch (IOException | SecurityException e) {
            System.err.println("Warning: caught exception when reading logging properties.");
            String string = String.valueOf(e.getClass().getName());
            String string2 = String.valueOf(e.getMessage());
            System.err.println(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString());
        }
    }

    @VisibleForTesting
    static void init(LogManager logManager) {
        VmRuntimeLogHandler.reloadLoggingProperties(logManager);
        for (Handler handler : ROOT_LOGGER.getHandlers()) {
            if (!(handler instanceof VmRuntimeLogHandler)) continue;
            return;
        }
        ROOT_LOGGER.addHandler(new VmRuntimeLogHandler());
    }

    public static void init() {
        VmRuntimeLogHandler.init(LogManager.getLogManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        String message;
        if (!this.isLoggable(record)) {
            return;
        }
        VmRuntimeLogHandler vmRuntimeLogHandler = this;
        synchronized (vmRuntimeLogHandler) {
            try {
                message = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
        }
        VmApiProxyEnvironment environment = this.getThreadLocalEnvironment();
        if (environment != null) {
            environment.addLogRecord(this.convertLogRecord(record, message));
        }
    }

    private ApiProxy.LogRecord convertLogRecord(LogRecord record, String message) {
        ApiProxy.LogRecord.Level level = this.convertLogLevel(record.getLevel());
        long timestamp = record.getMillis() * 1000L;
        return new ApiProxy.LogRecord(level, timestamp, message);
    }

    @Override
    public void flush() {
        VmApiProxyEnvironment environment = this.getThreadLocalEnvironment();
        if (environment != null) {
            environment.flushLogs();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    private ApiProxy.LogRecord.Level convertLogLevel(Level level) {
        long intLevel = level.intValue();
        if (intLevel >= (long)Level.SEVERE.intValue()) {
            return ApiProxy.LogRecord.Level.error;
        }
        if (intLevel >= (long)Level.WARNING.intValue()) {
            return ApiProxy.LogRecord.Level.warn;
        }
        if (intLevel >= (long)Level.INFO.intValue()) {
            return ApiProxy.LogRecord.Level.info;
        }
        return ApiProxy.LogRecord.Level.debug;
    }

    private VmApiProxyEnvironment getThreadLocalEnvironment() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        if (env instanceof VmApiProxyEnvironment) {
            return (VmApiProxyEnvironment)env;
        }
        return null;
    }

    private static final class CustomFormatter
    extends Formatter {
        private CustomFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            sb.append("\n");
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    }

    private static final class ApiProxyLogFilter
    implements Filter {
        private ApiProxyLogFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            if (VmApiProxyDelegate.class.getName().equals(record.getLoggerName()) && record.getMessage() != null && record.getMessage().contains("logservice")) {
                return false;
            }
            return !VmAppLogsWriter.class.getName().equals(record.getLoggerName());
        }
    }
}

