/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class VmMetadataCache {
    private static final Logger logger = Logger.getLogger(VmMetadataCache.class.getCanonicalName());
    public static final String DEFAULT_META_DATA_SERVER = "metadata";
    public static final String META_DATA_PATTERN = "http://%s/computeMetadata/v1/instance/%s";
    private final Map<String, String> cache = new HashMap<String, String>();
    private static final int TIMEOUT_MILLIS = 120000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadata(String path) {
        Map<String, String> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(path)) {
                return this.cache.get(path);
            }
        }
        String value = null;
        try {
            value = this.getMetadataFromServer(path);
            Map<String, String> map2 = this.cache;
            synchronized (map2) {
                this.cache.put(path, value);
            }
        }
        catch (IOException e) {
            String string = String.valueOf(e.getMessage());
            logger.info(new StringBuilder(35 + String.valueOf(path).length() + String.valueOf(string).length()).append("Meta-data '").append(path).append("' path retrieval error: ").append(string).toString());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, String> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    protected HttpURLConnection openConnection(String path) throws IOException {
        String server = System.getProperty("metadata_server", DEFAULT_META_DATA_SERVER);
        URL url = new URL(String.format(META_DATA_PATTERN, server, path));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Metadata-Flavor", "Google");
        return conn;
    }

    protected String getMetadataFromServer(String path) throws IOException {
        BufferedReader reader = null;
        HttpURLConnection connection = null;
        try {
            int read;
            connection = this.openConnection(path);
            connection.setConnectTimeout(120000);
            connection.setReadTimeout(120000);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer result = new StringBuffer();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                result.append(buffer, 0, read);
            }
            if (connection.getResponseCode() == 200) {
                String string = result.toString().trim();
                return string;
            }
            if (connection.getResponseCode() == 404) {
                String string = null;
                return string;
            }
            String string = String.valueOf(connection.getResponseMessage());
            throw new IOException(new StringBuilder(44 + String.valueOf(path).length() + String.valueOf(string).length()).append("Meta-data request for '").append(path).append("' failed with error: ").append(string).toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    String string = String.valueOf(e.getMessage());
                    logger.info(new StringBuilder(31 + String.valueOf(path).length() + String.valueOf(string).length()).append("Error closing connection for ").append(path).append(": ").append(string).toString());
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

