/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.api.appidentity.AppIdentityServiceFailureException;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.channel.ChannelFailureException;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.images.ImagesServiceFailureException;
import com.google.appengine.api.log.LogServiceException;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.modules.ModulesException;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.taskqueue.TransientFailureException;
import com.google.appengine.api.users.UserServiceFailureException;
import com.google.appengine.api.xmpp.XMPPFailureException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.org.apache.http.client.HttpClient;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.conn.ClientConnectionManager;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.entity.ContentType;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.google.appengine.repackaged.org.apache.http.params.BasicHttpParams;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.apphosting.vmruntime.VmRequestThreadFactory;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class VmApiProxyDelegate
implements ApiProxy.Delegate<VmApiProxyEnvironment> {
    private static final Logger logger = Logger.getLogger(VmApiProxyDelegate.class.getName());
    public static final String RPC_DEADLINE_HEADER = "X-Google-RPC-Service-Deadline";
    public static final String RPC_STUB_ID_HEADER = "X-Google-RPC-Service-Endpoint";
    public static final String RPC_METHOD_HEADER = "X-Google-RPC-Service-Method";
    public static final String REQUEST_ENDPOINT = "/rpc_http";
    public static final String REQUEST_STUB_ID = "app-engine-apis";
    public static final String REQUEST_STUB_METHOD = "/VMRemoteAPI.CallRemoteAPI";
    protected static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    static final int DEFAULT_RPC_TIMEOUT_MS = 60000;
    static final int ADDITIONAL_HTTP_TIMEOUT_BUFFER_MS = 1000;
    protected int defaultTimeoutMs = 60000;
    protected final ExecutorService executor = Executors.newCachedThreadPool();
    protected final HttpClient httpclient;
    final IdleConnectionMonitorThread monitorThread;

    private static ClientConnectionManager createConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(100);
        return connectionManager;
    }

    public VmApiProxyDelegate() {
        this(new DefaultHttpClient(VmApiProxyDelegate.createConnectionManager()));
    }

    @VisibleForTesting
    VmApiProxyDelegate(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.monitorThread = new IdleConnectionMonitorThread(httpclient.getConnectionManager());
        this.monitorThread.start();
    }

    public byte[] makeSyncCall(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData) throws ApiProxy.ApiProxyException {
        return this.makeSyncCallWithTimeout(environment, packageName, methodName, requestData, this.defaultTimeoutMs);
    }

    private byte[] makeSyncCallWithTimeout(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) throws ApiProxy.ApiProxyException {
        return this.makeApiCall(environment, packageName, methodName, requestData, timeoutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeApiCall(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs, boolean wasAsync) {
        environment.apiCallStarted(60000L, wasAsync);
        try {
            byte[] byArray = this.runSyncCall(environment, packageName, methodName, requestData, timeoutMs);
            return byArray;
        }
        finally {
            environment.apiCallCompleted();
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.PROTECTED)
    protected byte[] runSyncCall(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RuntimeException constructException(String exceptionClassName, String message, String packageName, String methodName) {
        try {
            Class<?> c = Class.forName(exceptionClassName);
            Constructor<?> constructor = c.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (RuntimeException)constructor.newInstance(message);
        }
        catch (Exception e) {
            return new ApiProxy.RPCFailedException(packageName, methodName);
        }
    }

    RuntimeException constructApiException(String packageName, String methodName) {
        String message = new StringBuilder(27 + String.valueOf(packageName).length() + String.valueOf(methodName).length()).append("RCP Failure for API call: ").append(packageName).append(" ").append(methodName).toString();
        switch (packageName) {
            case "taskqueue": {
                return new TransientFailureException(message);
            }
            case "app_identity_service": {
                return new AppIdentityServiceFailureException(message);
            }
            case "blobstore": {
                return new BlobstoreFailureException(message);
            }
            case "channel": {
                return new ChannelFailureException(message);
            }
            case "images": {
                return new ImagesServiceFailureException(message);
            }
            case "logservice": {
                return this.constructException(LogServiceException.class.getName(), message, packageName, methodName);
            }
            case "memcache": {
                return new MemcacheServiceException(message);
            }
            case "modules": {
                return this.constructException(ModulesException.class.getName(), message, packageName, methodName);
            }
            case "search": {
                return new SearchException(message);
            }
            case "user": {
                return new UserServiceFailureException(message);
            }
            case "xmpp": {
                return new XMPPFailureException(message);
            }
        }
        if (packageName.startsWith("datastore")) {
            return new DatastoreFailureException(message);
        }
        return new ApiProxy.RPCFailedException(packageName, methodName);
    }

    static HttpPost createRequest(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
        Object traceHeader;
        RemoteApiPb.Request remoteRequest = new RemoteApiPb.Request();
        remoteRequest.setServiceName(packageName);
        remoteRequest.setMethod(methodName);
        remoteRequest.setRequestId(environment.getTicket());
        remoteRequest.setRequestAsBytes(requestData);
        String string = String.valueOf(environment.getServer());
        String string2 = String.valueOf(REQUEST_ENDPOINT);
        HttpPost request = new HttpPost(new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append("http://").append(string).append(string2).toString());
        request.setHeader(RPC_STUB_ID_HEADER, REQUEST_STUB_ID);
        request.setHeader(RPC_METHOD_HEADER, REQUEST_STUB_METHOD);
        BasicHttpParams params = new BasicHttpParams();
        params.setLongParameter("http.conn-manager.timeout", timeoutMs + 1000);
        params.setIntParameter("http.connection.timeout", timeoutMs + 1000);
        params.setIntParameter("http.socket.timeout", timeoutMs + 1000);
        params.setBooleanParameter("http.tcp.nodelay", Boolean.TRUE);
        params.setBooleanParameter("http.connection.stalecheck", Boolean.FALSE);
        request.setParams(params);
        Double deadline = (Double)environment.getAttributes().get(API_DEADLINE_KEY);
        if (deadline == null) {
            request.setHeader(RPC_DEADLINE_HEADER, Double.toString(TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS)));
        } else {
            request.setHeader(RPC_DEADLINE_HEADER, Double.toString(deadline));
        }
        Object dapperHeader = environment.getAttributes().get(VmApiProxyEnvironment.AttributeMapping.DAPPER_ID.attributeKey);
        if (dapperHeader instanceof String) {
            request.setHeader(VmApiProxyEnvironment.AttributeMapping.DAPPER_ID.headerKey, (String)dapperHeader);
        }
        if ((traceHeader = environment.getAttributes().get(VmApiProxyEnvironment.AttributeMapping.CLOUD_TRACE_CONTEXT.attributeKey)) instanceof String) {
            request.setHeader(VmApiProxyEnvironment.AttributeMapping.CLOUD_TRACE_CONTEXT.headerKey, (String)traceHeader);
        }
        ByteArrayEntity postPayload = new ByteArrayEntity(remoteRequest.toByteArray(), ContentType.APPLICATION_OCTET_STREAM);
        postPayload.setChunked(false);
        request.setEntity(postPayload);
        return request;
    }

    private static ApiProxy.ApiProxyException convertRemoteError(RemoteApiPb.Response remoteResponse, String packageName, String methodName, Logger logger) {
        if (remoteResponse.hasRpcError()) {
            return VmApiProxyDelegate.convertApiResponseRpcErrorToException(remoteResponse.getRpcError(), packageName, methodName, logger);
        }
        RemoteApiPb.ApplicationError error = remoteResponse.getApplicationError();
        return new ApiProxy.ApplicationException(error.getCode(), error.getDetail());
    }

    private static ApiProxy.ApiProxyException convertApiResponseRpcErrorToException(RemoteApiPb.RpcError rpcError, String packageName, String methodName, Logger logger) {
        int rpcCode = rpcError.getCode();
        String errorDetail = rpcError.getDetail();
        if (rpcCode > RemoteApiPb.RpcError.ErrorCode.values().length) {
            int n = rpcError.getCode();
            logger.severe(new StringBuilder(67 + String.valueOf(errorDetail).length()).append("Received unrecognized error code from server: ").append(n).append(" details: ").append(errorDetail).toString());
            return new ApiProxy.UnknownException(packageName, methodName);
        }
        RemoteApiPb.RpcError.ErrorCode errorCode = RemoteApiPb.RpcError.ErrorCode.values()[rpcError.getCode()];
        String string = String.valueOf(errorCode);
        logger.warning(new StringBuilder(23 + String.valueOf(packageName).length() + String.valueOf(methodName).length() + String.valueOf(string).length() + String.valueOf(errorDetail).length()).append("RPC failed, API=").append(packageName).append(".").append(methodName).append(" : ").append(string).append(" : ").append(errorDetail).toString());
        switch (errorCode) {
            case CALL_NOT_FOUND: {
                return new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            case PARSE_ERROR: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case SECURITY_VIOLATION: {
                logger.severe("Security violation: invalid request id used!");
                return new ApiProxy.UnknownException(packageName, methodName);
            }
            case CAPABILITY_DISABLED: {
                return new ApiProxy.CapabilityDisabledException(errorDetail, packageName, methodName);
            }
            case OVER_QUOTA: {
                return new ApiProxy.OverQuotaException(packageName, methodName);
            }
            case REQUEST_TOO_LARGE: {
                return new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            case RESPONSE_TOO_LARGE: {
                return new ApiProxy.ResponseTooLargeException(packageName, methodName);
            }
            case BAD_REQUEST: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case CANCELLED: {
                return new ApiProxy.CancelledException(packageName, methodName);
            }
            case FEATURE_DISABLED: {
                return new ApiProxy.FeatureNotEnabledException(errorDetail, packageName, methodName);
            }
            case DEADLINE_EXCEEDED: {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    public Future<byte[]> makeAsyncCall(VmApiProxyEnvironment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        int timeoutMs = this.defaultTimeoutMs;
        if (apiConfig != null && apiConfig.getDeadlineInSeconds() != null) {
            timeoutMs = (int)(apiConfig.getDeadlineInSeconds() * 1000.0);
        }
        environment.aSyncApiCallAdded(60000L);
        return this.executor.submit(new MakeSyncCall(this, environment, packageName, methodName, request, timeoutMs));
    }

    public void log(VmApiProxyEnvironment environment, ApiProxy.LogRecord record) {
        if (environment != null) {
            environment.addLogRecord(record);
        }
    }

    public void flushLogs(VmApiProxyEnvironment environment) {
        if (environment != null) {
            environment.flushLogs();
        }
    }

    public List<Thread> getRequestThreads(VmApiProxyEnvironment environment) {
        Object threadFactory = environment.getAttributes().get("com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY");
        if (threadFactory != null && threadFactory instanceof VmRequestThreadFactory) {
            return ((VmRequestThreadFactory)threadFactory).getRequestThreads();
        }
        logger.warning("Got a call to getRequestThreads() but no VmRequestThreadFactory is available");
        return Lists.newLinkedList();
    }

    class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connectionManager;

        public IdleConnectionMonitorThread(ClientConnectionManager connectionManager) {
            super("IdleApiConnectionMontorThread");
            this.connectionManager = connectionManager;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.connectionManager.closeExpiredConnections();
                    this.connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private class MakeSyncCall
    implements Callable<byte[]> {
        private final VmApiProxyDelegate delegate;
        private final VmApiProxyEnvironment environment;
        private final String packageName;
        private final String methodName;
        private final byte[] requestData;
        private final int timeoutMs;

        public MakeSyncCall(VmApiProxyDelegate delegate, VmApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
            this.delegate = delegate;
            this.environment = environment;
            this.packageName = packageName;
            this.methodName = methodName;
            this.requestData = requestData;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public byte[] call() throws Exception {
            return this.delegate.makeApiCall(this.environment, this.packageName, this.methodName, this.requestData, this.timeoutMs, true);
        }
    }
}

