/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.vmruntime.CommitDelayingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CommitDelayingResponse
extends HttpServletResponseWrapper {
    protected static final String CONTENT_LENGTH = "Content-Length";
    private OutputMode mode = OutputMode.NEW;
    private PrintWriter writer = null;
    private PendingCall pending = null;
    protected final CommitDelayingOutputStream output = new CommitDelayingOutputStream((OutputStream)super.getOutputStream());

    public CommitDelayingResponse(HttpServletResponse response) throws IOException {
        super(response);
    }

    public void commit() throws IOException {
        if (this.pending != null) {
            this.pending.commit();
            return;
        }
        if (this.output.hasContentLength()) {
            super.setHeader(CONTENT_LENGTH, Long.toString(this.output.getContentLength()));
        }
        this.output.flushIfFlushed();
        if (this.writer != null) {
            this.writer.close();
        }
        this.output.closeIfClosed();
    }

    public void flushBuffer() throws IOException {
        this.output.flush();
    }

    public int getBufferSize() {
        return this.output.getBufferSize();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.mode == OutputMode.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this.mode = OutputMode.OUTPUT_STREAM;
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.mode == OutputMode.OUTPUT_STREAM) {
            throw new IllegalStateException("STREAM");
        }
        this.mode = OutputMode.WRITER;
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.output), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.pending != null || this.output.isCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.writer = null;
        this.mode = OutputMode.NEW;
        this.output.reset();
        super.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.output.reset();
        super.resetBuffer();
    }

    public void sendError(int sc) {
        this.sendError(sc, null);
    }

    public void sendError(final int sc, final String msg) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.pending = new PendingCall(){

            @Override
            public void commit() throws IOException {
                CommitDelayingResponse.super.sendError(sc, msg);
            }
        };
    }

    public void sendRedirect(final String location) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.pending = new PendingCall(){

            @Override
            public void commit() throws IOException {
                CommitDelayingResponse.super.sendRedirect(location);
            }
        };
    }

    public void setBufferSize(int size) {
        this.output.setBufferSize(size);
    }

    public void setContentLength(int len) {
        this.output.setContentLength(len);
    }

    private void handleContentLengthHeader(String value) {
        if (value == null) {
            this.output.clearContentLength();
            return;
        }
        this.output.setContentLength(Long.parseLong(value));
    }

    public void setHeader(String name, String value) {
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            this.handleContentLengthHeader(value);
            return;
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            this.handleContentLengthHeader(value);
            return;
        }
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            this.setContentLength(value);
            return;
        }
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (CONTENT_LENGTH.equalsIgnoreCase(name)) {
            this.setContentLength(value);
            return;
        }
        super.addIntHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return CONTENT_LENGTH.equalsIgnoreCase(name) ? this.output.hasContentLength() : super.containsHeader(name);
    }

    public String getHeader(String name) {
        if (name.equals(CONTENT_LENGTH)) {
            return this.output.hasContentLength() ? Long.toString(this.output.getContentLength()) : null;
        }
        return super.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        if (name.equals(CONTENT_LENGTH) && this.output.hasContentLength()) {
            return Arrays.asList(Long.toString(this.output.getContentLength()));
        }
        return super.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        if (this.output.hasContentLength()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)super.getHeaderNames());
            if (this.output.hasContentLength()) {
                builder.add((Object)CONTENT_LENGTH);
            }
            return builder.build();
        }
        return super.getHeaderNames();
    }

    private static enum OutputMode {
        NEW,
        WRITER,
        OUTPUT_STREAM;

    }

    private static interface PendingCall {
        public void commit() throws IOException;
    }
}

