/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

class CommitDelayingOutputStream
extends ServletOutputStream {
    static final int MAX_RESPONSE_SIZE_BYTES = 0x2000000;
    private int bufferSize = 0x2000000;
    static final int MAX_RESPONSE_HEADERS_SIZE_BYTES = 8192;
    private int bytesWritten = 0;
    private boolean closed = false;
    private boolean flushed = false;
    private long contentLength = -1L;
    private boolean contentLengthSet = false;
    private final OutputStream wrappedOutputStream;

    CommitDelayingOutputStream(OutputStream wrappedOutputStream) {
        this.wrappedOutputStream = wrappedOutputStream;
    }

    private void bytesWritten(int num) {
        this.bytesWritten += num;
        if (this.flushed) {
            return;
        }
        if (this.bytesWritten >= this.bufferSize) {
            this.flushed = true;
            return;
        }
        if (this.contentLengthSet && (long)this.bytesWritten >= this.contentLength) {
            this.flushed = true;
        }
    }

    private void ensureWritable() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
    }

    public void close() {
        this.flushed = true;
        this.closed = true;
    }

    void closeIfClosed() throws IOException {
        if (this.closed) {
            this.wrappedOutputStream.close();
        }
    }

    public void flush() throws IOException {
        this.ensureWritable();
        this.flushed = true;
    }

    void flushIfFlushed() throws IOException {
        if (this.flushed) {
            this.wrappedOutputStream.flush();
        }
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        if (this.bytesWritten >= bufferSize) {
            this.flushed = true;
        }
    }

    int getBytesWritten() {
        return this.bytesWritten;
    }

    void clearContentLength() {
        this.contentLength = -1L;
        this.contentLengthSet = false;
    }

    long getContentLength() {
        return this.contentLength;
    }

    boolean hasContentLength() {
        return this.contentLengthSet;
    }

    void setContentLength(long contentLength) {
        this.contentLengthSet = true;
        this.contentLength = contentLength;
        if ((long)this.bytesWritten >= contentLength) {
            this.flushed = true;
        }
    }

    boolean isCommitted() {
        return this.closed || this.flushed;
    }

    void reset() {
        this.bytesWritten = 0;
    }

    private void checkResponseSize(int bytesToWrite) throws IOException {
        if (this.bytesWritten + bytesToWrite > 33546240) {
            throw new IOException("Max response size exceeded.");
        }
    }

    public void write(byte[] b) throws IOException {
        this.checkResponseSize(b.length);
        this.ensureWritable();
        this.wrappedOutputStream.write(b);
        this.bytesWritten(b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkResponseSize(len);
        this.ensureWritable();
        this.wrappedOutputStream.write(b, off, len);
        this.bytesWritten(len);
    }

    public void write(int b) throws IOException {
        this.checkResponseSize(1);
        this.ensureWritable();
        this.wrappedOutputStream.write(b);
        this.bytesWritten(1);
    }

    public void setWriteListener(WriteListener writeListener) {
    }

    public boolean isReady() {
        return true;
    }
}

