/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JdbcMySqlConnectionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(JdbcMySqlConnectionCleanupFilter.class.getCanonicalName());
    static final String CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY = "com.google.appengine.runtime.new_database_connectivity";
    private final AppEngineApiWrapper appEngineApiWrapper;
    private final ConnectionsCleanupWrapper connectionsCleanupWrapper;

    public JdbcMySqlConnectionCleanupFilter() {
        this.appEngineApiWrapper = new AppEngineApiWrapper();
        this.connectionsCleanupWrapper = new ConnectionsCleanupWrapper();
    }

    JdbcMySqlConnectionCleanupFilter(AppEngineApiWrapper appEngineApiWrapper, ConnectionsCleanupWrapper connectionsCleanupWrapper) {
        this.appEngineApiWrapper = appEngineApiWrapper;
        this.connectionsCleanupWrapper = connectionsCleanupWrapper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.cleanupConnections();
        }
    }

    void cleanupConnections() {
        Map<String, Object> attributes = this.appEngineApiWrapper.getRequestEnvironmentAttributes();
        if (attributes == null) {
            return;
        }
        Object cloudSqlJdbcConnectivityEnabledValue = attributes.get(CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY);
        if (!(cloudSqlJdbcConnectivityEnabledValue instanceof Boolean)) {
            return;
        }
        if (!((Boolean)cloudSqlJdbcConnectivityEnabledValue).booleanValue()) {
            return;
        }
        try {
            this.connectionsCleanupWrapper.cleanup();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to cleanup connections", e);
        }
    }

    public void destroy() {
    }

    static class ConnectionsCleanupWrapper {
        private static Method cleanupMethod;
        private static boolean cleanupMethodInitializationAttempted;

        ConnectionsCleanupWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() throws Exception {
            Class<ConnectionsCleanupWrapper> clazz = ConnectionsCleanupWrapper.class;
            synchronized (ConnectionsCleanupWrapper.class) {
                if (!cleanupMethodInitializationAttempted) {
                    try {
                        if (cleanupMethod == null) {
                            cleanupMethod = Class.forName("com.mysql.jdbc.AbandonedConnections").getDeclaredMethod("cleanup", new Class[0]);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    finally {
                        cleanupMethodInitializationAttempted = true;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (cleanupMethod != null) {
                    cleanupMethod.invoke(null, new Object[0]);
                }
                return;
            }
        }
    }

    static class AppEngineApiWrapper {
        AppEngineApiWrapper() {
        }

        Map<String, Object> getRequestEnvironmentAttributes() {
            ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                logger.warning("Unable to fetch the request environment.");
                return null;
            }
            Map attributes = environment.getAttributes();
            if (attributes == null) {
                logger.warning("Unable to fetch the request environment attributes.");
                return null;
            }
            return attributes;
        }
    }
}

