/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final Logger logger = Logger.getLogger(XmlUtils.class.getName());

    static String getText(XmlParser.Node node) throws AppEngineConfigException {
        String value;
        Object child = node.get(0);
        if (child == null) {
            value = "";
        } else {
            if (!(child instanceof String)) {
                String string = String.valueOf(node.getTag());
                String msg = new StringBuilder(48 + String.valueOf(string).length()).append("Invalid XML: String content expected in node '").append(string).append("'.").toString();
                logger.log(Level.SEVERE, msg);
                throw new AppEngineConfigException(msg);
            }
            value = (String)child;
        }
        return value.trim();
    }

    static XmlParser.Node parse(InputStream is) {
        XmlParser xmlParser = new XmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String msg = "Received IOException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String msg = "Received SAXException parsing the input stream.";
            logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }

    public static void validateXml(String xmlFilename, File schema) {
        File xml = new File(xmlFilename);
        if (!xml.exists()) {
            String string = String.valueOf(xml.getPath());
            throw new AppEngineConfigException(new StringBuilder(26 + String.valueOf(string).length()).append("Xml file: ").append(string).append(" does not exist.").toString());
        }
        if (!schema.exists()) {
            String string = String.valueOf(schema.getPath());
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append("Schema file: ").append(string).append(" does not exist.").toString());
        }
        try {
            XmlUtils.validateXmlContent(Files.toString((File)xml, (Charset)Charsets.UTF_8), schema);
        }
        catch (IOException ex) {
            String string = String.valueOf(schema.getPath());
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(xmlFilename).length() + String.valueOf(string).length()).append("IO error validating ").append(xmlFilename).append(" against ").append(string).toString(), ex);
        }
    }

    public static void validateXmlContent(String content, File schema) {
        if (!schema.exists()) {
            String string = String.valueOf(schema.getPath());
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(string).length()).append("Schema file: ").append(string).append(" does not exist.").toString());
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory.newSchema(schema).newValidator().validate(new StreamSource(new ByteArrayInputStream(content.getBytes(Charsets.UTF_8))));
            }
            catch (SAXException ex) {
                String string = String.valueOf(schema.getPath());
                throw new AppEngineConfigException(new StringBuilder(30 + String.valueOf(content).length() + String.valueOf(string).length()).append("XML error validating ").append(content).append(" against ").append(string).toString(), ex);
            }
        }
        catch (IOException ex) {
            String string = String.valueOf(schema.getPath());
            throw new AppEngineConfigException(new StringBuilder(29 + String.valueOf(content).length() + String.valueOf(string).length()).append("IO error validating ").append(content).append(" against ").append(string).toString(), ex);
        }
    }
}

