/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionStore;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;

public class SessionManager
extends AbstractSessionManager {
    private static final Logger logger = Logger.getLogger(SessionManager.class.getName());
    static final String SESSION_PREFIX = "_ahs";
    public static final double UPDATE_TIMESTAMP_RATIO = 0.75;
    private static String lastId = null;
    private final List<SessionStore> sessionStoresInWriteOrder;
    private final List<SessionStore> sessionStoresInReadOrder;

    static String lastId() {
        return lastId;
    }

    public SessionManager(List<SessionStore> sessionStoresInWriteOrder) {
        this.setSessionIdManager((org.eclipse.jetty.server.SessionIdManager)new SessionIdManager());
        this.sessionStoresInWriteOrder = sessionStoresInWriteOrder;
        this.sessionStoresInReadOrder = new ArrayList<SessionStore>(sessionStoresInWriteOrder);
        Collections.reverse(this.sessionStoresInReadOrder);
    }

    protected AppEngineSession newSession(HttpServletRequest request) {
        return new AppEngineSession(request);
    }

    public AppEngineSession getSession(String sessionId) {
        SessionData data = this.loadSession(sessionId);
        if (data != null) {
            long time = System.currentTimeMillis();
            return new AppEngineSession(time, time, sessionId, data);
        }
        return null;
    }

    SessionData loadSession(String sessionId) {
        String string = String.valueOf(SESSION_PREFIX);
        String string2 = String.valueOf(sessionId);
        String key = string2.length() != 0 ? string.concat(string2) : new String(string);
        SessionData data = null;
        for (SessionStore sessionStore : this.sessionStoresInReadOrder) {
            try {
                data = sessionStore.getSession(key);
                if (data == null) continue;
            }
            catch (RuntimeException e) {
                String msg = "Exception while loading session data";
                logger.log(Level.WARNING, msg, e);
                if (ApiProxy.getCurrentEnvironment() == null) break;
                ApiProxy.log((ApiProxy.LogRecord)this.createWarningLogRecord(msg, e));
            }
            break;
        }
        if (data != null && System.currentTimeMillis() > data.getExpirationTime()) {
            long l = (System.currentTimeMillis() - data.getExpirationTime()) / 1000L;
            logger.fine(new StringBuilder(60 + String.valueOf(sessionId).length()).append("Session ").append(sessionId).append(" expired ").append(l).append(" seconds ago, ignoring.").toString());
            return null;
        }
        return data;
    }

    SessionData createSession(String sessionId) {
        String string = String.valueOf(SESSION_PREFIX);
        String string2 = String.valueOf(sessionId);
        String key = string2.length() != 0 ? string.concat(string2) : new String(string);
        SessionData data = new SessionData();
        data.setExpirationTime(System.currentTimeMillis() + this.getSessionExpirationInMilliseconds());
        for (SessionStore sessionStore : this.sessionStoresInWriteOrder) {
            try {
                sessionStore.saveSession(key, data);
            }
            catch (SessionStore.Retryable retryable) {
                throw retryable.getCause();
            }
        }
        return data;
    }

    private long getSessionExpirationInMilliseconds() {
        long seconds = this.getMaxInactiveInterval();
        if (seconds < 0L) {
            return 2147483647000L;
        }
        return seconds * 1000L;
    }

    private ApiProxy.LogRecord createWarningLogRecord(String message, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        if (ex != null) {
            ex.printStackTrace(printWriter);
        }
        return new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.warn, System.currentTimeMillis() * 1000L, stringWriter.toString());
    }

    protected void addSession(AbstractSession session) {
    }

    protected boolean removeSession(String clusterId) {
        AppEngineSession session = this.getSession(clusterId);
        if (session != null) {
            session.deleteSession();
            return true;
        }
        return false;
    }

    protected void shutdownSessions() throws Exception {
    }

    public class AppEngineSession
    extends AbstractSession {
        private final SessionData sessionData;
        private final String key;
        private volatile boolean dirty;

        public AppEngineSession(HttpServletRequest request) {
            super((AbstractSessionManager)SessionManager.this, request);
            this.sessionData = SessionManager.this.createSession(this.getId());
            String string = String.valueOf(this.getId());
            this.key = string.length() != 0 ? SessionManager.SESSION_PREFIX.concat(string) : new String(SessionManager.SESSION_PREFIX);
            this.dirty = false;
        }

        public AppEngineSession(long created, long accessed, String sessionId, SessionData sessionData) {
            super((AbstractSessionManager)SessionManager.this, created, accessed, sessionId);
            this.sessionData = sessionData;
            String string = String.valueOf(sessionId);
            this.key = string.length() != 0 ? SessionManager.SESSION_PREFIX.concat(string) : new String(SessionManager.SESSION_PREFIX);
            this.dirty = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            if (this.dirty) {
                String string = String.valueOf(this.getId());
                logger.fine(new StringBuilder(26 + String.valueOf(string).length()).append("Session ").append(string).append(" is dirty, saving.").toString());
                int delay = 50;
                try {
                    for (int attemptNum = 0; attemptNum < 10; ++attemptNum) {
                        Object object;
                        try {
                            object = this;
                            synchronized (object) {
                                if (this.dirty) {
                                    for (SessionStore sessionStore : SessionManager.this.sessionStoresInWriteOrder) {
                                        sessionStore.saveSession(this.key, this.sessionData);
                                    }
                                    this.dirty = false;
                                }
                                return;
                            }
                        }
                        catch (SessionStore.Retryable retryable) {
                        }
                        catch (ApiProxy.ApiDeadlineExceededException apiDeadlineExceededException) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        object = String.valueOf(this.getId());
                        logger.warning(new StringBuilder(30 + String.valueOf(object).length()).append("Timeout while saving session ").append((String)object).append(".").toString());
                        delay *= 2;
                    }
                    String attemptNum = String.valueOf(this.getId());
                    logger.log(Level.SEVERE, new StringBuilder(43 + String.valueOf(attemptNum).length()).append("Unable to save session ").append(attemptNum).append(" - too many attempts").toString());
                }
                catch (DeadlineExceededException e) {
                    String string2 = String.valueOf(this.getId());
                    logger.log(Level.SEVERE, new StringBuilder(44 + String.valueOf(string2).length()).append("Unable to save session ").append(string2).append(" - too many timeouts.").toString(), e);
                }
            }
        }

        public synchronized Object doGet(String name) {
            return this.sessionData.getValueMap().get(name);
        }

        public synchronized Enumeration<String> doGetAttributeNames() {
            return Collections.enumeration(this.sessionData.getValueMap().keySet());
        }

        public synchronized void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            this.dirty = true;
        }

        public Object doPutOrRemove(String name, Object value) {
            return value == null ? this.sessionData.getValueMap().remove(name) : this.sessionData.getValueMap().put(name, value);
        }

        public synchronized void removeAttribute(String name) {
            super.removeAttribute(name);
            this.dirty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAttributes() {
            while (this.sessionData.getValueMap() != null && this.sessionData.getValueMap().size() > 0) {
                ArrayList<String> keys;
                AppEngineSession appEngineSession = this;
                synchronized (appEngineSession) {
                    keys = new ArrayList<String>(this.sessionData.getValueMap().keySet());
                }
                for (String key : keys) {
                    Object value;
                    AppEngineSession appEngineSession2 = this;
                    synchronized (appEngineSession2) {
                        value = this.doPutOrRemove(key, null);
                    }
                    this.unbindValue(key, value);
                    ((SessionManager)this.getSessionManager()).doSessionAttributeListeners(this, key, value, null);
                }
            }
            if (this.sessionData.getValueMap() != null) {
                this.sessionData.getValueMap().clear();
            }
        }

        public Map<String, Object> getAttributeMap() {
            return this.sessionData.getValueMap();
        }

        protected void timeout() throws IllegalStateException {
        }

        protected boolean access(long accessTime) {
            long expirationTime = this.sessionData.getExpirationTime();
            long timeRemaining = expirationTime - accessTime;
            if (!this.dirty) {
                if ((double)timeRemaining < (double)SessionManager.this.getSessionExpirationInMilliseconds() * 0.75) {
                    this.dirty = true;
                    String string = String.valueOf(this.getId());
                    logger.fine(new StringBuilder(55 + String.valueOf(string).length()).append("Session ").append(string).append(" accessed while near expiration, marking dirty.").toString());
                } else {
                    String string = String.valueOf(this.getId());
                    logger.fine(new StringBuilder(43 + String.valueOf(string).length()).append("Session ").append(string).append(" accessed early, not marking dirty.").toString());
                }
            }
            this.sessionData.setExpirationTime(System.currentTimeMillis() + SessionManager.this.getSessionExpirationInMilliseconds());
            return super.access(accessTime);
        }

        protected boolean checkExpiry(long time) {
            long expirationTime = this.sessionData.getExpirationTime();
            return time >= expirationTime;
        }

        public synchronized void invalidate() throws IllegalStateException {
            super.invalidate();
        }

        void deleteSession() {
            for (SessionStore sessionStore : SessionManager.this.sessionStoresInWriteOrder) {
                sessionStore.deleteSession(this.key);
            }
        }

        public int getAttributes() {
            return 0;
        }

        public synchronized Set<String> getNames() {
            return new HashSet<String>(this.sessionData.getValueMap().keySet());
        }
    }

    public static class SessionIdManager
    extends HashSessionIdManager {
        public SessionIdManager() {
            super((Random)new SecureRandom());
        }

        public String newSessionId(HttpServletRequest request, long created) {
            byte[] randomBytes = new byte[16];
            this._random.nextBytes(randomBytes);
            String id = BaseEncoding.base64Url().omitPadding().encode(randomBytes);
            lastId = id;
            String string = String.valueOf(id);
            logger.fine(string.length() != 0 ? "Created a random session identifier: ".concat(string) : new String("Created a random session identifier: "));
            return id;
        }
    }
}

