/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppEngineDevAgent {
    private static final String AGENT_IMPL = "com.google.appengine.tools.development.agent.impl.AgentImpl";
    private static final String AGENT_IMPL_JAR = "appengine-agentimpl.jar";
    private static final String AGENT_DIR_PROP = "appengine-agent-dir";
    private static final Logger logger = Logger.getLogger(AppEngineDevAgent.class.getName());
    private static Object impl;

    public static void premain(String agentArgs, Instrumentation inst) {
        URL agentImplLib = AppEngineDevAgent.findAgentImplLib();
        URLClassLoader agentImplLoader = new URLClassLoader(new URL[]{agentImplLib}){

            @Override
            protected PermissionCollection getPermissions(CodeSource codesource) {
                PermissionCollection perms = super.getPermissions(codesource);
                perms.add(new AllPermission());
                return perms;
            }
        };
        try {
            Class<?> implClass = agentImplLoader.loadClass(AGENT_IMPL);
            Method getInstance = implClass.getMethod("getInstance", new Class[0]);
            impl = getInstance.invoke(null, new Object[0]);
            Method run = implClass.getMethod("run", Instrumentation.class, Boolean.TYPE);
            run.invoke(impl, inst, AppEngineDevAgent.treatRestrictedClassListViolationsAsErrors(agentArgs));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to load the App Engine dev agent. Security restrictions will not be completely emulated.", e);
        }
    }

    private static boolean treatRestrictedClassListViolationsAsErrors(String agentArgs) {
        return "treatRestrictedClassListViolationsAsErrors=true".equals(agentArgs);
    }

    public static Object getAgent() {
        return impl;
    }

    private static URL findAgentImplLib() {
        File agentDir;
        URL codeLocation = AppEngineDevAgent.class.getProtectionDomain().getCodeSource().getLocation();
        String agentDirFromSysProps = System.getProperty(AGENT_DIR_PROP);
        if (agentDirFromSysProps != null) {
            agentDir = new File(agentDirFromSysProps);
        } else {
            try {
                agentDir = new File(codeLocation.toURI());
            }
            catch (URISyntaxException e) {
                agentDir = new File(codeLocation.getFile());
            }
            agentDir = agentDir.getParentFile();
        }
        if (!agentDir.isDirectory()) {
            String string = String.valueOf(agentDir.getAbsolutePath());
            throw new RuntimeException(string.length() != 0 ? "Unable to find agent directory at ".concat(string) : new String("Unable to find agent directory at "));
        }
        File agentImplLib = new File(agentDir, AGENT_IMPL_JAR);
        if (!agentImplLib.exists()) {
            String string = String.valueOf("Unable to find appengine-agentimpl.jar in ");
            String string2 = String.valueOf(agentDir.getAbsolutePath());
            throw new RuntimeException(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        try {
            return agentImplLib.toURI().toURL();
        }
        catch (MalformedURLException e) {
            String string = String.valueOf(agentImplLib.getAbsolutePath());
            throw new RuntimeException(string.length() != 0 ? "Unable to retrieve a URL for ".concat(string) : new String("Unable to retrieve a URL for "), e);
        }
    }
}

