/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import javax.annotation.Nullable;

public class ValidationException
extends Exception {
    @Nullable
    private final ValidationEventType validationEventType;
    public static final String INVALID_APPID_MESSAGE = "appId should not contain namespace separator char '!'";
    public static final String DIFFERENT_APP_ID_MESSAGE = "mismatched app ids within request: ";
    public static final String DIFFERENT_DATABASE_NAME_MESSAGE = "mismatched database names within request: ";
    public static final String TRANSACTION_WITH_FAILOVER_MESSAGE = "read operations inside transactions can't allow failover";
    public static final String INVALID_TRANSACTION_MESSAGE = "invalid transaction in request";
    public static final String MISSING_APP_ID = "The app id is the empty string.";

    public ValidationException(String message) {
        this(message, (ValidationEventType)null);
    }

    public ValidationException(String message, @Nullable ValidationEventType validationEventType) {
        super(message);
        this.validationEventType = validationEventType;
    }

    public ValidationException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public ValidationException(String message, Throwable cause, @Nullable ValidationEventType validationEventType) {
        super(message, cause);
        this.validationEventType = validationEventType;
    }

    @Nullable
    public ValidationEventType getValidationEventType() {
        return this.validationEventType;
    }

    public static void validateAssertion(boolean assertion, String message, Object ... messageArgs) throws ValidationException {
        ValidationException.validateAssertion(assertion, null, message, messageArgs);
    }

    public static void validateAssertion(boolean assertion, @Nullable ValidationEventType validationEventType, String message, Object ... messageArgs) throws ValidationException {
        if (!assertion) {
            throw new ValidationException(String.format(message, messageArgs), validationEventType);
        }
    }

    public static enum ValidationEventType {
        INDEXED_ENTITY_VALUE_SEEN_WHEN_DISABLED;

    }
}

