/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.DocInverterPerField;
import com.google.appengine.repackaged.org.apache.lucene.index.DocumentsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInfo;
import com.google.appengine.repackaged.org.apache.lucene.index.FieldInvertState;
import com.google.appengine.repackaged.org.apache.lucene.index.InvertedDocEndConsumerPerField;
import com.google.appengine.repackaged.org.apache.lucene.index.NormsWriterPerThread;
import com.google.appengine.repackaged.org.apache.lucene.search.Similarity;
import com.google.appengine.repackaged.org.apache.lucene.util.ArrayUtil;

final class NormsWriterPerField
extends InvertedDocEndConsumerPerField
implements Comparable {
    final NormsWriterPerThread perThread;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    int[] docIDs = new int[1];
    byte[] norms = new byte[1];
    int upto;
    final FieldInvertState fieldState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void reset() {
        this.docIDs = ArrayUtil.shrink(this.docIDs, this.upto);
        this.norms = ArrayUtil.shrink(this.norms, this.upto);
        this.upto = 0;
    }

    public NormsWriterPerField(DocInverterPerField docInverterPerField, NormsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
        this.fieldState = docInverterPerField.fieldState;
    }

    void abort() {
        this.upto = 0;
    }

    public int compareTo(Object other) {
        return this.fieldInfo.name.compareTo(((NormsWriterPerField)other).fieldInfo.name);
    }

    void finish() {
        if (!$assertionsDisabled && this.docIDs.length != this.norms.length) {
            throw new AssertionError();
        }
        if (this.fieldInfo.isIndexed && !this.fieldInfo.omitNorms) {
            if (this.docIDs.length <= this.upto) {
                if (!$assertionsDisabled && this.docIDs.length != this.upto) {
                    throw new AssertionError();
                }
                this.docIDs = ArrayUtil.grow(this.docIDs, 1 + this.upto);
                this.norms = ArrayUtil.grow(this.norms, 1 + this.upto);
            }
            float norm = this.docState.similarity.computeNorm(this.fieldInfo.name, this.fieldState);
            this.norms[this.upto] = Similarity.encodeNorm(norm);
            this.docIDs[this.upto] = this.docState.docID;
            ++this.upto;
        }
    }

    static {
        $assertionsDisabled = !NormsWriterPerField.class.desiredAssertionStatus();
    }
}

