/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.contrib.benchmark;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Header;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HostConfiguration;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.contrib.benchmark.Stats;
import java.io.IOException;

public class BenchmarkWorker {
    private byte[] buffer = new byte[4096];
    private final int verbosity;
    private final HttpClient httpexecutor;

    public BenchmarkWorker(HttpClient httpClient, int n) {
        this.httpexecutor = httpClient;
        this.verbosity = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats execute(HostConfiguration hostConfiguration, HttpMethod httpMethod, int n, boolean bl) throws HttpException {
        Stats stats = new Stats();
        stats.start();
        for (int i = 0; i < n; ++i) {
            try {
                int n2;
                Header[] headerArray;
                this.httpexecutor.executeMethod(hostConfiguration, httpMethod);
                if (this.verbosity >= 4) {
                    System.out.println(">> " + httpMethod.getName() + " " + httpMethod.getURI() + " " + httpMethod.getParams().getVersion());
                    headerArray = httpMethod.getRequestHeaders();
                    for (n2 = 0; n2 < headerArray.length; ++n2) {
                        System.out.print(">> " + headerArray[n2].toString());
                    }
                    System.out.println();
                }
                if (this.verbosity >= 3) {
                    System.out.println(httpMethod.getStatusLine().getStatusCode());
                }
                if (this.verbosity >= 4) {
                    System.out.println("<< " + httpMethod.getStatusLine().toString());
                    headerArray = httpMethod.getResponseHeaders();
                    for (n2 = 0; n2 < headerArray.length; ++n2) {
                        System.out.print("<< " + headerArray[n2].toString());
                    }
                    System.out.println();
                }
                headerArray = httpMethod.getResponseBodyAsStream();
                long l = 0L;
                if (headerArray != null) {
                    int n3 = 0;
                    while ((n3 = headerArray.read(this.buffer)) != -1) {
                        stats.incTotal(n3);
                        l += (long)n3;
                    }
                }
                stats.setContentLength(l);
                stats.incSuccessCount();
            }
            catch (IOException iOException) {
                stats.incFailureCount();
                if (this.verbosity >= 2) {
                    System.err.println("I/O error: " + iOException.getMessage());
                }
            }
            finally {
                httpMethod.releaseConnection();
            }
            if (bl) continue;
            this.httpexecutor.getHttpConnectionManager().closeIdleConnections(0L);
        }
        stats.finish();
        Header header = httpMethod.getResponseHeader("Server");
        if (header != null) {
            stats.setServerName(header.getValue());
        }
        return stats;
    }
}

