/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.collect.TreeMultimap;
import com.google.appengine.repackaged.com.google.common.geometry.ParametrizedS2Point;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2AreaCentroid;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Edge;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeQuery;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Error;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2PolygonBuilder;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import com.google.appengine.repackaged.com.google.common.geometry.S2Projections;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2VertexFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

@GwtCompatible(serializable=true)
public strictfp final class S2Polygon
implements S2Region,
Comparable<S2Polygon>,
Serializable {
    private static final Logger log = Platform.getLoggerForClass(S2Polygon.class);
    private static final Predicate<S2Shape> REVERSE_NONE = Predicates.alwaysFalse();
    private static final Predicate<S2Shape> REVERSE_HOLES = new Predicate<S2Shape>(){

        public boolean apply(S2Shape input) {
            if (input instanceof S2Loop) {
                S2Loop loop = (S2Loop)input;
                return loop.isHole();
            }
            return false;
        }
    };
    private final List<S2Loop> loops = Lists.newArrayList();
    private S2LatLngRect bound;
    private S2LatLngRect subregionBound;
    @VisibleForTesting
    transient S2ShapeIndex index;
    private AtomicInteger unindexedContainsCalls = new AtomicInteger();
    private boolean hasHoles = false;
    private int numVertices = 0;

    public S2Polygon() {
        this.bound = S2LatLngRect.empty();
        this.subregionBound = S2LatLngRect.empty();
        this.initIndex();
    }

    public S2Polygon(S2Cell cell) {
        this.loops.add(new S2Loop(cell));
        this.initOneLoop();
    }

    public S2Polygon(List<S2Loop> loops) {
        this.initNested(loops);
    }

    public S2Polygon(S2Loop loop) {
        this.numVertices = loop.numVertices();
        this.bound = loop.getRectBound();
        this.subregionBound = loop.getSubregionBound();
        this.loops.add(loop);
        this.initIndex();
    }

    public S2Polygon(S2Polygon src) {
        this.copy(src);
    }

    void copy(S2Polygon src) {
        this.bound = src.bound;
        this.subregionBound = src.subregionBound;
        this.hasHoles = src.hasHoles;
        this.numVertices = src.numVertices;
        for (int i = 0; i < src.numLoops(); ++i) {
            this.loops.add(new S2Loop(src.loop(i)));
        }
        this.initIndex();
    }

    private void initIndex() {
        int maxUnindexedContainsCalls = this.numVertices <= 8 ? 10 : (this.numVertices <= 8192 ? 50 : (this.numVertices <= 50000 ? 10 : 2));
        this.unindexedContainsCalls.set(maxUnindexedContainsCalls);
        this.index = new S2ShapeIndex();
        for (int i = 0; i < this.numLoops(); ++i) {
            this.index.add(this.loop(i));
        }
    }

    private Object readResolve() {
        this.initIndex();
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof S2Polygon) {
            S2Polygon that = (S2Polygon)o;
            return this.numVertices == that.numVertices && this.bound.equals(that.bound) && this.loops.equals(that.loops);
        }
        return false;
    }

    public int hashCode() {
        return this.bound.hashCode();
    }

    @Override
    public int compareTo(S2Polygon other) {
        if (this.numLoops() != other.numLoops()) {
            return this.numLoops() - other.numLoops();
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            int compare = this.loops.get(i).compareTo(other.loops.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public void init(List<S2Loop> loops) {
        this.initNested(loops);
    }

    public void initNested(List<S2Loop> loops) {
        this.clearLoops();
        if (loops.size() == 1) {
            this.loops.clear();
            this.loops.add(loops.remove(0));
            this.initOneLoop();
            return;
        }
        IdentityHashMap loopMap = Maps.newIdentityHashMap();
        loopMap.put(null, Lists.newArrayList());
        for (S2Loop loop : loops) {
            S2Polygon.insertLoop(loop, null, loopMap);
        }
        loops.clear();
        S2Polygon.sortValueLoops(loopMap);
        this.initLoop(null, -1, loopMap);
        this.initLoopProperties();
    }

    public void initOriented(List<S2Loop> loops) {
        Preconditions.checkState((boolean)this.loops.isEmpty());
        Set containedOrigin = Sets.newIdentityHashSet();
        for (S2Loop loop : loops) {
            double angle;
            if (loop.containsOrigin()) {
                containedOrigin.add(loop);
            }
            if (Math.abs(angle = loop.getTurningAngle()) > 1.0E-14) {
                if (!(angle < 0.0)) continue;
                loop.invert();
                continue;
            }
            if (!loop.containsOrigin()) continue;
            loop.invert();
        }
        this.initNested(loops);
        if (this.numLoops() > 0) {
            S2Loop originLoop = this.loop(0);
            boolean polygonContainsOrigin = false;
            for (int i = 0; i < this.numLoops(); ++i) {
                if (!this.loop(i).containsOrigin()) continue;
                polygonContainsOrigin ^= true;
                originLoop = this.loop(i);
            }
            if (containedOrigin.contains(originLoop) != polygonContainsOrigin) {
                this.invert();
            }
        }
        for (S2Loop loop : loops) {
            assert (containedOrigin.contains(loop) != loop.containsOrigin() == loop.isHole());
        }
    }

    private void initLoopProperties() {
        this.hasHoles = false;
        this.numVertices = 0;
        S2LatLngRect.Builder builder = S2LatLngRect.Builder.empty();
        for (S2Loop loop : this.loops) {
            if (loop.isHole()) {
                this.hasHoles = true;
            } else {
                builder.union(loop.getRectBound());
            }
            this.numVertices += loop.numVertices();
        }
        this.bound = builder.build();
        this.subregionBound = S2EdgeUtil.RectBounder.expandForSubregions(this.bound);
        this.initIndex();
    }

    private void initOneLoop() {
        assert (1 == this.loops.size());
        S2Loop loop = this.loops.get(0);
        loop.setDepth(0);
        this.hasHoles = false;
        this.numVertices = loop.numVertices();
        this.bound = loop.getRectBound();
        this.subregionBound = loop.getSubregionBound();
        this.initIndex();
    }

    public void initWithNestedLoops(Map<S2Loop, List<S2Loop>> nestedLoops) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        this.initLoop(null, -1, nestedLoops);
        nestedLoops.clear();
        this.initLoopProperties();
    }

    public void release(List<S2Loop> loops) {
        loops.addAll(this.loops);
        this.loops.clear();
        this.bound = S2LatLngRect.empty();
        this.subregionBound = S2LatLngRect.empty();
        this.hasHoles = false;
        this.numVertices = 0;
        this.initIndex();
    }

    private void clearLoops() {
        this.loops.clear();
        this.initIndex();
    }

    public static boolean isValid(List<S2Loop> loops) {
        return new S2Polygon(Lists.newArrayList(loops)).isValid();
    }

    public boolean isValid() {
        S2Error error = new S2Error();
        return !this.findValidationError(error);
    }

    public boolean findValidationError(S2Error error) {
        for (int i = 0; i < this.numLoops(); ++i) {
            if (this.loop(i).findValidationErrorNoIndex(error)) {
                int n = i;
                String string = String.valueOf(error.text());
                error.init(error.code(), new StringBuilder(18 + String.valueOf(string).length()).append("Loop ").append(n).append(": ").append(string).toString(), new Object[0]);
                return true;
            }
            if (this.loop(i).isEmpty()) {
                int n = i;
                error.init(S2Error.Code.POLYGON_EMPTY_LOOP, new StringBuilder(46).append("Loop ").append(n).append(": empty loops are not allowed.").toString(), new Object[0]);
                return true;
            }
            if (!this.loop(i).isFull() || this.numLoops() <= 1) continue;
            int n = i;
            error.init(S2Error.Code.POLYGON_EXCESS_FULL_LOOP, new StringBuilder(55).append("Loop ").append(n).append(": full loop appears in non-full polygon").toString(), new Object[0]);
            return true;
        }
        return S2ShapeUtil.findAnyCrossing(this.index, this.loops, error);
    }

    public boolean isEmpty() {
        return this.loops.isEmpty();
    }

    public boolean isFull() {
        return this.loops.size() == 1 && this.loops.get(0).isFull();
    }

    public int numLoops() {
        return this.loops.size();
    }

    public S2Loop loop(int k) {
        return this.loops.get(k);
    }

    public int getParent(int k) {
        int depth = this.loop(k).depth();
        if (depth == 0) {
            return -1;
        }
        while (--k >= 0 && this.loop(k).depth() >= depth) {
        }
        return k;
    }

    public int getLastDescendant(int k) {
        if (k < 0) {
            return this.numLoops() - 1;
        }
        int depth = this.loop(k).depth();
        while (++k < this.numLoops() && this.loop(k).depth() > depth) {
        }
        return k - 1;
    }

    private S2AreaCentroid getAreaCentroid(boolean doCentroid) {
        double areaSum = 0.0;
        S2Point centroidSum = S2Point.ORIGIN;
        for (int i = 0; i < this.numLoops(); ++i) {
            S2AreaCentroid areaCentroid = doCentroid ? this.loop(i).getAreaAndCentroid() : null;
            double loopArea = doCentroid ? areaCentroid.getArea() : this.loop(i).getArea();
            int loopSign = this.loop(i).sign();
            areaSum += (double)loopSign * loopArea;
            if (!doCentroid) continue;
            S2Point currentCentroid = areaCentroid.getCentroid();
            centroidSum = new S2Point(centroidSum.x + (double)loopSign * currentCentroid.x, centroidSum.y + (double)loopSign * currentCentroid.y, centroidSum.z + (double)loopSign * currentCentroid.z);
        }
        return new S2AreaCentroid(areaSum, doCentroid ? centroidSum : null);
    }

    public S2AreaCentroid getAreaAndCentroid() {
        return this.getAreaCentroid(true);
    }

    public double getArea() {
        return this.getAreaCentroid(false).getArea();
    }

    public S2Point getCentroid() {
        return this.getAreaCentroid(true).getCentroid();
    }

    public int getSnapLevel() {
        int snapLevel = -1;
        for (S2Loop loop : this.loops) {
            for (int j = 0; j < loop.numVertices(); ++j) {
                S2Point p = loop.vertex(j);
                S2Projections.FaceSiTi faceSiTi = S2Projections.PROJ.xyzToFaceSiTi(p);
                int level = S2Projections.PROJ.levelIfCenter(faceSiTi, p);
                if (level < 0) {
                    return level;
                }
                if (level == snapLevel) continue;
                if (snapLevel < 0) {
                    snapLevel = level;
                    continue;
                }
                return -1;
            }
        }
        return snapLevel;
    }

    public S1Angle getDistance(S2Point p) {
        if (this.contains(p)) {
            return S1Angle.radians(0.0);
        }
        S1Angle minDistance = S1Angle.radians(Math.PI);
        for (int i = 0; i < this.numLoops(); ++i) {
            minDistance = S1Angle.min(minDistance, this.loop(i).getDistance(p));
        }
        return minDistance;
    }

    public S2Point project(S2Point p) {
        Preconditions.checkState((!this.loops.isEmpty() ? 1 : 0) != 0);
        if (this.contains(p)) {
            return p;
        }
        S2Point normalized = S2Point.normalize(p);
        S1Angle minDistance = S1Angle.radians(Math.PI);
        int minLoopIndex = 0;
        int minVertexIndex = 0;
        for (int loopIndex = 0; loopIndex < this.loops.size(); ++loopIndex) {
            S2Loop loop = this.loops.get(loopIndex);
            for (int vertexIndex = 0; vertexIndex < loop.numVertices(); ++vertexIndex) {
                S1Angle distanceToSegment = S2EdgeUtil.getDistance(normalized, loop.vertex(vertexIndex), loop.vertex(vertexIndex + 1));
                if (!minDistance.greaterThan(distanceToSegment)) continue;
                minDistance = distanceToSegment;
                minLoopIndex = loopIndex;
                minVertexIndex = vertexIndex;
            }
        }
        S2Loop minLoop = this.loop(minLoopIndex);
        S2Point closestPoint = S2EdgeUtil.getClosestPoint(p, minLoop.vertex(minVertexIndex), minLoop.vertex(minVertexIndex + 1));
        return closestPoint;
    }

    public boolean contains(S2Polygon b) {
        if (this.numLoops() == 1 && b.numLoops() == 1) {
            return this.loop(0).contains(b.loop(0));
        }
        if (!this.subregionBound.contains(b.getRectBound()) && !this.bound.lng().union(b.getRectBound().lng()).isFull()) {
            return false;
        }
        if (!this.hasHoles && !b.hasHoles) {
            for (int j = 0; j < b.numLoops(); ++j) {
                if (this.anyLoopContains(b.loop(j))) continue;
                return false;
            }
            return true;
        }
        return this.containsBoundary(b) && b.excludesNonCrossingComplementShells(this);
    }

    public boolean approxContains(S2Polygon b, S1Angle vertexMergeRadius) {
        S2Polygon difference = new S2Polygon();
        difference.initToDifferenceSloppy(b, this, vertexMergeRadius);
        return difference.numLoops() == 0;
    }

    public boolean intersects(S2Polygon b) {
        if (this.numLoops() == 1 && b.numLoops() == 1) {
            return this.loop(0).intersects(b.loop(0));
        }
        if (!this.bound.intersects(b.getRectBound())) {
            return false;
        }
        if (!this.hasHoles && !b.hasHoles) {
            for (S2Loop loop : b.loops) {
                if (!this.anyLoopIntersects(loop)) continue;
                return true;
            }
            return false;
        }
        return !this.excludesBoundary(b) || !b.excludesNonCrossingShells(this);
    }

    private static void clipBoundary(S2Polygon a, boolean reverseA, S2Polygon b, boolean invertB, boolean addSharedEdges, S2PolygonBuilder builder) {
        EdgeClipper clipper = new EdgeClipper(b.index, addSharedEdges, REVERSE_HOLES);
        ArrayList intersections = Lists.newArrayList();
        for (S2Loop aLoop : a.loops) {
            int j;
            int n = aLoop.numVertices();
            int dir = aLoop.isHole() ^ reverseA ? -1 : 1;
            boolean inside = b.contains(aLoop.vertex(0)) ^ invertB;
            int n2 = j = dir > 0 ? 0 : n;
            while (n > 0) {
                S2Point a0 = aLoop.vertex(j);
                S2Point a1 = aLoop.vertex(j + dir);
                clipper.clipEdge(a0, a1, intersections);
                if (inside) {
                    intersections.add(new ParametrizedS2Point(0.0, a0));
                }
                boolean bl = inside = (intersections.size() & 1) == 1;
                if (inside) {
                    intersections.add(new ParametrizedS2Point(1.0, a1));
                }
                Collections.sort(intersections);
                for (int k = 0; k < intersections.size(); k += 2) {
                    S2Point y;
                    S2Point x = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                    if (x.equalsPoint(y = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) continue;
                    builder.addEdge(x, y);
                }
                intersections.clear();
                --n;
                j += dir;
            }
        }
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void initToComplement(S2Polygon a) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        this.copy(a);
        this.invert();
    }

    public void initToSnapped(S2Polygon a, int snapLevel) {
        S2PolygonBuilder.Options options = S2PolygonBuilder.Options.builder().setRobustnessRadius(S1Angle.radians(S2Projections.PROJ.maxDiag.getValue(snapLevel) / 2.0 + 1.0E-15)).setSnapToCellCenters(true).build();
        S2PolygonBuilder polygonBuilder = new S2PolygonBuilder(options);
        polygonBuilder.addPolygon(a);
        if (!polygonBuilder.assemblePolygon(this, null)) {
            log.severe("assemblePolygon failed in initToSnapped");
        }
        if (this.numLoops() == 0 && a.bound.area() > Math.PI * 2 && a.getArea() > Math.PI * 2) {
            this.invert();
        }
    }

    private void invert() {
        if (this.isEmpty()) {
            this.loops.add(S2Loop.full());
        } else if (this.isFull()) {
            this.clearLoops();
        } else {
            S2Loop loop;
            int i;
            int best = -1;
            double bestAngle = 0.0;
            for (int i2 = 1; i2 < this.numLoops(); ++i2) {
                double angle;
                S2Loop loop2 = this.loop(i2);
                if (loop2.depth() != 0) continue;
                if (best == -1) {
                    best = 0;
                    bestAngle = this.loop(best).getTurningAngle();
                }
                if (!((angle = loop2.getTurningAngle()) < bestAngle)) continue;
                best = i2;
                bestAngle = angle;
            }
            if (best < 0) {
                best = 0;
            }
            this.loop(best).invert();
            ArrayList newLoops = Lists.newArrayListWithCapacity((int)this.numLoops());
            newLoops.add(this.loop(best));
            int lastBest = this.getLastDescendant(best);
            for (i = 0; i < this.numLoops(); ++i) {
                if (i >= best && i <= lastBest) continue;
                loop = this.loop(i);
                loop.setDepth(loop.depth() + 1);
                newLoops.add(loop);
            }
            for (i = 0; i < this.numLoops(); ++i) {
                if (i <= best || i > lastBest) continue;
                loop = this.loop(i);
                loop.setDepth(loop.depth() - 1);
                newLoops.add(loop);
            }
            Preconditions.checkState((this.loops.size() == newLoops.size() ? 1 : 0) != 0);
            this.loops.clear();
            this.loops.addAll(newLoops);
        }
        this.initLoopProperties();
    }

    public void initToIntersection(S2Polygon a, S2Polygon b) {
        this.initToIntersectionSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToIntersectionSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!a.isEmpty() && !b.isEmpty()) {
            if (a.isFull()) {
                this.copy(b);
            } else if (b.isFull()) {
                this.copy(a);
            } else {
                if (!a.bound.intersects(b.bound)) {
                    return;
                }
                S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
                S2PolygonBuilder builder = new S2PolygonBuilder(options);
                S2Polygon.clipBoundary(a, false, b, false, true, builder);
                S2Polygon.clipBoundary(b, false, a, false, false, builder);
                if (!builder.assemblePolygon(this, null)) {
                    log.severe("Bad directed edges");
                }
                if (this.numLoops() == 0) {
                    double maxArea;
                    double bArea;
                    if (a.bound.area() <= Math.PI * 2 || b.bound.area() <= Math.PI * 2) {
                        return;
                    }
                    double aArea = a.getArea();
                    double minArea = Math.max(0.0, aArea + (bArea = b.getArea()) - Math.PI * 4);
                    if (minArea > Math.PI * 4 - (maxArea = Math.min(aArea, bArea))) {
                        this.invert();
                    }
                }
            }
        }
    }

    public void initToUnion(S2Polygon a, S2Polygon b) {
        this.initToUnionSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToUnionSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (a.isEmpty() || b.isFull()) {
            this.copy(b);
        } else if (b.isEmpty() || a.isFull()) {
            this.copy(a);
        } else {
            S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
            S2PolygonBuilder builder = new S2PolygonBuilder(options);
            S2Polygon.clipBoundary(a, false, b, true, true, builder);
            S2Polygon.clipBoundary(b, false, a, true, false, builder);
            if (!builder.assemblePolygon(this, null)) {
                log.severe("Bad directed edges");
            }
            if (this.numLoops() == 0) {
                double maxArea;
                double bArea;
                if (a.bound.area() + b.bound.area() <= Math.PI * 2) {
                    return;
                }
                double aArea = a.getArea();
                double minArea = Math.max(aArea, bArea = b.getArea());
                if (minArea > Math.PI * 4 - (maxArea = Math.min(Math.PI * 4, aArea + bArea))) {
                    this.invert();
                }
            }
        }
    }

    public void initToDifference(S2Polygon a, S2Polygon b) {
        this.initToDifferenceSloppy(a, b, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public void initToDifferenceSloppy(S2Polygon a, S2Polygon b, S1Angle vertexMergeRadius) {
        Preconditions.checkState((this.numLoops() == 0 ? 1 : 0) != 0);
        if (!a.isEmpty() && !b.isFull()) {
            if (a.isFull()) {
                this.initToComplement(b);
            } else {
                S2PolygonBuilder.Options options = S2PolygonBuilder.Options.DIRECTED_XOR.toBuilder().setMergeDistance(vertexMergeRadius).build();
                S2PolygonBuilder builder = new S2PolygonBuilder(options);
                S2Polygon.clipBoundary(a, false, b, true, true, builder);
                S2Polygon.clipBoundary(b, true, a, false, false, builder);
                if (!builder.assemblePolygon(this, null)) {
                    log.severe("Bad directed edges");
                }
                if (this.numLoops() == 0) {
                    double maxArea;
                    double bArea;
                    if (a.bound.area() <= Math.PI * 2 || b.bound.area() >= Math.PI * 2) {
                        return;
                    }
                    double aArea = a.getArea();
                    double minArea = Math.max(0.0, aArea - (bArea = b.getArea()));
                    if (minArea > Math.PI * 4 - (maxArea = Math.min(aArea, Math.PI * 4 - bArea))) {
                        this.invert();
                    }
                }
            }
        }
    }

    public void initToSimplified(S2Polygon a, S1Angle tolerance, boolean snapToCellCenters) {
        this.initToSimplifiedInternal(a, tolerance, snapToCellCenters, null);
    }

    public void initToSimplifiedInCell(S2Polygon a, final S2Cell cell, S1Angle tolerance) {
        this.initToSimplifiedInternal(a, tolerance, false, new S2VertexFilter(){
            private final S2Point[] corners;
            private final S1Angle d;
            {
                this.corners = new S2Point[]{cell.getVertex(0), cell.getVertex(1), cell.getVertex(2), cell.getVertex(3)};
                this.d = S1Angle.radians(1.0E-15);
            }

            @Override
            public boolean shouldKeepVertex(S2Point vertex) {
                for (int i = 0; i < 4; ++i) {
                    if (!S2EdgeUtil.getDistance(vertex, this.corners[i], this.corners[(i + 1) % 4]).lessThan(this.d)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void initToSimplifiedInternal(S2Polygon a, S1Angle tolerance, boolean snapToCellCenters, S2VertexFilter vertexFilter) {
        S2PolygonBuilder.Options.Builder options = S2PolygonBuilder.Options.UNDIRECTED_XOR.toBuilder();
        options.setValidate(false);
        if (vertexFilter != null) {
            options.setMergeDistance(S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
        } else {
            options.setMergeDistance(S1Angle.radians(tolerance.radians() * 0.1));
            options.setSnapToCellCenters(snapToCellCenters);
        }
        S2PolygonBuilder builder = new S2PolygonBuilder(options.build());
        S2ShapeIndex index = new S2ShapeIndex();
        for (int i = 0; i < a.numLoops(); ++i) {
            S2Loop simpler = a.loop(i).simplify(tolerance, vertexFilter);
            if (simpler == null) continue;
            index.add(simpler);
        }
        if (!index.shapes.isEmpty()) {
            S2Polygon.breakEdgesAndAddToBuilder(index, builder);
            if (!builder.assemblePolygon(this, null)) {
                log.warning("Bad edges in InitToSimplified.");
            }
            if (this.numLoops() == 0 && a.bound.area() > Math.PI * 2 && a.getArea() > Math.PI * 2) {
                this.invert();
            }
        }
    }

    public static void breakEdgesAndAddToBuilder(S2ShapeIndex index, S2PolygonBuilder builder) {
        EdgeClipper clipper = new EdgeClipper(index, true, REVERSE_NONE);
        ArrayList intersections = Lists.newArrayList();
        S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
        for (S2Shape shape : index.getShapes()) {
            int numEdges = shape.numEdges();
            for (int e = 0; e < numEdges; ++e) {
                shape.getEdge(e, edge);
                intersections.add(new ParametrizedS2Point(0.0, edge.a));
                clipper.clipEdge(edge.a, edge.b, intersections);
                intersections.add(new ParametrizedS2Point(1.0, edge.b));
                Collections.sort(intersections);
                int k = 0;
                while (k + 1 < intersections.size()) {
                    S2Point p2;
                    S2Point p1 = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                    if (!p1.equalsPoint(p2 = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) {
                        builder.addEdge(p1, p2);
                    }
                    ++k;
                }
                intersections.clear();
            }
        }
    }

    public static S2Polygon destructiveUnion(List<S2Polygon> polygons) {
        return S2Polygon.destructiveUnionSloppy(polygons, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public static S2Polygon destructiveUnionSloppy(List<S2Polygon> polygons, S1Angle vertexMergeRadius) {
        TreeMultimap queue = TreeMultimap.create();
        for (S2Polygon polygon : polygons) {
            queue.put((Object)polygon.getNumVertices(), (Object)polygon);
        }
        polygons.clear();
        Set queueSet = queue.entries();
        while (queueSet.size() > 1) {
            queueSet = queue.entries();
            Iterator smallestIter = queueSet.iterator();
            Map.Entry smallest = (Map.Entry)smallestIter.next();
            int aSize = (Integer)smallest.getKey();
            S2Polygon aPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            smallest = (Map.Entry)smallestIter.next();
            int bSize = (Integer)smallest.getKey();
            S2Polygon bPolygon = (S2Polygon)smallest.getValue();
            smallestIter.remove();
            S2Polygon unionPolygon = new S2Polygon();
            unionPolygon.initToUnionSloppy(aPolygon, bPolygon, vertexMergeRadius);
            int unionSize = aSize + bSize;
            queue.put((Object)unionSize, (Object)unionPolygon);
        }
        if (queue.isEmpty()) {
            return new S2Polygon();
        }
        return (S2Polygon)queue.get(queue.asMap().firstKey()).first();
    }

    public List<S2Polyline> intersectWithPolyline(S2Polyline in) {
        return this.intersectWithPolylineSloppy(in, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public List<S2Polyline> intersectWithPolylineSloppy(S2Polyline in, S1Angle vertexMergeRadius) {
        return this.internalClipPolyline(false, in, vertexMergeRadius);
    }

    public List<S2Polyline> subtractFromPolyline(S2Polyline in) {
        return this.subtractFromPolylineSloppy(in, S2EdgeUtil.DEFAULT_INTERSECTION_TOLERANCE);
    }

    public List<S2Polyline> subtractFromPolylineSloppy(S2Polyline in, S1Angle vertexMergeRadius) {
        return this.internalClipPolyline(true, in, vertexMergeRadius);
    }

    private List<S2Polyline> internalClipPolyline(boolean invert, S2Polyline a, S1Angle mergeRadius) {
        ArrayList out = Lists.newArrayList();
        EdgeClipper clipper = new EdgeClipper(this.index, true, REVERSE_NONE);
        ArrayList intersections = Lists.newArrayList();
        ArrayList vertices = Lists.newArrayList();
        int n = a.numVertices();
        boolean inside = this.contains(a.vertex(0)) ^ invert;
        for (int j = 0; j < n - 1; ++j) {
            S2Point a0 = a.vertex(j);
            S2Point a1 = a.vertex(j + 1);
            clipper.clipEdge(a0, a1, intersections);
            if (inside) {
                intersections.add(new ParametrizedS2Point(0.0, a0));
            }
            boolean bl = inside = (intersections.size() & 1) != 0;
            if (inside) {
                intersections.add(new ParametrizedS2Point(1.0, a1));
            }
            Collections.sort(intersections);
            for (int k = 0; k < intersections.size(); k += 2) {
                S2Point v1;
                S2Point v0 = ((ParametrizedS2Point)intersections.get(k)).getPoint();
                if (v0.equalsPoint(v1 = ((ParametrizedS2Point)intersections.get(k + 1)).getPoint())) continue;
                if (!vertices.isEmpty() && ((S2Point)vertices.get(vertices.size() - 1)).angle(v0) > mergeRadius.radians()) {
                    out.add(new S2Polyline(vertices));
                    vertices.clear();
                }
                if (vertices.isEmpty()) {
                    vertices.add(v0);
                }
                if (!(((S2Point)vertices.get(vertices.size() - 1)).angle(v1) > mergeRadius.radians())) continue;
                vertices.add(v1);
            }
            intersections.clear();
        }
        if (!vertices.isEmpty()) {
            out.add(new S2Polyline(vertices));
        }
        return out;
    }

    public boolean isNormalized() {
        HashSet vertices = Sets.newHashSet();
        S2Loop lastParent = null;
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop child = this.loop(i);
            if (child.depth() == 0) continue;
            S2Loop parent = this.loop(this.getParent(i));
            if (parent != lastParent) {
                vertices.clear();
                for (int j = 0; j < parent.numVertices(); ++j) {
                    vertices.add(parent.vertex(j));
                }
                lastParent = parent;
            }
            int count = 0;
            for (int j = 0; j < child.numVertices(); ++j) {
                if (!vertices.contains(child.vertex(j))) continue;
                ++count;
            }
            if (count <= true) continue;
            return false;
        }
        return true;
    }

    boolean boundaryApproxEquals(S2Polygon b, double maxError) {
        if (this.numLoops() != b.numLoops()) {
            String string = String.valueOf(Integer.toString(this.numLoops()));
            String string2 = String.valueOf(Integer.toString(b.numLoops()));
            log.severe(new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append("!= loops: ").append(string).append(" vs. ").append(string2).toString());
            return false;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop aLoop = this.loop(i);
            boolean success = false;
            for (int j = 0; j < this.numLoops(); ++j) {
                S2Loop bLoop = b.loop(j);
                if (bLoop.depth() != aLoop.depth() || !bLoop.boundaryApproxEquals(aLoop, maxError)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    boolean boundaryNear(S2Polygon b, double maxError) {
        if (this.numLoops() != b.numLoops()) {
            return false;
        }
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop aLoop = this.loop(i);
            boolean success = false;
            for (int j = 0; j < this.numLoops(); ++j) {
                S2Loop bLoop = b.loop(j);
                if (bLoop.depth() != aLoop.depth() || !bLoop.boundaryNear(aLoop, maxError)) continue;
                success = true;
                break;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    @Override
    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this.bound;
    }

    @Override
    public boolean contains(S2Cell cell) {
        S2ShapeIndex.CellIterator it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(cell.id());
        if (relation != S2ShapeIndex.CellRelation.INDEXED) {
            return false;
        }
        if (this.boundaryApproxIntersects(it, cell)) {
            return false;
        }
        return this.contains(it, cell.getCenter());
    }

    @Override
    public boolean mayIntersect(S2Cell target) {
        S2ShapeIndex.CellIterator it = this.index.iterator();
        S2ShapeIndex.CellRelation relation = it.locate(target.id());
        if (relation == S2ShapeIndex.CellRelation.DISJOINT) {
            return false;
        }
        if (relation == S2ShapeIndex.CellRelation.SUBDIVIDED) {
            return true;
        }
        if (this.boundaryApproxIntersects(it, target)) {
            return true;
        }
        return this.contains(it, target.getCenter());
    }

    private boolean boundaryApproxIntersects(S2ShapeIndex.CellIterator it, S2Cell target) {
        S2ShapeIndex.Cell cell = it.cell();
        R2Rect bound = target.getBoundUV().expanded(S2EdgeUtil.MAX_CELL_EDGE_ERROR);
        R2Vector v0 = new R2Vector();
        R2Vector v1 = new R2Vector();
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            int aNumClipped = aClipped.numEdges();
            if (aNumClipped == 0) continue;
            if (it.id().equals(target.id())) {
                return true;
            }
            S2Loop aLoop = (S2Loop)aClipped.shape();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                if (!S2EdgeUtil.clipToPaddedFace(aLoop.vertex(ai), aLoop.vertex(ai + 1), target.face(), S2EdgeUtil.MAX_CELL_EDGE_ERROR, v0, v1) || !S2EdgeUtil.intersectsRect(v0, v1, bound)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(S2Point p) {
        if (!this.index.isFresh() && !this.bound.contains(p)) {
            return false;
        }
        int maxBruteForceVertices = 32;
        if (this.getNumVertices() <= maxBruteForceVertices || !this.index.isFresh() && this.unindexedContainsCalls.decrementAndGet() > 0) {
            boolean inside = false;
            for (int i = 0; i < this.numLoops(); ++i) {
                boolean loopContainsP = this.loop(i).bruteForceContains(p);
                inside ^= loopContainsP;
            }
            return inside;
        }
        S2ShapeIndex.CellIterator it = this.index.iterator();
        if (!it.locate(p)) {
            return false;
        }
        return this.contains(it, p);
    }

    private boolean contains(S2ShapeIndex.CellIterator it, S2Point p) {
        S2ShapeIndex.Cell cell = it.cell();
        boolean inside = false;
        S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(it.center(), p);
        for (int a = 0; a < cell.numShapes(); ++a) {
            S2ShapeIndex.S2ClippedShape aClipped = cell.clipped(a);
            inside ^= aClipped.containsCenter();
            int aNumClipped = aClipped.numEdges();
            if (aNumClipped <= 0) continue;
            int aiPrev = -2;
            S2Loop aLoop = (S2Loop)aClipped.shape();
            for (int i = 0; i < aNumClipped; ++i) {
                int ai = aClipped.edge(i);
                if (ai != aiPrev + 1) {
                    crosser.restartAt(aLoop.vertex(ai));
                }
                aiPrev = ai;
                inside ^= crosser.edgeOrVertexCrossing(aLoop.vertex(ai + 1));
            }
        }
        return inside;
    }

    private static void sortValueLoops(Map<S2Loop, List<S2Loop>> loopMap) {
        for (S2Loop key : loopMap.keySet()) {
            Collections.sort(loopMap.get(key));
        }
    }

    private static void insertLoop(S2Loop newLoop, S2Loop parent, Map<S2Loop, List<S2Loop>> loopMap) {
        ArrayList children = loopMap.get(parent);
        if (children == null) {
            children = Lists.newArrayList();
            loopMap.put(parent, children);
        }
        for (S2Loop child : children) {
            if (!child.containsNested(newLoop)) continue;
            S2Polygon.insertLoop(newLoop, child, loopMap);
            return;
        }
        ArrayList newChildren = loopMap.get(newLoop);
        int i = 0;
        while (i < children.size()) {
            S2Loop child = (S2Loop)children.get(i);
            if (newLoop.containsNested(child)) {
                if (newChildren == null) {
                    newChildren = Lists.newArrayList();
                    loopMap.put(newLoop, newChildren);
                }
                newChildren.add(child);
                children.remove(i);
                continue;
            }
            ++i;
        }
        children.add(newLoop);
    }

    private void initLoop(S2Loop loop, int depth, Map<S2Loop, List<S2Loop>> loopMap) {
        List<S2Loop> children;
        if (loop != null) {
            loop.setDepth(depth);
            this.loops.add(loop);
        }
        if ((children = loopMap.get(loop)) != null) {
            for (S2Loop child : children) {
                this.initLoop(child, depth + 1, loopMap);
            }
        }
    }

    int compareBoundary(S2Loop b) {
        int result = -1;
        for (S2Loop loop : this.loops) {
            if ((result *= -loop.compareBoundary(b)) == 0) break;
        }
        return result;
    }

    private boolean containsBoundary(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (this.compareBoundary(loop) > 0) continue;
            return false;
        }
        return true;
    }

    private boolean excludesBoundary(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (this.compareBoundary(loop) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean containsNonCrossingBoundary(S2Loop b, boolean bReverse) {
        boolean inside = false;
        for (S2Loop loop : this.loops) {
            inside ^= loop.containsNonCrossingBoundary(b, bReverse);
        }
        return inside;
    }

    private boolean excludesNonCrossingShells(S2Polygon b) {
        for (S2Loop loop : b.loops) {
            if (loop.isHole() || !this.containsNonCrossingBoundary(loop, false)) continue;
            return false;
        }
        return true;
    }

    private boolean excludesNonCrossingComplementShells(S2Polygon b) {
        if (b.isEmpty()) {
            return !this.isFull();
        }
        if (b.isFull()) {
            return true;
        }
        for (int j = 0; j < b.numLoops(); ++j) {
            if (j > 0 && !b.loop(j).isHole() || !this.containsNonCrossingBoundary(b.loop(j), j == 0)) continue;
            return false;
        }
        return true;
    }

    private boolean anyLoopContains(S2Loop b) {
        for (S2Loop loop : this.loops) {
            if (!loop.contains(b)) continue;
            return true;
        }
        return false;
    }

    private boolean anyLoopIntersects(S2Loop b) {
        for (S2Loop loop : this.loops) {
            if (!loop.intersects(b)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Polygon: (").append(this.numLoops()).append(") loops:\n");
        for (int i = 0; i < this.numLoops(); ++i) {
            S2Loop s2Loop = this.loop(i);
            sb.append("loop <\n");
            for (int v = 0; v < s2Loop.numVertices(); ++v) {
                S2Point s2Point = s2Loop.vertex(v);
                sb.append(s2Point.toDegreesString());
                sb.append("\n");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }

    private strictfp static class EdgeClipper {
        private final S2EdgeQuery query;
        private final boolean addSharedEdges;
        private final Predicate<S2Shape> reverseEdges;

        public EdgeClipper(S2ShapeIndex index, boolean addSharedEdges, Predicate<S2Shape> reverseEdges) {
            this.query = new S2EdgeQuery(index);
            this.addSharedEdges = addSharedEdges;
            this.reverseEdges = reverseEdges;
        }

        public void clipEdge(S2Point a0, S2Point a1, List<ParametrizedS2Point> intersections) {
            Map<S2Shape, S2EdgeQuery.Edges> edgeMap = this.query.getCandidates(a0, a1);
            if (edgeMap.isEmpty()) {
                return;
            }
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(a0, a1);
            S2Shape.MutableEdge result = new S2Shape.MutableEdge();
            for (Map.Entry<S2Shape, S2EdgeQuery.Edges> entry : edgeMap.entrySet()) {
                S2Shape bShape = entry.getKey();
                S2EdgeQuery.Edges edges = entry.getValue();
                int b1Prev = -2;
                while (!edges.isEmpty()) {
                    int crossing;
                    int edge = edges.nextEdge();
                    bShape.getEdge(edge, result);
                    if (edge != b1Prev + 1) {
                        crosser.restartAt(result.getStart());
                    }
                    if ((crossing = crosser.robustCrossing(result.getEnd())) < 0) continue;
                    this.addIntersection(a0, a1, result.getStart(), result.getEnd(), bShape, crossing, intersections);
                    b1Prev = edge;
                }
            }
        }

        private void addIntersection(S2Point a0, S2Point a1, S2Point b0, S2Point b1, S2Shape bShape, int crossing, List<ParametrizedS2Point> intersections) {
            if (crossing > 0) {
                S2Point x = S2EdgeUtil.getIntersection(a0, a1, b0, b1);
                double t = S2EdgeUtil.getDistanceFraction(x, a0, a1);
                intersections.add(new ParametrizedS2Point(t, x));
            } else if (S2EdgeUtil.vertexCrossing(a0, a1, b0, b1)) {
                double t;
                double d = t = a0.equalsPoint(b0) || a0.equalsPoint(b1) ? 0.0 : 1.0;
                if (!this.addSharedEdges && a1.equalsPoint(this.reverseEdges.apply((Object)bShape) ? b0 : b1)) {
                    t = 1.0;
                }
                intersections.add(new ParametrizedS2Point(t, t == 0.0 ? a0 : a1));
            }
        }
    }

    @GwtCompatible(serializable=false)
    private strictfp static final class LoopVertexIndexPair {
        private final int loopIndex;
        private final int vertexIndex;

        public LoopVertexIndexPair(int loopIndex, int vertexIndex) {
            this.loopIndex = loopIndex;
            this.vertexIndex = vertexIndex;
        }

        public int getLoopIndex() {
            return this.loopIndex;
        }

        public int getVertexIndex() {
            return this.vertexIndex;
        }
    }

    public strictfp static final class S2PolygonIndex
    extends S2LoopSequenceIndex {
        private final S2Polygon poly;
        private final boolean reverse;

        private static int[] getVertices(S2Polygon poly) {
            int[] vertices = new int[poly.numLoops()];
            for (int i = 0; i < vertices.length; ++i) {
                vertices[i] = poly.loop(i).numVertices();
            }
            return vertices;
        }

        public S2PolygonIndex(S2Polygon poly) {
            this(poly, false);
        }

        S2PolygonIndex(S2Polygon poly, boolean reverse) {
            super(S2PolygonIndex.getVertices(poly));
            this.poly = poly;
            this.reverse = reverse;
        }

        @Override
        public S2Edge edgeFromTo(int index) {
            int toIndex;
            int fromIndex;
            LoopVertexIndexPair indices = this.decodeIndex(index);
            int loopIndex = indices.getLoopIndex();
            int vertexInLoop = indices.getVertexIndex();
            S2Loop loop = this.poly.loop(loopIndex);
            if (loop.isHole() ^ this.reverse) {
                fromIndex = loop.numVertices() - 1 - vertexInLoop;
                toIndex = 2 * loop.numVertices() - 2 - vertexInLoop;
            } else {
                fromIndex = vertexInLoop;
                toIndex = vertexInLoop + 1;
            }
            S2Point from = loop.vertex(fromIndex);
            S2Point to = loop.vertex(toIndex);
            return new S2Edge(from, to);
        }
    }

    private strictfp static abstract class S2LoopSequenceIndex
    extends S2EdgeIndex {
        private final int[] indexToLoop;
        private final int[] loopToFirstIndex;

        public S2LoopSequenceIndex(int[] numVertices) {
            int totalEdges = 0;
            for (int edges : numVertices) {
                totalEdges += edges;
            }
            this.indexToLoop = new int[totalEdges];
            this.loopToFirstIndex = new int[numVertices.length];
            totalEdges = 0;
            for (int j = 0; j < numVertices.length; ++j) {
                this.loopToFirstIndex[j] = totalEdges;
                for (int i = 0; i < numVertices[j]; ++i) {
                    this.indexToLoop[totalEdges] = j;
                    ++totalEdges;
                }
            }
        }

        public final LoopVertexIndexPair decodeIndex(int index) {
            int loopIndex = this.indexToLoop[index];
            int vertexInLoop = index - this.loopToFirstIndex[loopIndex];
            return new LoopVertexIndexPair(loopIndex, vertexInLoop);
        }

        @Override
        public final int getNumEdges() {
            return this.indexToLoop.length;
        }

        @Override
        public abstract S2Edge edgeFromTo(int var1);

        @Override
        public S2Point edgeFrom(int index) {
            return this.edgeFromTo(index).getStart();
        }

        @Override
        public S2Point edgeTo(int index) {
            return this.edgeFromTo(index).getEnd();
        }
    }
}

