/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public strictfp final class S1Angle
implements Comparable<S1Angle>,
Serializable {
    public static final double EARTH_RADIUS_METERS = 6367000.0;
    public static final S1Angle INFINITY = new S1Angle(Double.POSITIVE_INFINITY);
    public static final S1Angle ZERO = new S1Angle();
    private final double radians;

    public double radians() {
        return this.radians;
    }

    public double degrees() {
        return this.radians * 57.29577951308232;
    }

    public long e5() {
        return Math.round(this.degrees() * 100000.0);
    }

    public long e6() {
        return Math.round(this.degrees() * 1000000.0);
    }

    public long e7() {
        return Math.round(this.degrees() * 1.0E7);
    }

    public S1Angle() {
        this.radians = 0.0;
    }

    private S1Angle(double radians) {
        this.radians = radians;
    }

    public S1Angle(S2Point x, S2Point y) {
        this.radians = x.angle(y);
    }

    public boolean equals(Object that) {
        if (that instanceof S1Angle) {
            return this.radians == ((S1Angle)that).radians;
        }
        return false;
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.radians);
        return (int)(value ^ value >>> 32);
    }

    public boolean lessThan(S1Angle that) {
        return this.radians < that.radians;
    }

    public boolean greaterThan(S1Angle that) {
        return this.radians > that.radians;
    }

    public boolean lessOrEquals(S1Angle that) {
        return this.radians <= that.radians;
    }

    public boolean greaterOrEquals(S1Angle that) {
        return this.radians >= that.radians;
    }

    public static S1Angle max(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? right : left;
    }

    public static S1Angle min(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? left : right;
    }

    public static S1Angle radians(double radians) {
        return new S1Angle(radians);
    }

    public static S1Angle degrees(double degrees) {
        return new S1Angle(degrees * (Math.PI / 180));
    }

    public static S1Angle e5(long e5) {
        return S1Angle.degrees((double)e5 * 1.0E-5);
    }

    public static S1Angle e6(long e6) {
        return S1Angle.degrees((double)e6 * 1.0E-6);
    }

    public static S1Angle e7(long e7) {
        return S1Angle.degrees((double)e7 * 1.0E-7);
    }

    public double distance(double radius) {
        return this.radians * radius;
    }

    public double earthDistance() {
        return this.radians * 6367000.0;
    }

    public S1Angle neg() {
        return new S1Angle(-this.radians);
    }

    public String toString() {
        double d = this.degrees();
        return new StringBuilder(25).append(d).append("d").toString();
    }

    @Override
    public int compareTo(S1Angle that) {
        return this.radians < that.radians ? -1 : (this.radians > that.radians ? 1 : 0);
    }
}

