/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A single tag suggestion with it's relevance information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoSuggestionsTagSuggestion extends com.google.api.client.json.GenericJson {

  /**
   * A set of video categories for which the tag is relevant. You can use this information to
   * display appropriate tag suggestions based on the video category that the video uploader
   * associates with the video. By default, tag suggestions are relevant for all categories if there
   * are no restricts defined for the keyword.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> categoryRestricts;

  /**
   * The keyword tag suggested for the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * A set of video categories for which the tag is relevant. You can use this information to
   * display appropriate tag suggestions based on the video category that the video uploader
   * associates with the video. By default, tag suggestions are relevant for all categories if there
   * are no restricts defined for the keyword.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCategoryRestricts() {
    return categoryRestricts;
  }

  /**
   * A set of video categories for which the tag is relevant. You can use this information to
   * display appropriate tag suggestions based on the video category that the video uploader
   * associates with the video. By default, tag suggestions are relevant for all categories if there
   * are no restricts defined for the keyword.
   * @param categoryRestricts categoryRestricts or {@code null} for none
   */
  public VideoSuggestionsTagSuggestion setCategoryRestricts(java.util.List<java.lang.String> categoryRestricts) {
    this.categoryRestricts = categoryRestricts;
    return this;
  }

  /**
   * The keyword tag suggested for the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * The keyword tag suggested for the video.
   * @param tag tag or {@code null} for none
   */
  public VideoSuggestionsTagSuggestion setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  @Override
  public VideoSuggestionsTagSuggestion set(String fieldName, Object value) {
    return (VideoSuggestionsTagSuggestion) super.set(fieldName, value);
  }

  @Override
  public VideoSuggestionsTagSuggestion clone() {
    return (VideoSuggestionsTagSuggestion) super.clone();
  }

}
