/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Information about a video stream.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoFileDetailsVideoStream extends com.google.api.client.json.GenericJson {

  /**
   * The video content's display aspect ratio, which specifies the aspect ratio in which the video
   * should be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double aspectRatio;

  /**
   * The video stream's bitrate, in bits per second.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger bitrateBps;

  /**
   * The video codec that the stream uses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String codec;

  /**
   * The video stream's frame rate, in frames per second.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double frameRateFps;

  /**
   * The encoded video content's height in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long heightPixels;

  /**
   * The amount that YouTube needs to rotate the original source content to properly display the
   * video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rotation;

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vendor;

  /**
   * The encoded video content's width in pixels. You can calculate the video's encoding aspect
   * ratio as width_pixels / height_pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long widthPixels;

  /**
   * The video content's display aspect ratio, which specifies the aspect ratio in which the video
   * should be displayed.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAspectRatio() {
    return aspectRatio;
  }

  /**
   * The video content's display aspect ratio, which specifies the aspect ratio in which the video
   * should be displayed.
   * @param aspectRatio aspectRatio or {@code null} for none
   */
  public VideoFileDetailsVideoStream setAspectRatio(java.lang.Double aspectRatio) {
    this.aspectRatio = aspectRatio;
    return this;
  }

  /**
   * The video stream's bitrate, in bits per second.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getBitrateBps() {
    return bitrateBps;
  }

  /**
   * The video stream's bitrate, in bits per second.
   * @param bitrateBps bitrateBps or {@code null} for none
   */
  public VideoFileDetailsVideoStream setBitrateBps(java.math.BigInteger bitrateBps) {
    this.bitrateBps = bitrateBps;
    return this;
  }

  /**
   * The video codec that the stream uses.
   * @return value or {@code null} for none
   */
  public java.lang.String getCodec() {
    return codec;
  }

  /**
   * The video codec that the stream uses.
   * @param codec codec or {@code null} for none
   */
  public VideoFileDetailsVideoStream setCodec(java.lang.String codec) {
    this.codec = codec;
    return this;
  }

  /**
   * The video stream's frame rate, in frames per second.
   * @return value or {@code null} for none
   */
  public java.lang.Double getFrameRateFps() {
    return frameRateFps;
  }

  /**
   * The video stream's frame rate, in frames per second.
   * @param frameRateFps frameRateFps or {@code null} for none
   */
  public VideoFileDetailsVideoStream setFrameRateFps(java.lang.Double frameRateFps) {
    this.frameRateFps = frameRateFps;
    return this;
  }

  /**
   * The encoded video content's height in pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Long getHeightPixels() {
    return heightPixels;
  }

  /**
   * The encoded video content's height in pixels.
   * @param heightPixels heightPixels or {@code null} for none
   */
  public VideoFileDetailsVideoStream setHeightPixels(java.lang.Long heightPixels) {
    this.heightPixels = heightPixels;
    return this;
  }

  /**
   * The amount that YouTube needs to rotate the original source content to properly display the
   * video.
   * @return value or {@code null} for none
   */
  public java.lang.String getRotation() {
    return rotation;
  }

  /**
   * The amount that YouTube needs to rotate the original source content to properly display the
   * video.
   * @param rotation rotation or {@code null} for none
   */
  public VideoFileDetailsVideoStream setRotation(java.lang.String rotation) {
    this.rotation = rotation;
    return this;
  }

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * @return value or {@code null} for none
   */
  public java.lang.String getVendor() {
    return vendor;
  }

  /**
   * A value that uniquely identifies a video vendor. Typically, the value is a four-letter vendor
   * code.
   * @param vendor vendor or {@code null} for none
   */
  public VideoFileDetailsVideoStream setVendor(java.lang.String vendor) {
    this.vendor = vendor;
    return this;
  }

  /**
   * The encoded video content's width in pixels. You can calculate the video's encoding aspect
   * ratio as width_pixels / height_pixels.
   * @return value or {@code null} for none
   */
  public java.lang.Long getWidthPixels() {
    return widthPixels;
  }

  /**
   * The encoded video content's width in pixels. You can calculate the video's encoding aspect
   * ratio as width_pixels / height_pixels.
   * @param widthPixels widthPixels or {@code null} for none
   */
  public VideoFileDetailsVideoStream setWidthPixels(java.lang.Long widthPixels) {
    this.widthPixels = widthPixels;
    return this;
  }

  @Override
  public VideoFileDetailsVideoStream set(String fieldName, Object value) {
    return (VideoFileDetailsVideoStream) super.set(fieldName, value);
  }

  @Override
  public VideoFileDetailsVideoStream clone() {
    return (VideoFileDetailsVideoStream) super.clone();
  }

}
