/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for VideoAgeGating.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoAgeGating extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether or not the video has alcoholic beverage content. Only users of legal
   * purchasing age in a particular country, as identified by ICAP, can view the content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean alcoholContent;

  /**
   * Age-restricted trailers. For redband trailers and adult-rated video-games. Only users aged 18+
   * can view the content. The the field is true the content is restricted to viewers aged 18+.
   * Otherwise The field won't be present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean restricted;

  /**
   * Video game rating, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String videoGameRating;

  /**
   * Indicates whether or not the video has alcoholic beverage content. Only users of legal
   * purchasing age in a particular country, as identified by ICAP, can view the content.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAlcoholContent() {
    return alcoholContent;
  }

  /**
   * Indicates whether or not the video has alcoholic beverage content. Only users of legal
   * purchasing age in a particular country, as identified by ICAP, can view the content.
   * @param alcoholContent alcoholContent or {@code null} for none
   */
  public VideoAgeGating setAlcoholContent(java.lang.Boolean alcoholContent) {
    this.alcoholContent = alcoholContent;
    return this;
  }

  /**
   * Age-restricted trailers. For redband trailers and adult-rated video-games. Only users aged 18+
   * can view the content. The the field is true the content is restricted to viewers aged 18+.
   * Otherwise The field won't be present.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRestricted() {
    return restricted;
  }

  /**
   * Age-restricted trailers. For redband trailers and adult-rated video-games. Only users aged 18+
   * can view the content. The the field is true the content is restricted to viewers aged 18+.
   * Otherwise The field won't be present.
   * @param restricted restricted or {@code null} for none
   */
  public VideoAgeGating setRestricted(java.lang.Boolean restricted) {
    this.restricted = restricted;
    return this;
  }

  /**
   * Video game rating, if any.
   * @return value or {@code null} for none
   */
  public java.lang.String getVideoGameRating() {
    return videoGameRating;
  }

  /**
   * Video game rating, if any.
   * @param videoGameRating videoGameRating or {@code null} for none
   */
  public VideoAgeGating setVideoGameRating(java.lang.String videoGameRating) {
    this.videoGameRating = videoGameRating;
    return this;
  }

  @Override
  public VideoAgeGating set(String fieldName, Object value) {
    return (VideoAgeGating) super.set(fieldName, value);
  }

  @Override
  public VideoAgeGating clone() {
    return (VideoAgeGating) super.clone();
  }

}
