/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A videoAbuseReportReason resource identifies a reason that a video could be reported as abusive.
 * Video abuse report reasons are used with video.ReportAbuse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoAbuseReportReason extends com.google.api.client.json.GenericJson {

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The ID of this abuse report reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "youtube#videoAbuseReportReason".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The snippet object contains basic details about the abuse report reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoAbuseReportReasonSnippet snippet;

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public VideoAbuseReportReason setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID of this abuse report reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of this abuse report reason.
   * @param id id or {@code null} for none
   */
  public VideoAbuseReportReason setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "youtube#videoAbuseReportReason".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "youtube#videoAbuseReportReason".
   * @param kind kind or {@code null} for none
   */
  public VideoAbuseReportReason setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The snippet object contains basic details about the abuse report reason.
   * @return value or {@code null} for none
   */
  public VideoAbuseReportReasonSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the abuse report reason.
   * @param snippet snippet or {@code null} for none
   */
  public VideoAbuseReportReason setSnippet(VideoAbuseReportReasonSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  @Override
  public VideoAbuseReportReason set(String fieldName, Object value) {
    return (VideoAbuseReportReason) super.set(fieldName, value);
  }

  @Override
  public VideoAbuseReportReason clone() {
    return (VideoAbuseReportReason) super.clone();
  }

}
