/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for VideoAbuseReport.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoAbuseReport extends com.google.api.client.json.GenericJson {

  /**
   * Additional comments regarding the abuse report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String comments;

  /**
   * The language that the content was viewed in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The high-level, or primary, reason that the content is abusive. The value is an abuse report
   * reason ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonId;

  /**
   * The specific, or secondary, reason that this content is abusive (if available). The value is an
   * abuse report reason ID that is a valid secondary reason for the primary reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String secondaryReasonId;

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String videoId;

  /**
   * Additional comments regarding the abuse report.
   * @return value or {@code null} for none
   */
  public java.lang.String getComments() {
    return comments;
  }

  /**
   * Additional comments regarding the abuse report.
   * @param comments comments or {@code null} for none
   */
  public VideoAbuseReport setComments(java.lang.String comments) {
    this.comments = comments;
    return this;
  }

  /**
   * The language that the content was viewed in.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The language that the content was viewed in.
   * @param language language or {@code null} for none
   */
  public VideoAbuseReport setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * The high-level, or primary, reason that the content is abusive. The value is an abuse report
   * reason ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonId() {
    return reasonId;
  }

  /**
   * The high-level, or primary, reason that the content is abusive. The value is an abuse report
   * reason ID.
   * @param reasonId reasonId or {@code null} for none
   */
  public VideoAbuseReport setReasonId(java.lang.String reasonId) {
    this.reasonId = reasonId;
    return this;
  }

  /**
   * The specific, or secondary, reason that this content is abusive (if available). The value is an
   * abuse report reason ID that is a valid secondary reason for the primary reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecondaryReasonId() {
    return secondaryReasonId;
  }

  /**
   * The specific, or secondary, reason that this content is abusive (if available). The value is an
   * abuse report reason ID that is a valid secondary reason for the primary reason.
   * @param secondaryReasonId secondaryReasonId or {@code null} for none
   */
  public VideoAbuseReport setSecondaryReasonId(java.lang.String secondaryReasonId) {
    this.secondaryReasonId = secondaryReasonId;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getVideoId() {
    return videoId;
  }

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * @param videoId videoId or {@code null} for none
   */
  public VideoAbuseReport setVideoId(java.lang.String videoId) {
    this.videoId = videoId;
    return this;
  }

  @Override
  public VideoAbuseReport set(String fieldName, Object value) {
    return (VideoAbuseReport) super.set(fieldName, value);
  }

  @Override
  public VideoAbuseReport clone() {
    return (VideoAbuseReport) super.clone();
  }

}
