/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * A video resource represents a YouTube video.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Video extends com.google.api.client.json.GenericJson {

  /**
   * Age restriction details related to a video. This data can only be retrieved by the video owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoAgeGating ageGating;

  /**
   * The contentDetails object contains information about the video content, including the length of
   * the video and its aspect ratio.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoContentDetails contentDetails;

  /**
   * Etag of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The fileDetails object encapsulates information about the video file that was uploaded to
   * YouTube, including the file's resolution, duration, audio and video codecs, stream bitrates,
   * and more. This data can only be retrieved by the video owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoFileDetails fileDetails;

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#video".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The liveStreamingDetails object contains metadata about a live video broadcast. The object will
   * only be present in a video resource if the video is an upcoming, live, or completed live
   * broadcast.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoLiveStreamingDetails liveStreamingDetails;

  /**
   * List with all localizations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, VideoLocalization> localizations;

  /**
   * The monetizationDetails object encapsulates information about the monetization status of the
   * video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoMonetizationDetails monetizationDetails;

  /**
   * The player object contains information that you would use to play the video in an embedded
   * player.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoPlayer player;

  /**
   * The processingDetails object encapsulates information about YouTube's progress in processing
   * the uploaded video file. The properties in the object identify the current processing status
   * and an estimate of the time remaining until YouTube finishes processing the video. This part
   * also indicates whether different types of data or content, such as file details or thumbnail
   * images, are available for the video.
   *
   * The processingProgress object is designed to be polled so that the video uploaded can track the
   * progress that YouTube has made in processing the uploaded video file. This data can only be
   * retrieved by the video owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoProcessingDetails processingDetails;

  /**
   * The projectDetails object contains information about the project specific video metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoProjectDetails projectDetails;

  /**
   * The recordingDetails object encapsulates information about the location, date and address where
   * the video was recorded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoRecordingDetails recordingDetails;

  /**
   * The snippet object contains basic details about the video, such as its title, description, and
   * category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoSnippet snippet;

  /**
   * The statistics object contains statistics about the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoStatistics statistics;

  /**
   * The status object contains information about the video's uploading, processing, and privacy
   * statuses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoStatus status;

  /**
   * The suggestions object encapsulates suggestions that identify opportunities to improve the
   * video quality or the metadata for the uploaded video. This data can only be retrieved by the
   * video owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoSuggestions suggestions;

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoTopicDetails topicDetails;

  /**
   * Age restriction details related to a video. This data can only be retrieved by the video owner.
   * @return value or {@code null} for none
   */
  public VideoAgeGating getAgeGating() {
    return ageGating;
  }

  /**
   * Age restriction details related to a video. This data can only be retrieved by the video owner.
   * @param ageGating ageGating or {@code null} for none
   */
  public Video setAgeGating(VideoAgeGating ageGating) {
    this.ageGating = ageGating;
    return this;
  }

  /**
   * The contentDetails object contains information about the video content, including the length of
   * the video and its aspect ratio.
   * @return value or {@code null} for none
   */
  public VideoContentDetails getContentDetails() {
    return contentDetails;
  }

  /**
   * The contentDetails object contains information about the video content, including the length of
   * the video and its aspect ratio.
   * @param contentDetails contentDetails or {@code null} for none
   */
  public Video setContentDetails(VideoContentDetails contentDetails) {
    this.contentDetails = contentDetails;
    return this;
  }

  /**
   * Etag of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Etag of this resource.
   * @param etag etag or {@code null} for none
   */
  public Video setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The fileDetails object encapsulates information about the video file that was uploaded to
   * YouTube, including the file's resolution, duration, audio and video codecs, stream bitrates,
   * and more. This data can only be retrieved by the video owner.
   * @return value or {@code null} for none
   */
  public VideoFileDetails getFileDetails() {
    return fileDetails;
  }

  /**
   * The fileDetails object encapsulates information about the video file that was uploaded to
   * YouTube, including the file's resolution, duration, audio and video codecs, stream bitrates,
   * and more. This data can only be retrieved by the video owner.
   * @param fileDetails fileDetails or {@code null} for none
   */
  public Video setFileDetails(VideoFileDetails fileDetails) {
    this.fileDetails = fileDetails;
    return this;
  }

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID that YouTube uses to uniquely identify the video.
   * @param id id or {@code null} for none
   */
  public Video setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#video".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "youtube#video".
   * @param kind kind or {@code null} for none
   */
  public Video setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The liveStreamingDetails object contains metadata about a live video broadcast. The object will
   * only be present in a video resource if the video is an upcoming, live, or completed live
   * broadcast.
   * @return value or {@code null} for none
   */
  public VideoLiveStreamingDetails getLiveStreamingDetails() {
    return liveStreamingDetails;
  }

  /**
   * The liveStreamingDetails object contains metadata about a live video broadcast. The object will
   * only be present in a video resource if the video is an upcoming, live, or completed live
   * broadcast.
   * @param liveStreamingDetails liveStreamingDetails or {@code null} for none
   */
  public Video setLiveStreamingDetails(VideoLiveStreamingDetails liveStreamingDetails) {
    this.liveStreamingDetails = liveStreamingDetails;
    return this;
  }

  /**
   * List with all localizations.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, VideoLocalization> getLocalizations() {
    return localizations;
  }

  /**
   * List with all localizations.
   * @param localizations localizations or {@code null} for none
   */
  public Video setLocalizations(java.util.Map<String, VideoLocalization> localizations) {
    this.localizations = localizations;
    return this;
  }

  /**
   * The monetizationDetails object encapsulates information about the monetization status of the
   * video.
   * @return value or {@code null} for none
   */
  public VideoMonetizationDetails getMonetizationDetails() {
    return monetizationDetails;
  }

  /**
   * The monetizationDetails object encapsulates information about the monetization status of the
   * video.
   * @param monetizationDetails monetizationDetails or {@code null} for none
   */
  public Video setMonetizationDetails(VideoMonetizationDetails monetizationDetails) {
    this.monetizationDetails = monetizationDetails;
    return this;
  }

  /**
   * The player object contains information that you would use to play the video in an embedded
   * player.
   * @return value or {@code null} for none
   */
  public VideoPlayer getPlayer() {
    return player;
  }

  /**
   * The player object contains information that you would use to play the video in an embedded
   * player.
   * @param player player or {@code null} for none
   */
  public Video setPlayer(VideoPlayer player) {
    this.player = player;
    return this;
  }

  /**
   * The processingDetails object encapsulates information about YouTube's progress in processing
   * the uploaded video file. The properties in the object identify the current processing status
   * and an estimate of the time remaining until YouTube finishes processing the video. This part
   * also indicates whether different types of data or content, such as file details or thumbnail
   * images, are available for the video.
   *
   * The processingProgress object is designed to be polled so that the video uploaded can track the
   * progress that YouTube has made in processing the uploaded video file. This data can only be
   * retrieved by the video owner.
   * @return value or {@code null} for none
   */
  public VideoProcessingDetails getProcessingDetails() {
    return processingDetails;
  }

  /**
   * The processingDetails object encapsulates information about YouTube's progress in processing
   * the uploaded video file. The properties in the object identify the current processing status
   * and an estimate of the time remaining until YouTube finishes processing the video. This part
   * also indicates whether different types of data or content, such as file details or thumbnail
   * images, are available for the video.
   *
   * The processingProgress object is designed to be polled so that the video uploaded can track the
   * progress that YouTube has made in processing the uploaded video file. This data can only be
   * retrieved by the video owner.
   * @param processingDetails processingDetails or {@code null} for none
   */
  public Video setProcessingDetails(VideoProcessingDetails processingDetails) {
    this.processingDetails = processingDetails;
    return this;
  }

  /**
   * The projectDetails object contains information about the project specific video metadata.
   * @return value or {@code null} for none
   */
  public VideoProjectDetails getProjectDetails() {
    return projectDetails;
  }

  /**
   * The projectDetails object contains information about the project specific video metadata.
   * @param projectDetails projectDetails or {@code null} for none
   */
  public Video setProjectDetails(VideoProjectDetails projectDetails) {
    this.projectDetails = projectDetails;
    return this;
  }

  /**
   * The recordingDetails object encapsulates information about the location, date and address where
   * the video was recorded.
   * @return value or {@code null} for none
   */
  public VideoRecordingDetails getRecordingDetails() {
    return recordingDetails;
  }

  /**
   * The recordingDetails object encapsulates information about the location, date and address where
   * the video was recorded.
   * @param recordingDetails recordingDetails or {@code null} for none
   */
  public Video setRecordingDetails(VideoRecordingDetails recordingDetails) {
    this.recordingDetails = recordingDetails;
    return this;
  }

  /**
   * The snippet object contains basic details about the video, such as its title, description, and
   * category.
   * @return value or {@code null} for none
   */
  public VideoSnippet getSnippet() {
    return snippet;
  }

  /**
   * The snippet object contains basic details about the video, such as its title, description, and
   * category.
   * @param snippet snippet or {@code null} for none
   */
  public Video setSnippet(VideoSnippet snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The statistics object contains statistics about the video.
   * @return value or {@code null} for none
   */
  public VideoStatistics getStatistics() {
    return statistics;
  }

  /**
   * The statistics object contains statistics about the video.
   * @param statistics statistics or {@code null} for none
   */
  public Video setStatistics(VideoStatistics statistics) {
    this.statistics = statistics;
    return this;
  }

  /**
   * The status object contains information about the video's uploading, processing, and privacy
   * statuses.
   * @return value or {@code null} for none
   */
  public VideoStatus getStatus() {
    return status;
  }

  /**
   * The status object contains information about the video's uploading, processing, and privacy
   * statuses.
   * @param status status or {@code null} for none
   */
  public Video setStatus(VideoStatus status) {
    this.status = status;
    return this;
  }

  /**
   * The suggestions object encapsulates suggestions that identify opportunities to improve the
   * video quality or the metadata for the uploaded video. This data can only be retrieved by the
   * video owner.
   * @return value or {@code null} for none
   */
  public VideoSuggestions getSuggestions() {
    return suggestions;
  }

  /**
   * The suggestions object encapsulates suggestions that identify opportunities to improve the
   * video quality or the metadata for the uploaded video. This data can only be retrieved by the
   * video owner.
   * @param suggestions suggestions or {@code null} for none
   */
  public Video setSuggestions(VideoSuggestions suggestions) {
    this.suggestions = suggestions;
    return this;
  }

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * video.
   * @return value or {@code null} for none
   */
  public VideoTopicDetails getTopicDetails() {
    return topicDetails;
  }

  /**
   * The topicDetails object encapsulates information about Freebase topics associated with the
   * video.
   * @param topicDetails topicDetails or {@code null} for none
   */
  public Video setTopicDetails(VideoTopicDetails topicDetails) {
    this.topicDetails = topicDetails;
    return this;
  }

  @Override
  public Video set(String fieldName, Object value) {
    return (Video) super.set(fieldName, value);
  }

  @Override
  public Video clone() {
    return (Video) super.clone();
  }

}
