/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Internal representation of thumbnails for a YouTube resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ThumbnailDetails extends com.google.api.client.json.GenericJson {

  /**
   * The default image for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("default")
  private Thumbnail default__;

  /**
   * The high quality image for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail high;

  /**
   * The maximum resolution quality image for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail maxres;

  /**
   * The medium quality image for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail medium;

  /**
   * The standard quality image for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail standard;

  /**
   * The default image for this resource.
   * @return value or {@code null} for none
   */
  public Thumbnail getDefault() {
    return default__;
  }

  /**
   * The default image for this resource.
   * @param default__ default__ or {@code null} for none
   */
  public ThumbnailDetails setDefault(Thumbnail default__) {
    this.default__ = default__;
    return this;
  }

  /**
   * The high quality image for this resource.
   * @return value or {@code null} for none
   */
  public Thumbnail getHigh() {
    return high;
  }

  /**
   * The high quality image for this resource.
   * @param high high or {@code null} for none
   */
  public ThumbnailDetails setHigh(Thumbnail high) {
    this.high = high;
    return this;
  }

  /**
   * The maximum resolution quality image for this resource.
   * @return value or {@code null} for none
   */
  public Thumbnail getMaxres() {
    return maxres;
  }

  /**
   * The maximum resolution quality image for this resource.
   * @param maxres maxres or {@code null} for none
   */
  public ThumbnailDetails setMaxres(Thumbnail maxres) {
    this.maxres = maxres;
    return this;
  }

  /**
   * The medium quality image for this resource.
   * @return value or {@code null} for none
   */
  public Thumbnail getMedium() {
    return medium;
  }

  /**
   * The medium quality image for this resource.
   * @param medium medium or {@code null} for none
   */
  public ThumbnailDetails setMedium(Thumbnail medium) {
    this.medium = medium;
    return this;
  }

  /**
   * The standard quality image for this resource.
   * @return value or {@code null} for none
   */
  public Thumbnail getStandard() {
    return standard;
  }

  /**
   * The standard quality image for this resource.
   * @param standard standard or {@code null} for none
   */
  public ThumbnailDetails setStandard(Thumbnail standard) {
    this.standard = standard;
    return this;
  }

  @Override
  public ThumbnailDetails set(String fieldName, Object value) {
    return (ThumbnailDetails) super.set(fieldName, value);
  }

  @Override
  public ThumbnailDetails clone() {
    return (ThumbnailDetails) super.clone();
  }

}
