/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-15 at 06:51:14 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.youtube.model;

/**
 * Model definition for LiveStreamConfigurationIssue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the YouTube Data API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiveStreamConfigurationIssue extends com.google.api.client.json.GenericJson {

  /**
   * The long-form description of the issue and how to resolve it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The short-form reason for this issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * How severe this issue is to the stream.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * The kind of error happening.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The long-form description of the issue and how to resolve it.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The long-form description of the issue and how to resolve it.
   * @param description description or {@code null} for none
   */
  public LiveStreamConfigurationIssue setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The short-form reason for this issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The short-form reason for this issue.
   * @param reason reason or {@code null} for none
   */
  public LiveStreamConfigurationIssue setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * How severe this issue is to the stream.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * How severe this issue is to the stream.
   * @param severity severity or {@code null} for none
   */
  public LiveStreamConfigurationIssue setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * The kind of error happening.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The kind of error happening.
   * @param type type or {@code null} for none
   */
  public LiveStreamConfigurationIssue setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public LiveStreamConfigurationIssue set(String fieldName, Object value) {
    return (LiveStreamConfigurationIssue) super.set(fieldName, value);
  }

  @Override
  public LiveStreamConfigurationIssue clone() {
    return (LiveStreamConfigurationIssue) super.clone();
  }

}
